/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualTypeAliasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,79:1\n36#2:80\n*S KotlinDebug\n*F\n+ 1 FirActualTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker\n*L\n22#1:80\n*E\n"})
public final class FirActualTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirActualTypeAliasChecker INSTANCE = new FirActualTypeAliasChecker();

    private FirActualTypeAliasChecker() {
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isActual$iv = declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        FirTypeRef expandedTypeRef = declaration2.getExpandedTypeRef();
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(expandedTypeRef, context2.getSession());
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> expandedTypeSymbol = firClassLikeSymbol;
        if (expandedTypeSymbol instanceof FirTypeAliasSymbol) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_NOT_TO_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirTypeParameterSymbol typeParameterSymbol : expandedTypeSymbol.getTypeParameterSymbols()) {
            if (typeParameterSymbol.getVariance() == Variance.INVARIANT) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE(), (DiagnosticContext)context2, null, 8, null);
            break;
        }
        for (ConeTypeProjection typeArgument : FirTypeUtilsKt.getConeType(expandedTypeRef).getTypeArguments()) {
            if (typeArgument.getKind() == ProjectionKind.INVARIANT) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE(), (DiagnosticContext)context2, null, 8, null);
            break;
        }
        boolean reportActualTypeAliasWithComplexSubstitution = false;
        if (declaration2.getTypeParameters().size() != FirTypeUtilsKt.getConeType(expandedTypeRef).getTypeArguments().length) {
            reportActualTypeAliasWithComplexSubstitution = true;
        } else {
            int n = declaration2.getTypeParameters().size();
            for (int i = 0; i < n; ++i) {
                ConeTypeProjection typeArgument;
                typeArgument = FirTypeUtilsKt.getConeType(expandedTypeRef).getTypeArguments()[i];
                if (typeArgument instanceof ConeTypeParameterType) {
                    if (Intrinsics.areEqual(declaration2.getTypeParameters().get(i).getSymbol(), ((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol())) continue;
                    reportActualTypeAliasWithComplexSubstitution = true;
                    break;
                }
                if (!(typeArgument instanceof ConeKotlinType) || !(!(((ConeKotlinType)typeArgument).getTypeArguments().length == 0))) continue;
                reportActualTypeAliasWithComplexSubstitution = true;
                break;
            }
        }
        if (reportActualTypeAliasWithComplexSubstitution) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION(), (DiagnosticContext)context2, null, 8, null);
        }
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            if (FirTypeUtilsKt.isNothing(expandedTypeRef)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NOTHING(), (DiagnosticContext)context2, null, 8, null);
            }
            if (Intrinsics.areEqual(FirTypeUtilsKt.isMarkedNullable(expandedTypeRef), true)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NULLABLE_TYPE(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }
}

