/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J,\u0010\r\u001a\u00020\u000e*\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "checkReturnType", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "overriddenSymbols", "", "typeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "substituteAllTypeParameters", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "overrideDeclaration", "baseDeclaration", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOverrideChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n1547#2:458\n1618#2,3:459\n*S KotlinDebug\n*F\n+ 1 FirOverrideChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAbstractOverrideChecker\n*L\n84#1:458\n84#1:459,3\n*E\n"})
public abstract class FirAbstractOverrideChecker
extends FirDeclarationChecker<FirClass> {
    private final ConeKotlinType substituteAllTypeParameters(ConeKotlinType $this$substituteAllTypeParameters, FirCallableSymbol<?> overrideDeclaration, FirCallableSymbol<?> baseDeclaration, CheckerContext context2) {
        List<FirTypeParameterSymbol> overrideTypeParameters = overrideDeclaration.getTypeParameterSymbols();
        if (overrideTypeParameters.isEmpty()) {
            return $this$substituteAllTypeParameters;
        }
        List<FirTypeParameterSymbol> baseTypeParameters = baseDeclaration.getTypeParameterSymbols();
        Map map = new LinkedHashMap();
        int size = Math.min(overrideTypeParameters.size(), baseTypeParameters.size());
        for (int it = 0; it < size; ++it) {
            FirTypeParameterSymbol to = overrideTypeParameters.get(it);
            FirTypeParameterSymbol from2 = baseTypeParameters.get(it);
            map.put(from2, FirNestedClassifierScopeKt.toConeType(to));
        }
        return SubstitutorsKt.substitutorByMap(map, context2.getSession()).substituteOrSelf($this$substituteAllTypeParameters);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final FirCallableSymbol<?> checkReturnType(@NotNull FirCallableSymbol<?> $this$checkReturnType, @NotNull List<? extends FirCallableSymbol<?>> overriddenSymbols2, @NotNull TypeCheckerState typeCheckerState2, @NotNull CheckerContext context2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$checkReturnType, "<this>");
        Intrinsics.checkNotNullParameter(overriddenSymbols2, "overriddenSymbols");
        Intrinsics.checkNotNullParameter(typeCheckerState2, "typeCheckerState");
        Intrinsics.checkNotNullParameter(context2, "context");
        ConeKotlinType overridingReturnType = FirTypeUtilsKt.getConeType($this$checkReturnType.getResolvedReturnTypeRef());
        if (overridingReturnType instanceof ConeErrorType) {
            return null;
        }
        Iterable $this$map$iv = overriddenSymbols2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableSymbol firCallableSymbol = (FirCallableSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FirTypeUtilsKt.getConeType(context2.getReturnTypeCalculator().tryCalculateReturnType((FirCallableSymbol<?>)it)));
        }
        List bounds2 = (List)destination$iv$iv;
        int n = bounds2.size();
        for (int it = 0; it < n; ++it) {
            boolean isReturnTypeOkForOverride;
            FirCallableSymbol<?> overriddenDeclaration = overriddenSymbols2.get(it);
            ConeKotlinType overriddenReturnType = this.substituteAllTypeParameters((ConeKotlinType)bounds2.get(it), $this$checkReturnType, overriddenDeclaration, context2);
            boolean bl = isReturnTypeOkForOverride = overriddenDeclaration instanceof FirPropertySymbol && ((FirPropertySymbol)overriddenDeclaration).isVar() ? AbstractTypeChecker.INSTANCE.equalTypes(typeCheckerState2, overridingReturnType, overriddenReturnType) : AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeCheckerState2, (KotlinTypeMarker)overridingReturnType, (KotlinTypeMarker)overriddenReturnType, false, 8, null);
            if (isReturnTypeOkForOverride) continue;
            return overriddenDeclaration;
        }
        return null;
    }
}

