/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicFunction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IteratorNext;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "()V", "getKotlinPrimitiveClassName", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "getPrimitiveIteratorType", "primitiveClassName", "toCallable", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "signature", "Lorg/jetbrains/kotlin/resolve/jvm/jvmSignature/JvmMethodSignature;", "classCodegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ClassCodegen;", "backend.jvm.codegen"})
public final class IteratorNext
extends IntrinsicMethod {
    @NotNull
    public static final IteratorNext INSTANCE = new IteratorNext();

    private IteratorNext() {
    }

    @Override
    @NotNull
    public IntrinsicFunction toCallable(@NotNull IrFunctionAccessExpression expression2, @NotNull JvmMethodSignature signature, @NotNull ClassCodegen classCodegen) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(signature, "signature");
        Intrinsics.checkNotNullParameter(classCodegen, "classCodegen");
        Type type2 = AsmUtil.isBoxedPrimitiveType(signature.getReturnType()) ? AsmUtil.unboxType(signature.getReturnType()) : signature.getReturnType();
        Intrinsics.checkNotNull(type2);
        Type type3 = type2;
        JvmMethodSignature newSignature = IntrinsicMethod.Companion.newReturnType(signature, type3);
        Name primitiveClassName = this.getKotlinPrimitiveClassName(type3);
        return IntrinsicFunction.Companion.create(expression2, newSignature, classCodegen, CollectionsKt.listOf(this.getPrimitiveIteratorType(primitiveClassName)), (Function2<? super IntrinsicFunction, ? super InstructionAdapter, Unit>)new Function2<IntrinsicFunction, InstructionAdapter, Unit>(primitiveClassName, type3){
            final /* synthetic */ Name $primitiveClassName;
            final /* synthetic */ Type $type;
            {
                this.$primitiveClassName = $primitiveClassName;
                this.$type = $type;
                super(2);
            }

            public final void invoke(IntrinsicFunction $this$create, InstructionAdapter it) {
                Intrinsics.checkNotNullParameter($this$create, "$this$create");
                Intrinsics.checkNotNullParameter(it, "it");
                it.invokevirtual(IteratorNext.access$getPrimitiveIteratorType(IteratorNext.INSTANCE, this.$primitiveClassName).getInternalName(), "next" + this.$primitiveClassName.asString(), "()" + this.$type.getDescriptor(), false);
            }
        });
    }

    private final Name getKotlinPrimitiveClassName(Type type2) {
        return JvmPrimitiveType.get(type2.getClassName()).getPrimitiveType().getTypeName();
    }

    private final Type getPrimitiveIteratorType(Name primitiveClassName) {
        Name name2 = Name.identifier(primitiveClassName.asString() + "Iterator");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        Name iteratorName = name2;
        FqName fqName2 = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.child(iteratorName);
        Intrinsics.checkNotNullExpressionValue(fqName2, "child(...)");
        Type type2 = Type.getObjectType(JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(fqName2));
        Intrinsics.checkNotNullExpressionValue(type2, "getObjectType(...)");
        return type2;
    }

    public static final /* synthetic */ Type access$getPrimitiveIteratorType(IteratorNext $this, Name primitiveClassName) {
        return $this.getPrimitiveIteratorType(primitiveClassName);
    }
}

