/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.NumberCompare;
import org.jetbrains.kotlin.codegen.ObjectCompare;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/BooleanComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "op", "Lcom/intellij/psi/tree/IElementType;", "a", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "b", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "getA", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "getB", "getExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getOp", "()Lcom/intellij/psi/tree/IElementType;", "discard", "", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm.codegen"})
public final class BooleanComparison
extends BooleanValue {
    @NotNull
    private final IrFunctionAccessExpression expression;
    @NotNull
    private final IElementType op;
    @NotNull
    private final MaterialValue a;
    @NotNull
    private final MaterialValue b;

    public BooleanComparison(@NotNull IrFunctionAccessExpression expression2, @NotNull IElementType op, @NotNull MaterialValue a, @NotNull MaterialValue b) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(op, "op");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        super(a.getCodegen());
        this.expression = expression2;
        this.op = op;
        this.a = a;
        this.b = b;
    }

    @NotNull
    public final IrFunctionAccessExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public final IElementType getOp() {
        return this.op;
    }

    @NotNull
    public final MaterialValue getA() {
        return this.a;
    }

    @NotNull
    public final MaterialValue getB() {
        return this.b;
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        int opcode = this.a.getType().getSort() == 10 ? ObjectCompare.Companion.getObjectCompareOpcode(this.op) : NumberCompare.Companion.patchOpcode(NumberCompare.Companion.getNumberCompareOpcode(this.op), this.getMv(), this.op, this.a.getType());
        this.markLineNumber(this.expression);
        this.getMv().visitJumpInsn(opcode, target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Integer n;
        Intrinsics.checkNotNullParameter(target, "target");
        if (this.a.getType().getSort() == 10) {
            Integer n2 = BranchedValue.Companion.getNegatedOperations().get(ObjectCompare.Companion.getObjectCompareOpcode(this.op));
            Intrinsics.checkNotNull(n2);
            n = n2;
        } else {
            Integer n3 = BranchedValue.Companion.getNegatedOperations().get(NumberCompare.Companion.getNumberCompareOpcode(this.op));
            Intrinsics.checkNotNull(n3);
            n = NumberCompare.Companion.patchOpcode(((Number)n3).intValue(), this.getMv(), this.op, this.a.getType());
        }
        Integer n4 = n;
        Intrinsics.checkNotNull(n4);
        int opcode = ((Number)n4).intValue();
        this.markLineNumber(this.expression);
        this.getMv().visitJumpInsn(opcode, target);
    }

    @Override
    public void discard() {
        this.markLineNumber(this.expression);
        this.b.discard();
        this.a.discard();
    }
}

