/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.linkage.issues.IrSymbolTypeMismatchException;
import org.jetbrains.kotlin.backend.common.linkage.issues.NoDeserializerForModule;
import org.jetbrains.kotlin.backend.common.linkage.issues.SignatureIdNotFoundInModuleWithDependencies;
import org.jetbrains.kotlin.backend.common.linkage.issues.SymbolTypeMismatch;
import org.jetbrains.kotlin.backend.common.linkage.issues.UserVisibleIrModulesSupport;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLinker;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.overrides.IrLinkerFakeOverrideProvider;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrInterningService;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerWithBuiltIns;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbolKt;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbolKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\\\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u0012%\b\u0002\u0010\r\u001a\u001f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020PH\u0002J\u0006\u0010R\u001a\u00020NJ\u001e\u0010S\u001a\u00020\u001e2\u0006\u0010T\u001a\u00020U2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u001e0/H\u0014J.\u0010W\u001a\u00020\u001e2\u0006\u0010X\u001a\u00020\u00042\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020]0\\H$J\u0006\u0010^\u001a\u00020NJ$\u0010_\u001a\u00020U2\u0006\u0010X\u001a\u00020\u00042\u0006\u0010`\u001a\u00020Z2\f\u0010a\u001a\b\u0012\u0004\u0012\u00020\u001d0/J\u0016\u0010b\u001a\u00020U2\u0006\u0010X\u001a\u00020\u00042\u0006\u0010`\u001a\u00020ZJ\u0016\u0010c\u001a\u00020U2\u0006\u0010X\u001a\u00020\u00042\u0006\u0010`\u001a\u00020ZJ:\u0010d\u001a\u00020U2\u0006\u0010X\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010Z2\u0014\b\u0002\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020]0\\2\n\b\u0002\u0010f\u001a\u0004\u0018\u00010\u001dJ \u0010d\u001a\u00020U2\u0006\u0010X\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010Z2\u0006\u0010g\u001a\u00020\u001dJ\u0018\u0010h\u001a\u00020U2\u0006\u0010X\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010ZJ\u001a\u0010i\u001a\u0004\u0018\u00010j2\u0006\u0010k\u001a\u00020\u00102\u0006\u0010l\u001a\u00020mH\u0004J\u001e\u0010n\u001a\u00020\u00102\u0006\u0010o\u001a\u00020\u00112\u0006\u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020\u001eJ\u0096\u0001\u0010s\u001a\u00020N\"\n\b\u0000\u0010t\u0018\u0001*\u00020j\"\u001a\b\u0001\u0010u\u0018\u0001*\u0012\u0012\u0004\u0012\u0002Hw\u0012\u0004\u0012\u0002Ht\u0012\u0002\b\u00030v\"\u0014\b\u0002\u0010w\u0018\u0001*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002Ht0x2\u0006\u0010y\u001a\u0002Hu2\u0006\u0010z\u001a\u00020\u001028\b\b\u0010{\u001a2\u0012\u0013\u0012\u0011Ht\u00a2\u0006\f\b}\u0012\b\b~\u0012\u0004\b\b(O\u0012\u0013\u0012\u0011Ht\u00a2\u0006\f\b}\u0012\b\b~\u0012\u0004\b\b(Q\u0012\u0004\u0012\u00020N0|H\u0082\b\u00a2\u0006\u0002\u0010\u007fJ\t\u0010\u0080\u0001\u001a\u00020NH\u0002J\u0014\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u00012\u0006\u0010k\u001a\u00020\u0010H\u0002J\u0013\u0010\u0083\u0001\u001a\u0004\u0018\u00010j2\u0006\u0010k\u001a\u00020\u0010H\u0016J\u0013\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020jH\u0016J\u0019\u0010\u0087\u0001\u001a\u00020\u00102\u0007\u0010\u0088\u0001\u001a\u00020\u00112\u0007\u0010\u0089\u0001\u001a\u00020\u0010J\"\u0010\u008a\u0001\u001a\u00020N2\b\u0010T\u001a\u0004\u0018\u00010U2\r\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u0011\u0010\u008c\u0001\u001a\u00020m2\u0006\u0010X\u001a\u00020\u0004H$J\u0019\u0010\u008d\u0001\u001a\u00020\u001e2\u0006\u0010X\u001a\u00020\u00042\u0006\u0010r\u001a\u00020\u001eH\u0014J\u0011\u0010\u008e\u0001\u001a\u00020m2\u0006\u0010k\u001a\u00020\u0010H\u0014J\u0012\u0010\u008f\u0001\u001a\u00020N2\u0007\u0010\u0090\u0001\u001a\u00020mH\u0016J%\u0010\u0091\u0001\u001a\u00020\u00102\u0007\u0010\u0092\u0001\u001a\u00020\u00112\b\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0007\u0010g\u001a\u00030\u0095\u0001H\u0016J\u001a\u0010\u0096\u0001\u001a\u00020\u001e2\u0007\u0010\u0097\u0001\u001a\u00020\u00042\b\u0010o\u001a\u0004\u0018\u00010\u0011J\u0013\u0010\u0098\u0001\u001a\u00020q2\b\u0010\u0093\u0001\u001a\u00030\u0094\u0001H\u0002J\u001d\u0010\u0099\u0001\u001a\u0005\u0018\u00010\u009a\u00012\u0007\u0010\u009b\u0001\u001a\u00020j2\u0006\u0010o\u001a\u00020\u0011H\u0016J\u001d\u0010\u009c\u0001\u001a\u0005\u0018\u00010\u009d\u00012\u0007\u0010\u009b\u0001\u001a\u00020j2\u0006\u0010o\u001a\u00020\u0011H\u0016J\u0013\u0010\u009e\u0001\u001a\u0004\u0018\u00010j2\u0006\u0010k\u001a\u00020\u0010H\u0002R0\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u0015j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0010`\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cj\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e`\u001fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R-\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001cj\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R0\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u0015j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0010`\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0018R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00020'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R!\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u001e04j\b\u0012\u0004\u0012\u00020\u001e`5\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u0002098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R.\u0010\r\u001a\u001f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R-\u0010@\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0\u0015j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e`\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0018R\u0014\u0010B\u001a\u0004\u0018\u00010CX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u001e\u0010F\u001a\u0012\u0012\u0004\u0012\u00020\u00100Gj\b\u0012\u0004\u0012\u00020\u0010`HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010I\u001a\u00020J8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006\u009f\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "exportedDependencies", "", "symbolProcessor", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;Lkotlin/jvm/functions/Function3;)V", "actualSymbols", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getActualSymbols$ir_serialization_common", "()Ljava/util/HashMap;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "deserializersForModules", "Ljava/util/LinkedHashMap;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "Lkotlin/collections/LinkedHashMap;", "getDeserializersForModules", "()Ljava/util/LinkedHashMap;", "expectIdSignatureToActualIdSignature", "getExpectIdSignatureToActualIdSignature", "expectSymbols", "getExpectSymbols$ir_serialization_common", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/IrLinkerFakeOverrideProvider;", "internationService", "Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "getInternationService", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrInterningService;", "linkerExtensions", "", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$IrLinkerExtension;", "getMessageLogger", "()Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "modulesWithReachableTopLevels", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getModulesWithReachableTopLevels", "()Ljava/util/LinkedHashSet;", "partialLinkageSupport", "Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "getPartialLinkageSupport", "()Lorg/jetbrains/kotlin/backend/common/linkage/partial/PartialLinkageSupportForLinker;", "getSymbolProcessor", "()Lkotlin/jvm/functions/Function3;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "topLevelActualIdSignatureToModuleDeserializer", "getTopLevelActualIdSignatureToModuleDeserializer", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "triedToDeserializeDeclarationForSymbol", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "userVisibleIrModulesSupport", "Lorg/jetbrains/kotlin/backend/common/linkage/issues/UserVisibleIrModulesSupport;", "getUserVisibleIrModulesSupport", "()Lorg/jetbrains/kotlin/backend/common/linkage/issues/UserVisibleIrModulesSupport;", "actualizeIrFunction", "", "e", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "a", "clear", "createCurrentModuleDeserializer", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "strategyResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "deserializeAllReachableTopLevels", "deserializeDirtyFiles", "kotlinLibrary", "dirtyFiles", "deserializeFullModule", "deserializeHeadersWithInlineBodies", "deserializeIrModuleHeader", "deserializationStrategy", "_moduleName", "moduleName", "deserializeOnlyHeaderModule", "deserializeOrResolveDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "symbol", "allowSymbolsWithoutSignaturesFromOtherModule", "", "deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled", "idSignature", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "moduleDeserializer", "finalizeExpectActual", "Owner", "DelegatingSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrDelegatingSymbol;", "DelegateSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrBindableSymbol;", "expectSymbol", "actualSymbol", "actualizer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "(Lorg/jetbrains/kotlin/ir/symbols/IrDelegatingSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;Lkotlin/jvm/functions/Function2;)V", "finalizeExpectActualLinker", "findDeserializedDeclarationForSymbol", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDeclaration", "getFileOf", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "declaration", "handleExpectActualMapping", "idSig", "rawSymbol", "init", "extensions", "isBuiltInModule", "maybeWrapWithBuiltInAndInit", "platformSpecificSymbol", "postProcess", "inOrAfterLinkageStep", "resolveBySignatureInModule", "signature", "kind", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$TopLevelSymbolKind;", "Lorg/jetbrains/kotlin/name/Name;", "resolveModuleDeserializer", "module", "topLevelKindToSymbolKind", "tryReferencingPropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "parent", "tryReferencingSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "tryResolveCustomDeclaration", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nKotlinIrLinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinIrLinker.kt\norg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,408:1\n296#1,6:417\n296#1,6:423\n296#1,6:429\n296#1,6:435\n296#1,6:441\n1547#2:409\n1618#2,3:410\n1853#2,2:413\n1#3:415\n215#4:416\n216#4:447\n372#5,7:448\n*S KotlinDebug\n*F\n+ 1 KotlinIrLinker.kt\norg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker\n*L\n326#1:417,6\n328#1:423,6\n330#1:429,6\n332#1:435,6\n334#1:441,6\n201#1:409\n201#1:410,3\n208#1:413,2\n320#1:416\n320#1:447\n352#1:448,7\n*E\n"})
public abstract class KotlinIrLinker
implements IrDeserializer,
FileLocalAwareLinker {
    @Nullable
    private final ModuleDescriptor currentModule;
    @NotNull
    private final IrMessageLogger messageLogger;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<ModuleDescriptor> exportedDependencies;
    @NotNull
    private final Function3<IrSymbolDeserializer, IrSymbol, IdSignature, IrSymbol> symbolProcessor;
    @NotNull
    private final IrInterningService internationService;
    @NotNull
    private final LinkedHashMap<IdSignature, IdSignature> expectIdSignatureToActualIdSignature;
    @NotNull
    private final HashMap<IdSignature, IrModuleDeserializer> topLevelActualIdSignatureToModuleDeserializer;
    @NotNull
    private final HashMap<IdSignature, IrSymbol> expectSymbols;
    @NotNull
    private final HashMap<IdSignature, IrSymbol> actualSymbols;
    @NotNull
    private final LinkedHashSet<IrModuleDeserializer> modulesWithReachableTopLevels;
    @NotNull
    private final LinkedHashMap<String, IrModuleDeserializer> deserializersForModules;
    @NotNull
    private final HashSet<IrSymbol> triedToDeserializeDeclarationForSymbol;
    private Collection<? extends IrDeserializer.IrLinkerExtension> linkerExtensions;

    public KotlinIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull IrMessageLogger messageLogger, @NotNull IrBuiltIns builtIns2, @NotNull SymbolTable symbolTable, @NotNull List<? extends ModuleDescriptor> exportedDependencies, @NotNull Function3<? super IrSymbolDeserializer, ? super IrSymbol, ? super IdSignature, ? extends IrSymbol> symbolProcessor) {
        Intrinsics.checkNotNullParameter(messageLogger, "messageLogger");
        Intrinsics.checkNotNullParameter(builtIns2, "builtIns");
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(exportedDependencies, "exportedDependencies");
        Intrinsics.checkNotNullParameter(symbolProcessor, "symbolProcessor");
        this.currentModule = currentModule;
        this.messageLogger = messageLogger;
        this.builtIns = builtIns2;
        this.symbolTable = symbolTable;
        this.exportedDependencies = exportedDependencies;
        this.symbolProcessor = symbolProcessor;
        this.internationService = new IrInterningService();
        this.expectIdSignatureToActualIdSignature = new LinkedHashMap();
        this.topLevelActualIdSignatureToModuleDeserializer = new HashMap();
        this.expectSymbols = new HashMap();
        this.actualSymbols = new HashMap();
        this.modulesWithReachableTopLevels = new LinkedHashSet();
        this.deserializersForModules = new LinkedHashMap();
        this.triedToDeserializeDeclarationForSymbol = new HashSet();
    }

    public /* synthetic */ KotlinIrLinker(ModuleDescriptor moduleDescriptor, IrMessageLogger irMessageLogger, IrBuiltIns irBuiltIns, SymbolTable symbolTable, List list2, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function3 = 1.INSTANCE;
        }
        this(moduleDescriptor, irMessageLogger, irBuiltIns, symbolTable, list2, function3);
    }

    @NotNull
    public final IrMessageLogger getMessageLogger() {
        return this.messageLogger;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final Function3<IrSymbolDeserializer, IrSymbol, IdSignature, IrSymbol> getSymbolProcessor() {
        return this.symbolProcessor;
    }

    @NotNull
    public final IrInterningService getInternationService() {
        return this.internationService;
    }

    @NotNull
    public final LinkedHashMap<IdSignature, IdSignature> getExpectIdSignatureToActualIdSignature() {
        return this.expectIdSignatureToActualIdSignature;
    }

    @NotNull
    public final HashMap<IdSignature, IrModuleDeserializer> getTopLevelActualIdSignatureToModuleDeserializer() {
        return this.topLevelActualIdSignatureToModuleDeserializer;
    }

    @NotNull
    public final HashMap<IdSignature, IrSymbol> getExpectSymbols$ir_serialization_common() {
        return this.expectSymbols;
    }

    @NotNull
    public final HashMap<IdSignature, IrSymbol> getActualSymbols$ir_serialization_common() {
        return this.actualSymbols;
    }

    @NotNull
    public final LinkedHashSet<IrModuleDeserializer> getModulesWithReachableTopLevels() {
        return this.modulesWithReachableTopLevels;
    }

    @NotNull
    protected final LinkedHashMap<String, IrModuleDeserializer> getDeserializersForModules() {
        return this.deserializersForModules;
    }

    @NotNull
    public abstract IrLinkerFakeOverrideProvider getFakeOverrideBuilder();

    @Nullable
    public abstract TranslationPluginContext getTranslationPluginContext();

    @NotNull
    public PartialLinkageSupportForLinker getPartialLinkageSupport() {
        return PartialLinkageSupportForLinker.Companion.getDISABLED();
    }

    @NotNull
    protected UserVisibleIrModulesSupport getUserVisibleIrModulesSupport() {
        return UserVisibleIrModulesSupport.Companion.getDEFAULT();
    }

    @NotNull
    public final IrSymbol deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled(@NotNull IdSignature idSignature, @NotNull BinarySymbolData.SymbolKind symbolKind, @NotNull IrModuleDeserializer moduleDeserializer) {
        IrModuleDeserializer actualModuleDeserializer;
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        Intrinsics.checkNotNullParameter((Object)symbolKind, "symbolKind");
        Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
        IdSignature topLevelSignature = idSignature.topLevelSignature();
        IrModuleDeserializer irModuleDeserializer = actualModuleDeserializer = BasicIrModuleDeserializerKt.findModuleDeserializerForTopLevelId(moduleDeserializer, topLevelSignature);
        IrSymbol symbol2 = irModuleDeserializer != null ? irModuleDeserializer.tryDeserializeIrSymbol(idSignature, symbolKind) : null;
        IrSymbol irSymbol2 = symbol2;
        if (irSymbol2 == null) {
            KotlinIrLinker $this$deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled_u24lambda_u240 = this;
            boolean bl = false;
            if ($this$deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled_u24lambda_u240.getPartialLinkageSupport().isEnabled()) {
                irSymbol2 = IrSymbolDeserializerKt.referenceDeserializedSymbol($this$deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled_u24lambda_u240.symbolTable, null, symbolKind, idSignature);
            } else {
                Collection<IrModuleDeserializer> collection = $this$deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled_u24lambda_u240.deserializersForModules.values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                new SignatureIdNotFoundInModuleWithDependencies(idSignature, moduleDeserializer, collection, $this$deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled_u24lambda_u240.getUserVisibleIrModulesSupport()).raiseIssue($this$deserializeOrReturnUnboundIrSymbolIfPartialLinkageEnabled_u24lambda_u240.messageLogger);
                throw null;
            }
        }
        return irSymbol2;
    }

    @NotNull
    public final IrModuleDeserializer resolveModuleDeserializer(@NotNull ModuleDescriptor module2, @Nullable IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(module2, "module");
        IrModuleDeserializer irModuleDeserializer = this.deserializersForModules.get(module2.getName().asString());
        if (irModuleDeserializer == null) {
            Name name2 = module2.getName();
            Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
            new NoDeserializerForModule(name2, idSignature).raiseIssue(this.messageLogger);
            throw null;
        }
        return irModuleDeserializer;
    }

    @NotNull
    protected abstract IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor var1, @Nullable KotlinLibrary var2, @NotNull Function1<? super String, ? extends DeserializationStrategy> var3);

    protected abstract boolean isBuiltInModule(@NotNull ModuleDescriptor var1);

    public final void deserializeAllReachableTopLevels() {
        while (!((Collection)this.modulesWithReachableTopLevels).isEmpty()) {
            IrModuleDeserializer moduleDeserializer = (IrModuleDeserializer)CollectionsKt.first((Iterable)this.modulesWithReachableTopLevels);
            this.modulesWithReachableTopLevels.remove(moduleDeserializer);
            moduleDeserializer.deserializeReachableDeclarations();
        }
    }

    private final DeclarationDescriptor findDeserializedDeclarationForSymbol(IrSymbol symbol2) {
        if (!this.triedToDeserializeDeclarationForSymbol.add(symbol2)) {
            return null;
        }
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        IrModuleDeserializer moduleDeserializer = this.resolveModuleDeserializer(DescriptorUtilsKt.getModule(descriptor2), symbol2.getSignature());
        moduleDeserializer.declareIrSymbol(symbol2);
        this.deserializeAllReachableTopLevels();
        return symbol2.isBound() ? descriptor2 : null;
    }

    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return false;
    }

    private final IrDeclaration tryResolveCustomDeclaration(IrSymbol symbol2) {
        Object object;
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        if (descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return null;
        }
        TranslationPluginContext translationPluginContext = this.getTranslationPluginContext();
        if (translationPluginContext != null) {
            Object object2;
            block9: {
                Object object3;
                TranslationPluginContext ctx = translationPluginContext;
                boolean bl = false;
                Collection<? extends IrDeserializer.IrLinkerExtension> collection = this.linkerExtensions;
                if (collection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("linkerExtensions");
                    collection = null;
                }
                for (Object it : (Iterable)collection) {
                    boolean bl2 = false;
                    if ((it = it.resolveSymbol(symbol2, ctx)) == null) continue;
                    object3 = it;
                    break block9;
                }
                object3 = object2 = null;
            }
            if (object2 != null) {
                Object object4;
                Object it = object4 = object2;
                boolean bl = false;
                if (!Intrinsics.areEqual(symbol2.getOwner(), it)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                object = object4;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        return this.deserializeOrResolveDeclaration(symbol2, false);
    }

    @Nullable
    protected final IrDeclaration deserializeOrResolveDeclaration(@NotNull IrSymbol symbol2, boolean allowSymbolsWithoutSignaturesFromOtherModule) {
        block10: {
            block11: {
                Intrinsics.checkNotNullParameter(symbol2, "symbol");
                if (!allowSymbolsWithoutSignaturesFromOtherModule && !IrSymbolKt.isPublicApi(symbol2) && symbol2.getHasDescriptor() && !this.platformSpecificSymbol(symbol2) && DescriptorUtilsKt.getModule(symbol2.getDescriptor()) != this.currentModule) {
                    return null;
                }
                if (!symbol2.isBound()) {
                    try {
                        Object object = this.findDeserializedDeclarationForSymbol(symbol2);
                        if (object == null && (object = this.tryResolveCustomDeclaration(symbol2)) == null) {
                            return null;
                        }
                    }
                    catch (IrSymbolTypeMismatchException e) {
                        Collection<IrModuleDeserializer> collection = this.deserializersForModules.values();
                        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                        new SymbolTypeMismatch(e, collection, this.getUserVisibleIrModulesSupport()).raiseIssue(this.messageLogger);
                        throw null;
                    }
                }
                if (symbol2.isBound()) break block10;
                if (LegacyDescriptorUtilsKt.isExpectMember(symbol2.getDescriptor())) break block11;
                DeclarationDescriptor declarationDescriptor = symbol2.getDescriptor().getContainingDeclaration();
                boolean bl = declarationDescriptor != null ? LegacyDescriptorUtilsKt.isExpectMember(declarationDescriptor) : false;
                if (!bl) break block10;
            }
            return null;
        }
        if (!symbol2.isBound()) {
            return null;
        }
        IrSymbolOwner irSymbolOwner = symbol2.getOwner();
        Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        return (IrDeclaration)irSymbolOwner;
    }

    @NotNull
    public IrFile getFileOf(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        return IrUtilsKt.getFile(declaration2);
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        if (idSignature.isPubliclyVisible()) {
            return null;
        }
        IrFile file2 = this.getFileOf(parent2);
        ModuleDescriptor moduleDescriptor = file2.getModuleDescriptor();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @Nullable
    public IrPropertySymbol tryReferencingPropertyByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(idSignature, "idSignature");
        if (idSignature.isPubliclyVisible()) {
            return null;
        }
        IrFile file2 = this.getFileOf(parent2);
        ModuleDescriptor moduleDescriptor = file2.getModuleDescriptor();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referencePropertyByLocalSignature(file2, idSignature);
    }

    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter(moduleFragment, "moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        return new CurrentModuleDeserializer(moduleFragment, dependencies2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@Nullable IrModuleFragment moduleFragment, @NotNull Collection<? extends IrDeserializer.IrLinkerExtension> extensions) {
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        this.linkerExtensions = extensions;
        if (moduleFragment != null) {
            String $this$mapTo$iv$iv;
            Iterable $this$map$iv = moduleFragment.getDescriptor().getAllDependencyModules();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.resolveModuleDeserializer((ModuleDescriptor)it, null));
            }
            List currentModuleDependencies = (List)destination$iv$iv;
            IrModuleDeserializer currentModuleDeserializer = this.createCurrentModuleDeserializer(moduleFragment, currentModuleDependencies);
            Map map = this.deserializersForModules;
            String string2 = moduleFragment.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            $this$mapTo$iv$iv = string2;
            destination$iv$iv = this.maybeWrapWithBuiltInAndInit(moduleFragment.getDescriptor(), currentModuleDeserializer);
            map.put($this$mapTo$iv$iv, destination$iv$iv);
        }
        Collection<IrModuleDeserializer> collection = this.deserializersForModules.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
            boolean bl = false;
            it.init();
        }
    }

    public final void clear() {
        this.internationService.clear();
    }

    @Override
    public void postProcess(boolean inOrAfterLinkageStep) {
        this.finalizeExpectActualLinker();
        if (inOrAfterLinkageStep) {
            this.getPartialLinkageSupport().exploreClassifiers(this.getFakeOverrideBuilder());
        }
        this.getFakeOverrideBuilder().provideFakeOverrides();
        this.triedToDeserializeDeclarationForSymbol.clear();
        if (inOrAfterLinkageStep) {
            this.getPartialLinkageSupport().generateStubsAndPatchUsages(this.symbolTable, (Function0<? extends Sequence<? extends IrModuleFragment>>)new Function0<Sequence<? extends IrModuleFragment>>(this){
                final /* synthetic */ KotlinIrLinker this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final Sequence<IrModuleFragment> invoke() {
                    Collection<IrModuleDeserializer> collection = this.this$0.getDeserializersForModules().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    return SequencesKt.map(CollectionsKt.asSequence((Iterable)collection), postProcess.1.INSTANCE);
                }
            });
        }
    }

    @NotNull
    public final IrSymbol handleExpectActualMapping(@NotNull IdSignature idSig, @NotNull IrSymbol rawSymbol) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter(idSig, "idSig");
        Intrinsics.checkNotNullParameter(rawSymbol, "rawSymbol");
        if (this.expectIdSignatureToActualIdSignature.values().contains(idSig)) {
            ((Map)this.actualSymbols).put(idSig, rawSymbol);
        }
        if ((idSignature = this.expectIdSignatureToActualIdSignature.get(idSig)) != null) {
            IdSignature actualSig = idSignature;
            boolean bl = false;
            IdSignature $this$handleExpectActualMapping_u24lambda_u248_u24lambda_u246 = idSig;
            boolean bl2 = false;
            boolean bl3 = $this$handleExpectActualMapping_u24lambda_u248_u24lambda_u246.test(IdSignature.Flags.IS_EXPECT);
            if (_Assertions.ENABLED && !bl3) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            IrDelegatingSymbol<? extends IrBindableSymbol<?, ? extends IrDeclaration>, ? extends IrDeclaration, ?> referencingSymbol = IrDelegatingSymbolKt.wrapInDelegatedSymbol(rawSymbol);
            ((Map)this.expectSymbols).put(idSig, referencingSymbol);
            IrModuleDeserializer irModuleDeserializer = this.topLevelActualIdSignatureToModuleDeserializer.get(actualSig);
            if (irModuleDeserializer != null) {
                IrModuleDeserializer moduleDeserializer = irModuleDeserializer;
                boolean bl4 = false;
                IrSymbol actualSymbol = this.actualSymbols.get(actualSig);
                if (actualSymbol == null || !actualSymbol.isBound()) {
                    moduleDeserializer.addModuleReachableTopLevel(actualSig);
                }
            }
            return referencingSymbol;
        }
        return rawSymbol;
    }

    private final BinarySymbolData.SymbolKind topLevelKindToSymbolKind(IrDeserializer.TopLevelSymbolKind kind) {
        BinarySymbolData.SymbolKind symbolKind;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                break;
            }
            case 2: {
                symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
                break;
            }
            case 3: {
                symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                break;
            }
            case 4: {
                symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbolKind;
    }

    @Override
    @NotNull
    public IrSymbol resolveBySignatureInModule(@NotNull IdSignature signature, @NotNull IrDeserializer.TopLevelSymbolKind kind, @NotNull Name moduleName) {
        IrSymbol irSymbol2;
        Object object;
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter(signature, "signature");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            Set<Map.Entry<String, IrModuleDeserializer>> set = this.deserializersForModules.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-entries>(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), moduleName.asString())) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((object = (Map.Entry)v1) == null || (object = (IrModuleDeserializer)object.getValue()) == null) {
            throw new IllegalStateException(("No module for name '" + moduleName + "' found").toString());
        }
        Object moduleDeserializer = object;
        boolean bl = Intrinsics.areEqual(signature, signature.topLevelSignature());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22 = false;
            String $i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22 = "Signature '" + signature + "' has to be top level";
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22);
        }
        if (!((IrModuleDeserializer)moduleDeserializer).contains(signature)) {
            throw new IllegalStateException(("No signature " + signature + " in module " + moduleName).toString());
        }
        IrSymbol it = irSymbol2 = IrModuleDeserializerKt.deserializeIrSymbolOrFail((IrModuleDeserializer)moduleDeserializer, signature, this.topLevelKindToSymbolKind(kind));
        boolean bl2 = false;
        this.deserializeAllReachableTopLevels();
        return irSymbol2;
    }

    private final /* synthetic */ <Owner extends IrDeclaration, DelegatingSymbol extends IrDelegatingSymbol<DelegateSymbol, Owner, ?>, DelegateSymbol extends IrBindableSymbol<?, Owner>> void finalizeExpectActual(DelegatingSymbol expectSymbol, IrSymbol actualSymbol, Function2<? super Owner, ? super Owner, Unit> actualizer) {
        boolean $i$f$finalizeExpectActual = false;
        Intrinsics.reifiedOperationMarker(3, "DelegateSymbol");
        if (!(actualSymbol instanceof IrBindableSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        IrDeclaration expectDeclaration = (IrDeclaration)expectSymbol.getOwner();
        IrDeclaration actualDeclaration = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
        actualizer.invoke(expectDeclaration, actualDeclaration);
        expectSymbol.setDelegate((IrBindableSymbol)((IrBindableSymbol)actualSymbol));
    }

    private final void actualizeIrFunction(IrFunction e, IrFunction a) {
        int n = e.getValueParameters().size();
        for (int i = 0; i < n; ++i) {
            IrValueParameter evp = e.getValueParameters().get(i);
            IrValueParameter avp = a.getValueParameters().get(i);
            IrExpressionBody defaultValue = evp.getDefaultValue();
            if (avp.getDefaultValue() != null || defaultValue == null) continue;
            avp.setDefaultValue((IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)defaultValue, a));
            evp.setDefaultValue(null);
        }
    }

    private final void finalizeExpectActualLinker() {
        Map $this$forEach$iv = this.expectIdSignatureToActualIdSignature;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            KotlinIrLinker this_$iv;
            Object actualDeclaration$iv;
            IrDeclaration expectDeclaration$iv;
            IrDelegatingSymbol expectSymbol$iv;
            boolean $i$f$finalizeExpectActual;
            Function2 actualizer$iv;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            IrSymbol expectSymbol = this.expectSymbols.get(it.getKey());
            IrSymbol actualSymbol = this.actualSymbols.get(it.getValue());
            if (expectSymbol == null || actualSymbol == null) continue;
            IrSymbol irSymbol2 = expectSymbol;
            if (irSymbol2 instanceof IrDelegatingClassSymbolImpl) {
                KotlinIrLinker kotlinIrLinker = this;
                IrDelegatingSymbol irDelegatingSymbol = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = finalizeExpectActualLinker.1.1.INSTANCE;
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrClassSymbol)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke(expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingEnumEntrySymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = finalizeExpectActualLinker.1.2.INSTANCE;
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrEnumEntrySymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke(expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingSimpleFunctionSymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = new Function2<IrSimpleFunction, IrSimpleFunction, Unit>(this){
                    final /* synthetic */ KotlinIrLinker this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(IrSimpleFunction e, IrSimpleFunction a) {
                        Intrinsics.checkNotNullParameter(e, "e");
                        Intrinsics.checkNotNullParameter(a, "a");
                        KotlinIrLinker.access$actualizeIrFunction(this.this$0, e, a);
                    }
                };
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrSimpleFunctionSymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke(expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingConstructorSymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = new Function2<IrConstructor, IrConstructor, Unit>(this){
                    final /* synthetic */ KotlinIrLinker this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(IrConstructor e, IrConstructor a) {
                        Intrinsics.checkNotNullParameter(e, "e");
                        Intrinsics.checkNotNullParameter(a, "a");
                        KotlinIrLinker.access$actualizeIrFunction(this.this$0, e, a);
                    }
                };
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrConstructorSymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke(expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingPropertySymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = finalizeExpectActualLinker.1.5.INSTANCE;
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrPropertySymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke(expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            throw new IllegalStateException(("Unexpected expect symbol kind during actualization: " + expectSymbol).toString());
        }
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull Function1<? super String, ? extends DeserializationStrategy> deserializationStrategy2, @Nullable String _moduleName) {
        Object object;
        Object object2;
        block8: {
            block7: {
                boolean bl;
                Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
                Intrinsics.checkNotNullParameter(deserializationStrategy2, "deserializationStrategy");
                boolean bl2 = bl = kotlinLibrary != null || _moduleName != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42 = false;
                    String $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42 = "Either library or explicit name have to be provided " + moduleDescriptor;
                    throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42);
                }
                object2 = kotlinLibrary;
                if (object2 == null || (object2 = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)object2)) == null) break block7;
                Object it = object2;
                boolean bl3 = false;
                String string2 = '<' + (String)it + '>';
                object2 = string2;
                if (string2 != null) break block8;
            }
            String string3 = _moduleName;
            object2 = string3;
            Intrinsics.checkNotNull(string3);
        }
        Object moduleName = object2;
        boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42 = Intrinsics.areEqual(moduleDescriptor.getName().asString(), moduleName);
        if (_Assertions.ENABLED && !$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42) {
            boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$52 = false;
            String $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$52 = moduleDescriptor.getName().asString() + " != " + (String)moduleName;
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$52);
        }
        Map $this$getOrPut$iv = this.deserializersForModules;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(moduleName);
        if (value$iv == null) {
            boolean bl = false;
            IrModuleDeserializer answer$iv = this.maybeWrapWithBuiltInAndInit(moduleDescriptor, this.createModuleDeserializer(moduleDescriptor, kotlinLibrary, deserializationStrategy2));
            $this$getOrPut$iv.put(moduleName, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        IrModuleDeserializer deserializerForModule = (IrModuleDeserializer)object;
        return deserializerForModule.getModuleFragment();
    }

    public static /* synthetic */ IrModuleFragment deserializeIrModuleHeader$default(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, KotlinLibrary kotlinLibrary, Function1 function1, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deserializeIrModuleHeader");
        }
        if ((n & 4) != 0) {
            function1 = deserializeIrModuleHeader.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return kotlinIrLinker.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, function1, string2);
    }

    @NotNull
    protected IrModuleDeserializer maybeWrapWithBuiltInAndInit(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
        return this.isBuiltInModule(moduleDescriptor) ? (IrModuleDeserializer)new IrModuleDeserializerWithBuiltIns(this.builtIns, moduleDeserializer) : moduleDeserializer;
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Function1 deserializationStrategy2 = this.exportedDependencies.contains(moduleDescriptor) ? (Function1)deserializeIrModuleHeader.deserializationStrategy.1.INSTANCE : (Function1)deserializeIrModuleHeader.deserializationStrategy.2.INSTANCE;
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, deserializationStrategy2, moduleName);
    }

    @NotNull
    public final IrModuleFragment deserializeFullModule(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(kotlinLibrary, "kotlinLibrary");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, deserializeFullModule.1.INSTANCE, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeOnlyHeaderModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, deserializeOnlyHeaderModule.1.INSTANCE, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeHeadersWithInlineBodies(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(kotlinLibrary, "kotlinLibrary");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, deserializeHeadersWithInlineBodies.1.INSTANCE, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeDirtyFiles(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary, @NotNull Collection<String> dirtyFiles) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(kotlinLibrary, "kotlinLibrary");
        Intrinsics.checkNotNullParameter(dirtyFiles, "dirtyFiles");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, new Function1<String, DeserializationStrategy>(dirtyFiles){
            final /* synthetic */ Collection<String> $dirtyFiles;
            {
                this.$dirtyFiles = $dirtyFiles;
                super(1);
            }

            public final DeserializationStrategy invoke(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$dirtyFiles.contains(it) ? DeserializationStrategy.ALL : DeserializationStrategy.WITH_INLINE_BODIES;
            }
        }, null, 8, null);
    }

    @Override
    @Deprecated(message="Use postProcess(inOrAfterLinkageStep) instead", replaceWith=@ReplaceWith(expression="postProcess(inOrAfterLinkageStep = true)", imports={}), level=DeprecationLevel.ERROR)
    public void postProcess() {
        IrDeserializer.DefaultImpls.postProcess(this);
    }

    public static final /* synthetic */ void access$actualizeIrFunction(KotlinIrLinker $this, IrFunction e, IrFunction a) {
        $this.actualizeIrFunction(e, a);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrDeserializer.TopLevelSymbolKind.values().length];
            try {
                nArray[IrDeserializer.TopLevelSymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeserializer.TopLevelSymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeserializer.TopLevelSymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDeserializer.TopLevelSymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

