/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B]\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0003\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003H\u00c6\u0003J\u001b\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0003H\u00c6\u0003J\u0017\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003H\u00c6\u0003Ji\u0010\u0018\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00032\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00032\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u0004J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "", "actualClasses", "", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualTypeAliases", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "actualTopLevels", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbolsToFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getActualClasses", "()Ljava/util/Map;", "getActualSymbolsToFile", "getActualTopLevels", "getActualTypeAliases", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getActualWithoutExpansion", "classId", "hashCode", "", "toString", "", "ir.actualization"})
public final class ClassActualizationInfo {
    @NotNull
    private final Map<ClassId, IrClassSymbol> actualClasses;
    @NotNull
    private final Map<ClassId, IrTypeAliasSymbol> actualTypeAliases;
    @NotNull
    private final Map<CallableId, List<IrSymbol>> actualTopLevels;
    @NotNull
    private final Map<IrSymbol, IrFile> actualSymbolsToFile;

    public ClassActualizationInfo(@NotNull Map<ClassId, ? extends IrClassSymbol> actualClasses, @NotNull Map<ClassId, ? extends IrTypeAliasSymbol> actualTypeAliases, @NotNull Map<CallableId, ? extends List<? extends IrSymbol>> actualTopLevels, @NotNull Map<IrSymbol, ? extends IrFile> actualSymbolsToFile) {
        Intrinsics.checkNotNullParameter(actualClasses, "actualClasses");
        Intrinsics.checkNotNullParameter(actualTypeAliases, "actualTypeAliases");
        Intrinsics.checkNotNullParameter(actualTopLevels, "actualTopLevels");
        Intrinsics.checkNotNullParameter(actualSymbolsToFile, "actualSymbolsToFile");
        this.actualClasses = actualClasses;
        this.actualTypeAliases = actualTypeAliases;
        this.actualTopLevels = actualTopLevels;
        this.actualSymbolsToFile = actualSymbolsToFile;
    }

    @NotNull
    public final Map<ClassId, IrClassSymbol> getActualClasses() {
        return this.actualClasses;
    }

    @NotNull
    public final Map<ClassId, IrTypeAliasSymbol> getActualTypeAliases() {
        return this.actualTypeAliases;
    }

    @NotNull
    public final Map<CallableId, List<IrSymbol>> getActualTopLevels() {
        return this.actualTopLevels;
    }

    @NotNull
    public final Map<IrSymbol, IrFile> getActualSymbolsToFile() {
        return this.actualSymbolsToFile;
    }

    @Nullable
    public final IrSymbol getActualWithoutExpansion(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        IrTypeAliasSymbol irTypeAliasSymbol = this.actualTypeAliases.get(classId);
        return irTypeAliasSymbol != null ? (IrSymbol)irTypeAliasSymbol : (IrSymbol)this.actualClasses.get(classId);
    }

    @NotNull
    public final Map<ClassId, IrClassSymbol> component1() {
        return this.actualClasses;
    }

    @NotNull
    public final Map<ClassId, IrTypeAliasSymbol> component2() {
        return this.actualTypeAliases;
    }

    @NotNull
    public final Map<CallableId, List<IrSymbol>> component3() {
        return this.actualTopLevels;
    }

    @NotNull
    public final Map<IrSymbol, IrFile> component4() {
        return this.actualSymbolsToFile;
    }

    @NotNull
    public final ClassActualizationInfo copy(@NotNull Map<ClassId, ? extends IrClassSymbol> actualClasses, @NotNull Map<ClassId, ? extends IrTypeAliasSymbol> actualTypeAliases, @NotNull Map<CallableId, ? extends List<? extends IrSymbol>> actualTopLevels, @NotNull Map<IrSymbol, ? extends IrFile> actualSymbolsToFile) {
        Intrinsics.checkNotNullParameter(actualClasses, "actualClasses");
        Intrinsics.checkNotNullParameter(actualTypeAliases, "actualTypeAliases");
        Intrinsics.checkNotNullParameter(actualTopLevels, "actualTopLevels");
        Intrinsics.checkNotNullParameter(actualSymbolsToFile, "actualSymbolsToFile");
        return new ClassActualizationInfo(actualClasses, actualTypeAliases, actualTopLevels, actualSymbolsToFile);
    }

    public static /* synthetic */ ClassActualizationInfo copy$default(ClassActualizationInfo classActualizationInfo, Map map, Map map2, Map map3, Map map4, int n, Object object) {
        if ((n & 1) != 0) {
            map = classActualizationInfo.actualClasses;
        }
        if ((n & 2) != 0) {
            map2 = classActualizationInfo.actualTypeAliases;
        }
        if ((n & 4) != 0) {
            map3 = classActualizationInfo.actualTopLevels;
        }
        if ((n & 8) != 0) {
            map4 = classActualizationInfo.actualSymbolsToFile;
        }
        return classActualizationInfo.copy(map, map2, map3, map4);
    }

    @NotNull
    public String toString() {
        return "ClassActualizationInfo(actualClasses=" + this.actualClasses + ", actualTypeAliases=" + this.actualTypeAliases + ", actualTopLevels=" + this.actualTopLevels + ", actualSymbolsToFile=" + this.actualSymbolsToFile + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.actualClasses).hashCode();
        result2 = result2 * 31 + ((Object)this.actualTypeAliases).hashCode();
        result2 = result2 * 31 + ((Object)this.actualTopLevels).hashCode();
        result2 = result2 * 31 + ((Object)this.actualSymbolsToFile).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassActualizationInfo)) {
            return false;
        }
        ClassActualizationInfo classActualizationInfo = (ClassActualizationInfo)other;
        if (!Intrinsics.areEqual(this.actualClasses, classActualizationInfo.actualClasses)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actualTypeAliases, classActualizationInfo.actualTypeAliases)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.actualTopLevels, classActualizationInfo.actualTopLevels)) {
            return false;
        }
        return Intrinsics.areEqual(this.actualSymbolsToFile, classActualizationInfo.actualSymbolsToFile);
    }
}

