/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.providers.KotlinAnnotationsResolver;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProviderKt;
import org.jetbrains.kotlin.analysis.providers.impl.KotlinStaticAnnotationsResolver;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00182\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u0019H\u0002R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticAnnotationsResolver;", "Lorg/jetbrains/kotlin/analysis/providers/KotlinAnnotationsResolver;", "project", "Lcom/intellij/openapi/project/Project;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lcom/intellij/psi/search/GlobalSearchScope;)V", "allDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getAllDeclarations", "()Ljava/util/List;", "allDeclarations$delegate", "Lkotlin/Lazy;", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "getDeclarationProvider", "()Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "declarationProvider$delegate", "filesInScope", "annotationsOnDeclaration", "", "Lorg/jetbrains/kotlin/name/ClassId;", "declaration", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "declarationsByAnnotation", "queriedAnnotation", "resolveToAnnotation", "Lorg/jetbrains/kotlin/psi/KtClass;", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nKotlinStaticAnnotationsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStaticAnnotationsResolver.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticAnnotationsResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n*L\n1#1,87:1\n764#2:88\n855#2,2:89\n32#3,2:91\n9#3,6:93\n*S KotlinDebug\n*F\n+ 1 KotlinStaticAnnotationsResolver.kt\norg/jetbrains/kotlin/analysis/providers/impl/KotlinStaticAnnotationsResolver\n*L\n35#1:88\n35#1:89,2\n74#1:91,2\n74#1:93,6\n*E\n"})
final class KotlinStaticAnnotationsResolver
implements KotlinAnnotationsResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy declarationProvider$delegate;
    @NotNull
    private final List<KtFile> filesInScope;
    @NotNull
    private final Lazy allDeclarations$delegate;

    /*
     * WARNING - void declaration
     */
    public KotlinStaticAnnotationsResolver(@NotNull Project project, @NotNull Collection<? extends KtFile> ktFiles, @NotNull GlobalSearchScope scope) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        Intrinsics.checkNotNullParameter(scope, "scope");
        this.project = project;
        this.declarationProvider$delegate = LazyKt.lazy((Function0)new Function0<KotlinDeclarationProvider>(this, scope){
            final /* synthetic */ KotlinStaticAnnotationsResolver this$0;
            final /* synthetic */ GlobalSearchScope $scope;
            {
                this.this$0 = $receiver;
                this.$scope = $scope;
                super(0);
            }

            public final KotlinDeclarationProvider invoke() {
                return KotlinDeclarationProviderKt.createDeclarationProvider(KotlinStaticAnnotationsResolver.access$getProject$p(this.this$0), this.$scope, null);
            }
        });
        Iterable iterable = ktFiles;
        KotlinStaticAnnotationsResolver kotlinStaticAnnotationsResolver = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!scope.contains(it.getVirtualFile())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        kotlinStaticAnnotationsResolver.filesInScope = (List)destination$iv$iv;
        this.allDeclarations$delegate = LazyKt.lazy((Function0)new Function0<List<KtDeclaration>>(this){
            final /* synthetic */ KotlinStaticAnnotationsResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<KtDeclaration> invoke() {
                List result2 = new ArrayList<E>();
                KtTreeVisitorVoid visitor2 = VisitorWrappersKt.declarationRecursiveVisitor((Function1<? super KtDeclaration, Unit>)new Function1<KtDeclaration, Unit>((List<KtDeclaration>)result2){
                    final /* synthetic */ List<KtDeclaration> $result;
                    {
                        this.$result = $result;
                        super(1);
                    }

                    public final void invoke(KtDeclaration it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        KtDeclaration ktDeclaration = it;
                        if (ktDeclaration instanceof KtClassOrObject) {
                            bl = ((KtClassOrObject)it).isLocal();
                        } else if (ktDeclaration instanceof KtFunction) {
                            bl = ((KtFunction)it).isLocal();
                        } else if (ktDeclaration instanceof KtProperty) {
                            bl = ((KtProperty)it).isLocal();
                        } else {
                            return;
                        }
                        boolean isLocal2 = bl;
                        if (!isLocal2) {
                            ((Collection)this.$result).add(it);
                        }
                    }
                });
                Iterable $this$forEach$iv = KotlinStaticAnnotationsResolver.access$getFilesInScope$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl = false;
                    it.accept(visitor2);
                }
                return result2;
            }
        });
    }

    private final KotlinDeclarationProvider getDeclarationProvider() {
        Lazy lazy = this.declarationProvider$delegate;
        return (KotlinDeclarationProvider)lazy.getValue();
    }

    private final List<KtDeclaration> getAllDeclarations() {
        Lazy lazy = this.allDeclarations$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<KtAnnotated> declarationsByAnnotation(@NotNull ClassId queriedAnnotation) {
        Intrinsics.checkNotNullParameter(queriedAnnotation, "queriedAnnotation");
        return SequencesKt.toSet(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getAllDeclarations()), (Function1)new Function1<KtDeclaration, Boolean>(this, queriedAnnotation){
            final /* synthetic */ KotlinStaticAnnotationsResolver this$0;
            final /* synthetic */ ClassId $queriedAnnotation;
            {
                this.this$0 = $receiver;
                this.$queriedAnnotation = $queriedAnnotation;
                super(1);
            }

            public final Boolean invoke(KtDeclaration it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.annotationsOnDeclaration(it).contains(this.$queriedAnnotation);
            }
        }));
    }

    @Override
    @NotNull
    public Set<ClassId> annotationsOnDeclaration(@NotNull KtAnnotated declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        List<KtAnnotationEntry> list2 = declaration2.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list2, "getAnnotationEntries(...)");
        return SequencesKt.toSet(SequencesKt.filter(SequencesKt.map(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)list2), annotationsOnDeclaration.1.INSTANCE), annotationsOnDeclaration.2.INSTANCE), (Function1)new Function1<ClassId, Boolean>(this){
            final /* synthetic */ KotlinStaticAnnotationsResolver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(ClassId it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return KotlinStaticAnnotationsResolver.access$resolveToAnnotation(this.this$0, it) != null;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final KtClass resolveToAnnotation(ClassId $this$resolveToAnnotation) {
        List list2;
        Collection<KtClassOrObject> classes2;
        Collection<KtClassOrObject> $this$filterIsInstanceAnd$iv = classes2 = this.getDeclarationProvider().getAllClassesByClassId($this$resolveToAnnotation);
        boolean $i$f$filterIsInstanceAnd = false;
        if ($this$filterIsInstanceAnd$iv.isEmpty()) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$filterIsInstanceAndTo$iv$iv;
            Iterable iterable = $this$filterIsInstanceAnd$iv;
            Collection destination$iv$iv = new SmartList();
            boolean $i$f$filterIsInstanceAndTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof KtClass)) continue;
                KtClass it = (KtClass)element$iv$iv;
                boolean bl = false;
                if (!it.isAnnotation()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List annotations2 = list2;
        return (KtClass)CollectionsKt.singleOrNull(annotations2);
    }

    public static final /* synthetic */ KtClass access$resolveToAnnotation(KotlinStaticAnnotationsResolver $this, ClassId $receiver) {
        return $this.resolveToAnnotation($receiver);
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinStaticAnnotationsResolver $this) {
        return $this.project;
    }

    public static final /* synthetic */ List access$getFilesInScope$p(KotlinStaticAnnotationsResolver $this) {
        return $this.filesInScope;
    }
}

