/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.BloomFilterBase;
import com.intellij.util.containers.IntObjectHashMap;
import com.intellij.util.io.Murmur3_32Hash;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.fastutil.StrippedIntOpenHashSet;
import com.intellij.util.lang.fastutil.StrippedLongOpenHashSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClasspathCache {
    private static final double PROBABILITY = 0.005;
    private static final IntObjectHashMap.ArrayProducer<Loader[][]> ARRAY_FACTORY = size -> new Loader[size][];
    private volatile IntObjectHashMap<Loader[]> classPackageCache = new IntObjectHashMap(ARRAY_FACTORY);
    private volatile IntObjectHashMap<Loader[]> resourcePackageCache = new IntObjectHashMap(ARRAY_FACTORY);

    void clearCache() {
        this.classPackageCache = new IntObjectHashMap(ARRAY_FACTORY);
        this.resourcePackageCache = new IntObjectHashMap(ARRAY_FACTORY);
    }

    void applyLoaderData(@NotNull IndexRegistrar registrar2, @NotNull Loader loader) {
        if (registrar2 == null) {
            ClasspathCache.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            ClasspathCache.$$$reportNull$$$0(1);
        }
        IntObjectHashMap<Loader[]> newClassPackageCache = new IntObjectHashMap<Loader[]>(this.classPackageCache);
        IntObjectHashMap<Loader[]> newResourcePackageCache = new IntObjectHashMap<Loader[]>(this.resourcePackageCache);
        registrar2.registerPackageIndex(newClassPackageCache, newResourcePackageCache, loader);
        this.classPackageCache = newClassPackageCache;
        this.resourcePackageCache = newResourcePackageCache;
    }

    Loader @Nullable [] getLoadersByName(@NotNull String resourcePath) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(2);
        }
        IntObjectHashMap<Loader[]> map = resourcePath.endsWith(".class") ? this.classPackageCache : this.resourcePackageCache;
        return map.get(ClasspathCache.getPackageNameHash(resourcePath, resourcePath.lastIndexOf(47)));
    }

    Loader @Nullable [] getClassLoadersByName(@NotNull String resourcePath) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(3);
        }
        return this.classPackageCache.get(ClasspathCache.getPackageNameHash(resourcePath, resourcePath.lastIndexOf(47)));
    }

    static int getPackageNameHash(@NotNull String resourcePath, int endIndex) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(4);
        }
        return endIndex <= 0 ? 0 : Murmur3_32Hash.MURMUR3_32.hashString(resourcePath, 0, endIndex);
    }

    public static void addResourceEntries(int[] hashes, @NotNull IntObjectHashMap<Loader[]> map, @NotNull Loader loader) {
        if (map == null) {
            ClasspathCache.$$$reportNull$$$0(5);
        }
        if (loader == null) {
            ClasspathCache.$$$reportNull$$$0(6);
        }
        Loader[] singleArray = null;
        for (int hash : hashes) {
            int index2 = map.index(hash);
            Loader[] loaders = map.getByIndex(index2, hash);
            if (loaders == null) {
                if (singleArray == null) {
                    singleArray = new Loader[]{loader};
                }
                map.addByIndex(index2, hash, singleArray);
                continue;
            }
            Loader[] newList = new Loader[loaders.length + 1];
            System.arraycopy(loaders, 0, newList, 0, loaders.length);
            newList[loaders.length] = loader;
            map.replaceByIndex(index2, hash, newList);
        }
    }

    private static void addResourceEntry(int hash, @NotNull IntObjectHashMap<Loader[]> map, @NotNull Loader loader) {
        int index2;
        Loader[] loaders;
        if (map == null) {
            ClasspathCache.$$$reportNull$$$0(7);
        }
        if (loader == null) {
            ClasspathCache.$$$reportNull$$$0(8);
        }
        if ((loaders = map.getByIndex(index2 = map.index(hash), hash)) == null) {
            map.addByIndex(index2, hash, new Loader[]{loader});
        } else {
            if (ClassPath.recordLoadingInfo) {
                for (Loader value2 : loaders) {
                    if (loader != value2) continue;
                    throw new IllegalStateException("Duplicated loader");
                }
            }
            Loader[] newList = new Loader[loaders.length + 1];
            System.arraycopy(loaders, 0, newList, 0, loaders.length);
            newList[loaders.length] = loader;
            map.replaceByIndex(index2, hash, newList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/ClasspathCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyLoaderData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoadersByName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassLoadersByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameHash";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addResourceEntries";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addResourceEntry";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class NameFilter
    extends BloomFilterBase
    implements Predicate<String> {
        private static final Murmur3_32Hash MURMUR3_32_CUSTOM_SEED = new Murmur3_32Hash(85486);

        NameFilter(int _maxElementCount, double probability) {
            super(_maxElementCount, probability);
        }

        NameFilter(@NotNull ByteBuffer buffer) throws IOException {
            if (buffer == null) {
                NameFilter.$$$reportNull$$$0(0);
            }
            super(buffer);
        }

        private void addNameFingerprint(long nameFingerprint) {
            int hash = (int)(nameFingerprint >> 32);
            int hash2 = (int)nameFingerprint;
            this.addIt(hash, hash2);
        }

        @Override
        public boolean test(@NotNull String name2) {
            if (name2 == null) {
                NameFilter.$$$reportNull$$$0(1);
            }
            int end = name2.endsWith("/") ? name2.length() - 1 : name2.length();
            int hash = MURMUR3_32_CUSTOM_SEED.hashString(name2, 0, end);
            int hash2 = Murmur3_32Hash.MURMUR3_32.hashString(name2, 0, end);
            return this.maybeContains(hash, hash2);
        }

        private static long toNameFingerprint(@NotNull String name2, int end) {
            if (name2 == null) {
                NameFilter.$$$reportNull$$$0(2);
            }
            int hash = MURMUR3_32_CUSTOM_SEED.hashString(name2, 0, end);
            int hash2 = Murmur3_32Hash.MURMUR3_32.hashString(name2, 0, end);
            return (long)hash << 32 | (long)hash2 & 0xFFFFFFFFL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/lang/ClasspathCache$NameFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "test";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toNameFingerprint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class LoaderDataBuilder
    implements IndexRegistrar {
        private final StrippedLongOpenHashSet usedNameFingerprints;
        private final StrippedIntOpenHashSet resourcePackageHashes = new StrippedIntOpenHashSet();
        private final StrippedIntOpenHashSet classPackageHashes = new StrippedIntOpenHashSet();

        LoaderDataBuilder(boolean isNameFilterRequired) {
            this.usedNameFingerprints = isNameFilterRequired ? new StrippedLongOpenHashSet() : null;
        }

        void andClassName(@NotNull String name2) {
            if (name2 == null) {
                LoaderDataBuilder.$$$reportNull$$$0(0);
            }
            this.usedNameFingerprints.add(NameFilter.toNameFingerprint(name2, name2.length()));
        }

        void addResourceName(@NotNull String name2, int end) {
            if (name2 == null) {
                LoaderDataBuilder.$$$reportNull$$$0(1);
            }
            this.usedNameFingerprints.add(NameFilter.toNameFingerprint(name2, end));
        }

        void addResourcePackageFromName(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(2);
            }
            this.resourcePackageHashes.add(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
        }

        void addResourcePackage(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(3);
            }
            this.resourcePackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        void addClassPackageFromName(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(4);
            }
            this.classPackageHashes.add(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
        }

        void addClassPackage(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(5);
            }
            this.classPackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        @NotNull
        LoaderData build() {
            return new LoaderData(this.resourcePackageHashes.toArray(), this.classPackageHashes.toArray(), this.createNameFilter());
        }

        @NotNull
        private NameFilter createNameFilter() {
            NameFilter nameFilter2 = new NameFilter(this.usedNameFingerprints.size(), 0.005);
            StrippedLongOpenHashSet.SetIterator iterator2 = this.usedNameFingerprints.iterator();
            while (iterator2.hasNext()) {
                nameFilter2.addNameFingerprint(iterator2.nextLong());
            }
            NameFilter nameFilter3 = nameFilter2;
            if (nameFilter3 == null) {
                LoaderDataBuilder.$$$reportNull$$$0(6);
            }
            return nameFilter3;
        }

        @Override
        public void registerPackageIndex(IntObjectHashMap<Loader[]> classMap, IntObjectHashMap<Loader[]> resourceMap, Loader loader) {
            StrippedIntOpenHashSet.SetIterator classIterator = this.classPackageHashes.iterator();
            while (classIterator.hasNext()) {
                ClasspathCache.addResourceEntry(classIterator.nextInt(), classMap, loader);
            }
            StrippedIntOpenHashSet.SetIterator resourceIterator = this.resourcePackageHashes.iterator();
            while (resourceIterator.hasNext()) {
                ClasspathCache.addResourceEntry(resourceIterator.nextInt(), resourceMap, loader);
            }
            if (this.usedNameFingerprints != null) {
                loader.setNameFilter(this.createNameFilter());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/ClasspathCache$LoaderDataBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/ClasspathCache$LoaderDataBuilder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNameFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "andClassName";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addResourceName";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addResourcePackageFromName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addResourcePackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addClassPackageFromName";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addClassPackage";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class LoaderData
    implements IndexRegistrar {
        private final int[] resourcePackageHashes;
        private final int[] classPackageHashes;
        private final NameFilter nameFilter;

        LoaderData(int[] resourcePackageHashes, int[] classPackageHashes, NameFilter nameFilter2) {
            this.resourcePackageHashes = resourcePackageHashes;
            this.classPackageHashes = classPackageHashes;
            this.nameFilter = nameFilter2;
        }

        int sizeInBytes() {
            return 8 + this.classPackageHashes.length * 4 + this.resourcePackageHashes.length * 4 + this.nameFilter.sizeInBytes();
        }

        void save(@NotNull ByteBuffer buffer) throws IOException {
            if (buffer == null) {
                LoaderData.$$$reportNull$$$0(0);
            }
            buffer.putInt(this.classPackageHashes.length);
            buffer.putInt(this.resourcePackageHashes.length);
            IntBuffer intBuffer = buffer.asIntBuffer();
            intBuffer.put(this.classPackageHashes);
            intBuffer.put(this.resourcePackageHashes);
            buffer.position(buffer.position() + intBuffer.position() * 4);
            this.nameFilter.save(buffer);
        }

        @Override
        public void registerPackageIndex(IntObjectHashMap<Loader[]> classMap, IntObjectHashMap<Loader[]> resourceMap, Loader loader) {
            ClasspathCache.addResourceEntries(this.classPackageHashes, classMap, loader);
            ClasspathCache.addResourceEntries(this.resourcePackageHashes, resourceMap, loader);
            loader.setNameFilter(this.nameFilter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/lang/ClasspathCache$LoaderData", "save"));
        }
    }

    public static interface IndexRegistrar {
        public void registerPackageIndex(IntObjectHashMap<Loader[]> var1, IntObjectHashMap<Loader[]> var2, Loader var3);
    }
}

