/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ManyProjectsStubIndexMismatch;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.UpToDateStubIndexMismatch;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StubTreeLoader {
    public static StubTreeLoader getInstance() {
        return ApplicationManager.getApplication().getService(StubTreeLoader.class);
    }

    @Nullable
    public abstract ObjectStubTree<?> readOrBuild(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree<?> build(@Nullable Project var1, @NotNull VirtualFile var2, @Nullable PsiFile var3);

    @Nullable
    public abstract ObjectStubTree<?> readFromVFile(@NotNull Project var1, @NotNull VirtualFile var2);

    public abstract void rebuildStubTree(VirtualFile var1);

    public abstract boolean canHaveStub(VirtualFile var1);

    protected boolean hasPsiInManyProjects(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            StubTreeLoader.$$$reportNull$$$0(0);
        }
        return false;
    }

    @Nullable
    protected IndexingStampInfo getIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoader.$$$reportNull$$$0(1);
        }
        return null;
    }

    protected boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubTreeLoader.$$$reportNull$$$0(2);
        }
        return false;
    }

    @NotNull
    public RuntimeException stubTreeAndIndexDoNotMatch(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, @Nullable Throwable cause) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(3);
        }
        RuntimeException runtimeException = ProgressManager.getInstance().computeInNonCancelableSection(() -> {
            VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
            StubTree stubTreeFromIndex = (StubTree)this.readFromVFile(psiFile.getProject(), file2);
            boolean compiled = psiFile instanceof PsiCompiledElement;
            Document document2 = compiled ? null : FileDocumentManager.getInstance().getDocument(file2);
            IndexingStampInfo indexingStampInfo = this.getIndexingStampInfo(file2);
            boolean upToDate = indexingStampInfo != null && indexingStampInfo.isUpToDate(document2, file2, psiFile);
            @NonNls String msg2 = "PSI and index do not match.\nPlease report the problem to JetBrains with the files attached\n";
            if (upToDate) {
                msg2 = msg2 + "INDEXED VERSION IS THE CURRENT ONE";
            }
            msg2 = msg2 + " file=" + psiFile;
            msg2 = msg2 + ", file.class=" + psiFile.getClass();
            msg2 = msg2 + ", file.lang=" + psiFile.getLanguage();
            msg2 = msg2 + ", modStamp=" + psiFile.getModificationStamp();
            if (!compiled) {
                String text = psiFile.getText();
                PsiFile fromText = PsiFileFactory.getInstance(psiFile.getProject()).createFileFromText(psiFile.getName(), psiFile.getFileType(), (CharSequence)text);
                if (fromText.getLanguage().equals(psiFile.getLanguage())) {
                    boolean consistent = DebugUtil.psiToString(psiFile, false).equals(DebugUtil.psiToString(fromText, false));
                    msg2 = consistent ? msg2 + "\n tree consistent" : msg2 + "\n AST INCONSISTENT, perhaps after incremental reparse; " + fromText;
                }
            }
            if (stubTree != null) {
                msg2 = msg2 + "\n stub debugInfo=" + stubTree.getDebugInfo();
            }
            msg2 = msg2 + "\nlatestIndexedStub=" + stubTreeFromIndex;
            if (stubTreeFromIndex != null) {
                if (stubTree != null) {
                    msg2 = msg2 + "\n   same size=" + (stubTree.getPlainList().size() == stubTreeFromIndex.getPlainList().size());
                }
                msg2 = msg2 + "\n   debugInfo=" + stubTreeFromIndex.getDebugInfo();
            }
            FileViewProvider viewProvider = psiFile.getViewProvider();
            msg2 = msg2 + "\n viewProvider=" + viewProvider;
            msg2 = msg2 + "\n viewProvider stamp: " + viewProvider.getModificationStamp();
            msg2 = msg2 + "; file stamp: " + file2.getModificationStamp();
            msg2 = msg2 + "; file modCount: " + file2.getModificationCount();
            msg2 = msg2 + "; file length: " + file2.getLength();
            if (document2 != null) {
                msg2 = msg2 + "\n doc saved: " + !FileDocumentManager.getInstance().isDocumentUnsaved(document2);
                msg2 = msg2 + "; doc stamp: " + document2.getModificationStamp();
                msg2 = msg2 + "; doc size: " + document2.getTextLength();
                msg2 = msg2 + "; committed: " + PsiDocumentManager.getInstance(psiFile.getProject()).isCommitted(document2);
            }
            msg2 = msg2 + "\nindexing info: " + indexingStampInfo;
            Attachment[] attachments = StubTreeLoader.createAttachments(stubTree, psiFile, file2, stubTreeFromIndex);
            return this.hasPsiInManyProjects(file2) ? StubTreeLoader.handleManyProjectsMismatch(msg2, attachments, cause) : (upToDate ? StubTreeLoader.handleUpToDateMismatch(msg2, attachments, cause) : new RuntimeExceptionWithAttachments(msg2, cause, attachments));
        });
        if (runtimeException == null) {
            StubTreeLoader.$$$reportNull$$$0(4);
        }
        return runtimeException;
    }

    private static RuntimeExceptionWithAttachments handleUpToDateMismatch(@NotNull String message2, Attachment[] attachments, @Nullable Throwable cause) {
        if (message2 == null) {
            StubTreeLoader.$$$reportNull$$$0(5);
        }
        return new UpToDateStubIndexMismatch(message2, cause, attachments);
    }

    private static RuntimeExceptionWithAttachments handleManyProjectsMismatch(@NotNull String message2, Attachment[] attachments, @Nullable Throwable cause) {
        if (message2 == null) {
            StubTreeLoader.$$$reportNull$$$0(6);
        }
        return new ManyProjectsStubIndexMismatch(message2, cause, attachments);
    }

    private static Attachment @NotNull [] createAttachments(@Nullable ObjectStubTree stubTree, @NotNull PsiFileWithStubSupport psiFile, VirtualFile file2, @Nullable StubTree stubTreeFromIndex) {
        if (psiFile == null) {
            StubTreeLoader.$$$reportNull$$$0(7);
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        attachments.add(new Attachment(file2.getPath() + "_file.txt", psiFile instanceof PsiCompiledElement ? "compiled" : psiFile.getText()));
        if (stubTree != null) {
            attachments.add(new Attachment("stubTree.txt", ((PsiFileStubImpl)stubTree.getRoot()).printTree()));
        }
        if (stubTreeFromIndex != null) {
            attachments.add(new Attachment("stubTreeFromIndex.txt", ((PsiFileStubImpl)stubTreeFromIndex.getRoot()).printTree()));
        }
        Attachment[] attachmentArray = attachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            StubTreeLoader.$$$reportNull$$$0(8);
        }
        return attachmentArray;
    }

    @NonNls
    public static String getFileViewProviderMismatchDiagnostics(@NotNull FileViewProvider provider2) {
        if (provider2 == null) {
            StubTreeLoader.$$$reportNull$$$0(9);
        }
        Function<PsiFile, String> fileClassName = file2 -> file2.getClass().getSimpleName();
        Function<Pair, String> stubRootToString = pair -> "(" + ((IStubFileElementType)pair.first).toString() + ", " + ((IStubFileElementType)pair.first).getLanguage() + " -> " + (String)fileClassName.fun((PsiFile)pair.second) + ")";
        List<Pair<IStubFileElementType, PsiFile>> roots2 = StubTreeBuilder.getStubbedRoots(provider2);
        return ", stubBindingRoot = " + fileClassName.fun(provider2.getStubBindingRoot()) + ", languages = [" + StringUtil.join(provider2.getLanguages(), Language::getID, ", ") + "], fileTypes = [" + StringUtil.join(provider2.getAllFiles(), file2 -> file2.getFileType().getName(), ", ") + "], files = [" + StringUtil.join(provider2.getAllFiles(), fileClassName, ", ") + "], roots = [" + StringUtil.join(roots2, stubRootToString, ", ") + "], indexingInfo = " + StubTreeLoader.getInstance().getIndexingStampInfo(provider2.getVirtualFile()) + ", isTooLarge = " + StubTreeLoader.getInstance().isTooLarge(provider2.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubTreeLoader";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubTreeLoader";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stubTreeAndIndexDoNotMatch";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasPsiInManyProjects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingStampInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeAndIndexDoNotMatch";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleUpToDateMismatch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleManyProjectsMismatch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAttachments";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileViewProviderMismatchDiagnostics";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

