/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ClassTypePointerFactory;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.smartPointers.TypePointerBase;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTypePointerManagerImpl
extends SmartTypePointerManager {
    private static final SmartTypePointer NULL_POINTER = () -> null;
    private final SmartPointerManager myPsiPointerManager;
    private final Project myProject;

    public SmartTypePointerManagerImpl(Project project) {
        this.myPsiPointerManager = SmartPointerManager.getInstance(project);
        this.myProject = project;
    }

    @Override
    @NotNull
    public SmartTypePointer createSmartTypePointer(@NotNull PsiType type2) {
        SmartTypePointer pointer;
        if (type2 == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(0);
        }
        SmartTypePointer smartTypePointer = (pointer = type2.accept(new SmartTypeCreatingVisitor())) != null ? pointer : NULL_POINTER;
        if (smartTypePointer == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(1);
        }
        return smartTypePointer;
    }

    @NotNull
    private SmartTypePointer createClassReferenceTypePointer(@NotNull PsiClassType classType) {
        if (classType == null) {
            SmartTypePointerManagerImpl.$$$reportNull$$$0(2);
        }
        for (ClassTypePointerFactory factory2 : ClassTypePointerFactory.EP_NAME.getExtensions()) {
            SmartTypePointer pointer = factory2.createClassTypePointer(classType, this.myProject);
            if (pointer == null) continue;
            SmartTypePointer smartTypePointer = pointer;
            if (smartTypePointer == null) {
                SmartTypePointerManagerImpl.$$$reportNull$$$0(3);
            }
            return smartTypePointer;
        }
        return new SimpleTypePointer(classType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmartTypePointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassReferenceTypePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSmartTypePointer";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createClassReferenceTypePointer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class SmartTypeCreatingVisitor
    extends PsiTypeVisitor<SmartTypePointer> {
        private SmartTypeCreatingVisitor() {
        }

        @Override
        public SmartTypePointer visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
            if (primitiveType == null) {
                SmartTypeCreatingVisitor.$$$reportNull$$$0(0);
            }
            return new SimpleTypePointer(primitiveType);
        }

        @Override
        public SmartTypePointer visitArrayType(@NotNull PsiArrayType arrayType2) {
            SmartTypePointer componentTypePointer;
            if (arrayType2 == null) {
                SmartTypeCreatingVisitor.$$$reportNull$$$0(1);
            }
            return (componentTypePointer = arrayType2.getComponentType().accept(this)) != null ? new ArrayTypePointer(arrayType2, componentTypePointer) : null;
        }

        @Override
        public SmartTypePointer visitWildcardType(@NotNull PsiWildcardType wildcardType) {
            PsiType bound;
            if (wildcardType == null) {
                SmartTypeCreatingVisitor.$$$reportNull$$$0(2);
            }
            SmartTypePointer boundPointer = (bound = wildcardType.getBound()) == null ? null : bound.accept(this);
            return new WildcardTypePointer(wildcardType, boundPointer);
        }

        @Override
        public SmartTypePointer visitClassType(@NotNull PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass aClass;
            if (classType == null) {
                SmartTypeCreatingVisitor.$$$reportNull$$$0(3);
            }
            if ((aClass = (resolveResult = classType.resolveGenerics()).getElement()) == null) {
                return SmartTypePointerManagerImpl.this.createClassReferenceTypePointer(classType);
            }
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            HashMap<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> pointerMap = new HashMap<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer>();
            HashMap<PsiTypeParameter, PsiType> map = new HashMap<PsiTypeParameter, PsiType>();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substitutionResult = substitutor2.substitute(typeParameter);
                if (substitutionResult != null) {
                    SmartPsiElementPointer<PsiTypeParameter> pointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(typeParameter);
                    SmartTypePointer typePointer = substitutionResult.accept(this);
                    pointerMap.put(pointer, typePointer);
                    map.put(typeParameter, typePointer.getType());
                    continue;
                }
                map.put(typeParameter, null);
            }
            SmartPsiElementPointer[] annotationPointers = (SmartPsiElementPointer[])Stream.of(classType.getAnnotations()).map(SmartTypePointerManagerImpl.this.myPsiPointerManager::createSmartPsiElementPointer).toArray(SmartPsiElementPointer[]::new);
            LanguageLevel languageLevel = classType.getLanguageLevel();
            return new ClassTypePointer(new PsiImmediateClassType(aClass, PsiSubstitutor.createSubstitutor(map), languageLevel, classType.getAnnotations()), SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(aClass), languageLevel, pointerMap, annotationPointers);
        }

        @Override
        public SmartTypePointer visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
            if (disjunctionType == null) {
                SmartTypeCreatingVisitor.$$$reportNull$$$0(4);
            }
            return new DisjunctionTypePointer(disjunctionType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primitiveType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wildcardType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classType";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disjunctionType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$SmartTypeCreatingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrimitiveType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArrayType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWildcardType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDisjunctionType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class DisjunctionTypePointer
    extends TypePointerBase<PsiDisjunctionType> {
        private final List<SmartTypePointer> myPointers;

        private DisjunctionTypePointer(PsiDisjunctionType type2) {
            if (type2 == null) {
                DisjunctionTypePointer.$$$reportNull$$$0(0);
            }
            super(type2);
            this.myPointers = ContainerUtil.map(type2.getDisjunctions(), SmartTypePointerManagerImpl.this::createSmartTypePointer);
        }

        @Override
        protected PsiDisjunctionType calcType() {
            List<PsiType> types2 = ContainerUtil.map(this.myPointers, SmartTypePointer::getType);
            return new PsiDisjunctionType(types2, PsiManager.getInstance(SmartTypePointerManagerImpl.this.myProject));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$DisjunctionTypePointer", "<init>"));
        }
    }

    private static class ClassTypePointer
    extends TypePointerBase<PsiClassType> {
        private final SmartPsiElementPointer<?> myClass;
        private final LanguageLevel myLevel;
        private final Map<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> myMap;
        private final SmartPsiElementPointer<?>[] myAnnotations;

        ClassTypePointer(@NotNull PsiClassType type2, @NotNull SmartPsiElementPointer<?> aClass, @NotNull LanguageLevel languageLevel, @NotNull Map<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> map, SmartPsiElementPointer<?> @NotNull [] annotations2) {
            if (type2 == null) {
                ClassTypePointer.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                ClassTypePointer.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                ClassTypePointer.$$$reportNull$$$0(2);
            }
            if (map == null) {
                ClassTypePointer.$$$reportNull$$$0(3);
            }
            if (annotations2 == null) {
                ClassTypePointer.$$$reportNull$$$0(4);
            }
            super(type2);
            this.myClass = aClass;
            this.myLevel = languageLevel;
            this.myMap = map;
            this.myAnnotations = annotations2;
        }

        @Override
        protected PsiClassType calcType() {
            Object classElement = this.myClass.getElement();
            if (!(classElement instanceof PsiClass)) {
                return null;
            }
            HashMap<PsiTypeParameter, PsiType> resurrected = new HashMap<PsiTypeParameter, PsiType>();
            Set<Map.Entry<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer>> set = this.myMap.entrySet();
            for (Map.Entry<SmartPsiElementPointer<PsiTypeParameter>, SmartTypePointer> entry : set) {
                PsiTypeParameter element2 = entry.getKey().getElement();
                if (element2 == null) continue;
                SmartTypePointer typePointer = entry.getValue();
                resurrected.put(element2, typePointer == null ? null : typePointer.getType());
            }
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiClass)classElement)) {
                if (resurrected.containsKey(typeParameter)) continue;
                resurrected.put(typeParameter, null);
            }
            PsiSubstitutor resurrectedSubstitutor = PsiSubstitutor.createSubstitutor(resurrected);
            PsiAnnotation[] resurrectedAnnotations = (PsiAnnotation[])Stream.of(this.myAnnotations).map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).toArray(PsiAnnotation[]::new);
            return new PsiImmediateClassType((PsiClass)classElement, resurrectedSubstitutor, this.myLevel, resurrectedAnnotations);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "map";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "annotations";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WildcardTypePointer
    extends TypePointerBase<PsiWildcardType> {
        private final PsiManager myManager;
        private final SmartTypePointer myBoundPointer;
        private final boolean myIsExtending;

        WildcardTypePointer(@NotNull PsiWildcardType type2, @Nullable SmartTypePointer boundPointer) {
            if (type2 == null) {
                WildcardTypePointer.$$$reportNull$$$0(0);
            }
            super(type2);
            this.myManager = type2.getManager();
            this.myBoundPointer = boundPointer;
            this.myIsExtending = type2.isExtends();
        }

        @Override
        protected PsiWildcardType calcType() {
            if (this.myBoundPointer == null) {
                return PsiWildcardType.createUnbounded(this.myManager);
            }
            PsiType type2 = this.myBoundPointer.getType();
            if (type2 == null) {
                return null;
            }
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends(this.myManager, type2);
            }
            return PsiWildcardType.createSuper(this.myManager, type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$WildcardTypePointer", "<init>"));
        }
    }

    private static class ArrayTypePointer
    extends TypePointerBase<PsiArrayType> {
        private final SmartTypePointer myComponentTypePointer;

        ArrayTypePointer(@NotNull PsiArrayType type2, @NotNull SmartTypePointer componentTypePointer) {
            if (type2 == null) {
                ArrayTypePointer.$$$reportNull$$$0(0);
            }
            if (componentTypePointer == null) {
                ArrayTypePointer.$$$reportNull$$$0(1);
            }
            super(type2);
            this.myComponentTypePointer = componentTypePointer;
        }

        @Override
        @Nullable
        protected PsiArrayType calcType() {
            PsiType type2 = this.myComponentTypePointer.getType();
            return type2 == null ? null : new PsiArrayType(type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTypePointer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ArrayTypePointer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SimpleTypePointer
    implements SmartTypePointer {
        private final PsiType myType;

        private SimpleTypePointer(@NotNull PsiType type2) {
            if (type2 == null) {
                SimpleTypePointer.$$$reportNull$$$0(0);
            }
            this.myType = type2;
        }

        @Override
        public PsiType getType() {
            return this.myType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$SimpleTypePointer", "<init>"));
        }
    }
}

