/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.expressions.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\"\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\t0\t0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstantArrayImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstantArray;", "startOffset", "", "endOffset", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "initElements", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstantValue;", "(IILorg/jetbrains/kotlin/ir/types/IrType;Ljava/util/List;)V", "elements", "Lorg/jetbrains/kotlin/utils/SmartList;", "kotlin.jvm.PlatformType", "getElements", "()Lorg/jetbrains/kotlin/utils/SmartList;", "getEndOffset", "()I", "getStartOffset", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "setType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)V", "contentEquals", "", "other", "contentHashCode", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrConstantObjectImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstantObjectImpl.kt\norg/jetbrains/kotlin/ir/expressions/impl/IrConstantArrayImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1724#2,3:93\n*S KotlinDebug\n*F\n+ 1 IrConstantObjectImpl.kt\norg/jetbrains/kotlin/ir/expressions/impl/IrConstantArrayImpl\n*L\n82#1:93,3\n*E\n"})
public final class IrConstantArrayImpl
extends IrConstantArray {
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private IrType type;
    @NotNull
    private final SmartList<IrConstantValue> elements;

    public IrConstantArrayImpl(int startOffset, int endOffset, @NotNull IrType type2, @NotNull List<? extends IrConstantValue> initElements) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(initElements, "initElements");
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.type = type2;
        this.elements = new SmartList(initElements);
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    @NotNull
    public IrType getType() {
        return this.type;
    }

    @Override
    public void setType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter(irType, "<set-?>");
        this.type = irType;
    }

    @NotNull
    public SmartList<IrConstantValue> getElements() {
        return this.elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contentEquals(@NotNull IrConstantValue other) {
        int it;
        Intrinsics.checkNotNullParameter(other, "other");
        if (!(other instanceof IrConstantArray)) return false;
        if (!Intrinsics.areEqual(other.getType(), this.getType())) return false;
        if (((SmartList)this.getElements()).size() != ((IrConstantArray)other).getElements().size()) return false;
        Iterable $this$all$iv = CollectionsKt.getIndices(this.getElements());
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator2.hasNext()) return true;
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
        } while (((IrConstantValue)((SmartList)this.getElements()).get(it)).contentEquals(((IrConstantArray)other).getElements().get(it)));
        return false;
    }

    @Override
    public int contentHashCode() {
        int res2 = this.getType().hashCode();
        for (IrConstantValue value2 : this.getElements()) {
            res2 = res2 * 31 + value2.contentHashCode();
        }
        return res2;
    }
}

