/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeTypeVariableTypeIsNotInferred;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeStubTypeConstructor;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeStubAndTypeVariableToErrorTypeSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "stubTypesToReplace", "", "Lorg/jetbrains/kotlin/fir/types/ConeStubTypeConstructor;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;Ljava/util/Collection;)V", "substituteType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "toString", "", "providers"})
@SourceDebugExtension(value={"SMAP\nSubstitutors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Substitutors.kt\norg/jetbrains/kotlin/fir/resolve/substitution/ConeStubAndTypeVariableToErrorTypeSubstitutor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,386:1\n226#2:387\n*S KotlinDebug\n*F\n+ 1 Substitutors.kt\norg/jetbrains/kotlin/fir/resolve/substitution/ConeStubAndTypeVariableToErrorTypeSubstitutor\n*L\n362#1:387\n*E\n"})
public final class ConeStubAndTypeVariableToErrorTypeSubstitutor
extends AbstractConeSubstitutor {
    @NotNull
    private final Collection<ConeStubTypeConstructor> stubTypesToReplace;

    public ConeStubAndTypeVariableToErrorTypeSubstitutor(@NotNull ConeTypeContext typeContext2, @NotNull Collection<ConeStubTypeConstructor> stubTypesToReplace) {
        Intrinsics.checkNotNullParameter(typeContext2, "typeContext");
        Intrinsics.checkNotNullParameter(stubTypesToReplace, "stubTypesToReplace");
        super(typeContext2);
        this.stubTypesToReplace = stubTypesToReplace;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter(type2, "type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeTypeVariableType) {
            coneKotlinType = new ConeErrorType(new ConeTypeVariableTypeIsNotInferred((ConeTypeVariableType)type2, null, 2, null), true, null, null, 12, null);
        } else if (coneKotlinType2 instanceof ConeStubType) {
            ConeErrorType coneErrorType;
            boolean condition$iv = this.stubTypesToReplace.contains(((ConeStubType)type2).getConstructor());
            boolean $i$f$runIf = false;
            if (condition$iv) {
                boolean bl = false;
                coneErrorType = new ConeErrorType(new ConeSimpleDiagnostic("Type for stub of " + ((ConeStubType)type2).getConstructor().getVariable().getTypeConstructor().getDebugName() + " is not inferred", DiagnosticKind.InferenceError), true, null, null, 12, null);
            } else {
                coneErrorType = null;
            }
            coneKotlinType = coneErrorType;
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @NotNull
    public String toString() {
        return "{<Stub type> -> <Error type>}";
    }
}

