/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProviderKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH&J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH&J\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "", "()V", "mayHaveSyntheticFunctionTypes", "", "getMayHaveSyntheticFunctionTypes", "()Z", "getPackageNamesWithTopLevelCallables", "", "", "getTopLevelCallableNamesInPackage", "Lorg/jetbrains/kotlin/name/Name;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "getTopLevelClassifierNamesInPackage", "mayHaveSyntheticFunctionType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "mayHaveTopLevelCallable", "name", "mayHaveTopLevelClassifier", "providers"})
public abstract class FirSymbolNamesProvider {
    private final boolean mayHaveSyntheticFunctionTypes;

    @Nullable
    public abstract Set<Name> getTopLevelClassifierNamesInPackage(@NotNull FqName var1);

    @Nullable
    public abstract Set<String> getPackageNamesWithTopLevelCallables();

    @Nullable
    public abstract Set<Name> getTopLevelCallableNamesInPackage(@NotNull FqName var1);

    public boolean getMayHaveSyntheticFunctionTypes() {
        return this.mayHaveSyntheticFunctionTypes;
    }

    public boolean mayHaveSyntheticFunctionType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getMayHaveSyntheticFunctionTypes();
    }

    public boolean mayHaveTopLevelClassifier(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        if (this.getMayHaveSyntheticFunctionTypes() && this.mayHaveSyntheticFunctionType(classId)) {
            return true;
        }
        Set<Name> set = this.getTopLevelClassifierNamesInPackage(classId.getPackageFqName());
        if (set == null) {
            return true;
        }
        Set<Name> names2 = set;
        return !(classId.getOuterClassId() == null ? !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names2, classId.getShortClassName()) : !FirSymbolNamesProviderKt.access$mayContainTopLevelClassifier(names2, classId.getOutermostClassId().getShortClassName()));
    }

    public boolean mayHaveTopLevelCallable(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        if (name2.isSpecial()) {
            return true;
        }
        Set<Name> set = this.getTopLevelCallableNamesInPackage(packageFqName);
        if (set == null) {
            return true;
        }
        Set<Name> names2 = set;
        return names2.contains(name2);
    }
}

