/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0002R\u001a\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "transformerComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "mappedArgumentsOrderRepresentation", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getMappedArgumentsOrderRepresentation", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;)[I", "areEquivalentTopLevelCallables", "", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "firstCandidate", "second", "secondCandidate", "chooseMaximallySpecificCandidates", "", "candidates", "discriminateAbstracts", "filterOutEquivalentCalls", "", "java"})
@SourceDebugExtension(value={"SMAP\nConeEquivalentCallConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,122:1\n1043#2:123\n1557#2:125\n1588#2,4:126\n37#3:124\n*S KotlinDebug\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n*L\n47#1:123\n113#1:125\n113#1:126,4\n81#1:124\n*E\n"})
public final class ConeEquivalentCallConflictResolver
extends AbstractConeCallConflictResolver {
    public ConeEquivalentCallConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents, @NotNull BodyResolveComponents transformerComponents) {
        Intrinsics.checkNotNullParameter(specificityComparator, "specificityComparator");
        Intrinsics.checkNotNullParameter(inferenceComponents, "inferenceComponents");
        Intrinsics.checkNotNullParameter(transformerComponents, "transformerComponents");
        super(specificityComparator, inferenceComponents, transformerComponents, true);
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, "candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates2);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates2) {
        Iterable $this$sortedBy$iv = candidates2;
        boolean $i$f$sortedBy = false;
        List<Candidate> fromSourceFirst = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Candidate it = (Candidate)a;
                boolean bl = false;
                boolean bl2 = ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source;
                it = (Candidate)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source);
            }
        });
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : fromSourceFirst) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)me).getSymbol()) == null) {
                for (Candidate otherCandidate : result2) {
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)other).getSymbol()) != null || !this.areEquivalentTopLevelCallables((FirCallableDeclaration)me, myCandidate, (FirCallableDeclaration)other, otherCandidate)) continue;
                    continue block0;
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first, Candidate firstCandidate, FirCallableDeclaration second, Candidate secondCandidate) {
        if (!Intrinsics.areEqual(first.getSymbol().getCallableId(), second.getSymbol().getCallableId())) {
            return false;
        }
        if (Intrinsics.areEqual(first.getModuleData(), second.getModuleData()) && first.getModuleData().getSession().getKind() == FirSession.Kind.Source) {
            return false;
        }
        FirMemberDeclaration $this$isExpect$iv = first;
        boolean $i$f$isExpect = false;
        boolean bl = $this$isExpect$iv.getStatus().isExpect();
        $this$isExpect$iv = second;
        $i$f$isExpect = false;
        if (bl != $this$isExpect$iv.getStatus().isExpect()) {
            return false;
        }
        if (first instanceof FirVariable != second instanceof FirVariable) {
            return false;
        }
        if (!Arrays.equals(this.getMappedArgumentsOrderRepresentation(firstCandidate), this.getMappedArgumentsOrderRepresentation(secondCandidate))) {
            return false;
        }
        FirStandardOverrideChecker overrideChecker = new FirStandardOverrideChecker(this.getInferenceComponents().getSession());
        return first instanceof FirProperty && second instanceof FirProperty ? overrideChecker.isOverriddenProperty(first, (FirProperty)second, true) && overrideChecker.isOverriddenProperty(second, (FirProperty)first, true) : (first instanceof FirSimpleFunction && second instanceof FirSimpleFunction ? overrideChecker.isOverriddenFunction((FirSimpleFunction)first, (FirSimpleFunction)second, true) && overrideChecker.isOverriddenFunction((FirSimpleFunction)second, (FirSimpleFunction)first, true) : false);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getMappedArgumentsOrderRepresentation(Candidate $this$mappedArgumentsOrderRepresentation) {
        void $this$mapIndexedTo$iv$iv;
        Object obj = $this$mappedArgumentsOrderRepresentation.getSymbol().getFir();
        FirFunction firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction function2 = firFunction;
        Iterable $this$mapIndexed$iv = function2.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it, (int)index2));
        }
        Map parametersToIndices = MapsKt.toMap((List)destination$iv$iv);
        LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = $this$mappedArgumentsOrderRepresentation.getArgumentMapping();
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<FirExpression, FirValueParameter> mapping2 = linkedHashMap;
        int n = 0;
        int n3 = mapping2.size() + 1;
        int[] $i$f$mapIndexedTo22 = new int[n3];
        while (n < n3) {
            index$iv$iv = n++;
            $i$f$mapIndexedTo22[index$iv$iv] = function2.getValueParameters().size();
        }
        int[] result2 = $i$f$mapIndexedTo22;
        Iterator<FirValueParameter> iterator2 = mapping2.values().iterator();
        n3 = 0;
        while (iterator2.hasNext()) {
            int index3 = n3++;
            FirValueParameter parameter2 = iterator2.next();
            Integer n4 = (Integer)parametersToIndices.get(parameter2);
            if (n4 == null) {
                throw new IllegalStateException("Unmapped argument in arguments mapping".toString());
            }
            result2[index3 + 1] = n4;
        }
        return result2;
    }
}

