/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.FirAbstractWebCheckerUtils;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmWebCheckerUtils;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/FirAbstractWebCheckerUtils;", "()V", "isNativeOrExternalInterface", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.wasm"})
@SourceDebugExtension(value={"SMAP\nFirWasmWebCheckerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWasmWebCheckerUtils.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmWebCheckerUtils\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,20:1\n57#2:21\n34#3:22\n*S KotlinDebug\n*F\n+ 1 FirWasmWebCheckerUtils.kt\norg/jetbrains/kotlin/fir/analysis/wasm/checkers/FirWasmWebCheckerUtils\n*L\n19#1:21\n19#1:22\n*E\n"})
public final class FirWasmWebCheckerUtils
extends FirAbstractWebCheckerUtils {
    @NotNull
    public static final FirWasmWebCheckerUtils INSTANCE = new FirWasmWebCheckerUtils();

    private FirWasmWebCheckerUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNativeOrExternalInterface(@NotNull FirBasedSymbol<?> symbol2, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!FirWebCommonHelpersKt.isEffectivelyExternal(symbol2, session2)) return false;
        Object obj = symbol2.getFir();
        if (!(obj instanceof FirClass)) return false;
        FirClass firClass = (FirClass)obj;
        if (firClass == null) return false;
        FirClass $this$isInterface$iv = firClass;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        if ($this$isInterface$iv$iv != ClassKind.INTERFACE) return false;
        return true;
    }
}

