/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDataClassPrimaryConstructorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDataClassPrimaryConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,45:1\n68#2:46\n*S KotlinDebug\n*F\n+ 1 FirDataClassPrimaryConstructorChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassPrimaryConstructorChecker\n*L\n20#1:46\n*E\n"})
public final class FirDataClassPrimaryConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirDataClassPrimaryConstructorChecker INSTANCE = new FirDataClassPrimaryConstructorChecker();

    private FirDataClassPrimaryConstructorChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirConstructorSymbol primaryConstructor2;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(declaration2, "declaration");
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                if (declaration2.getClassKind() != ClassKind.CLASS) break block7;
                FirRegularClass $this$isData$iv = declaration2;
                boolean $i$f$isData = false;
                if ($this$isData$iv.getStatus().isData()) break block8;
            }
            return;
        }
        FirConstructorSymbol firConstructorSymbol2 = primaryConstructor2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if ((firConstructorSymbol2 != null ? firConstructorSymbol2.getSource() : null) == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        List<FirValueParameterSymbol> valueParameters2 = primaryConstructor2.getValueParameterSymbols();
        if (valueParameters2.isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)primaryConstructor2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_WITHOUT_PARAMETERS(), (DiagnosticContext)context2, null, 8, null);
        }
        for (FirValueParameterSymbol parameter2 : valueParameters2) {
            if (parameter2.isVararg()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_VARARG_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
            }
            KtSourceElement ktSourceElement = parameter2.getSource();
            if (ktSourceElement != null ? LightTreePositioningStrategiesKt.hasValOrVar(ktSourceElement) : false) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirErrors.INSTANCE.getDATA_CLASS_NOT_PROPERTY_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

