/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.CastingType;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMap;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForTypeVariableInSubtyping;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUnificationKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContext;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a(\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003\u001a\n\u0010\u001c\u001a\u00020\u0006*\u00020\u0003\u00a8\u0006\u001d"}, d2={"checkCasting", "Lorg/jetbrains/kotlin/fir/analysis/checkers/CastingType;", "lhsType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "rhsType", "isSafeCase", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "findStaticallyKnownSubtype", "supertype", "subTypeClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getCorrespondingKotlinClass", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "type", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isCastErased", "subtype", "isFinal", "isRoughSubtypeOf", "superType", "state", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "isUpcast", "candidateType", "targetType", "isNonReifiedTypeParameter", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCastDiagnosticsHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCastDiagnosticsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirCastDiagnosticsHelpersKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n72#2:305\n72#2:307\n62#2:339\n34#3:306\n34#3:308\n132#4,16:309\n148#4,13:326\n1#5:325\n1#5:343\n1745#6,3:340\n*S KotlinDebug\n*F\n+ 1 FirCastDiagnosticsHelpers.kt\norg/jetbrains/kotlin/fir/analysis/checkers/FirCastDiagnosticsHelpersKt\n*L\n52#1:305\n101#1:307\n180#1:339\n52#1:306\n101#1:308\n123#1:309,16\n123#1:326,13\n123#1:325\n180#1:340,3\n*E\n"})
public final class FirCastDiagnosticsHelpersKt {
    @NotNull
    public static final CastingType checkCasting(@NotNull ConeKotlinType lhsType, @NotNull ConeKotlinType rhsType, boolean isSafeCase, @NotNull CheckerContext context2) {
        block23: {
            block22: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isInterface;
                ClassKind $this$isInterface$iv$iv;
                boolean $i$f$isInterface2;
                FirClassSymbol $this$isInterface$iv;
                Intrinsics.checkNotNullParameter(lhsType, "lhsType");
                Intrinsics.checkNotNullParameter(rhsType, "rhsType");
                Intrinsics.checkNotNullParameter(context2, "context");
                ConeSimpleKotlinType lhsLowerType = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(ConeTypeUtilsKt.lowerBoundIfFlexible(lhsType));
                ConeSimpleKotlinType rhsLowerType = ConeTypeUtilsKt.originalIfDefinitelyNotNullable(ConeTypeUtilsKt.lowerBoundIfFlexible(rhsType));
                if (lhsLowerType instanceof ConeErrorType || rhsLowerType instanceof ConeErrorType) {
                    return CastingType.Possible;
                }
                FirSession session2 = context2.getSession();
                if (lhsLowerType instanceof ConeIntersectionType) {
                    boolean result2 = false;
                    for (ConeKotlinType intersectedType : ((ConeIntersectionType)lhsLowerType).getIntersectedTypes()) {
                        boolean bl3;
                        FirRegularClassSymbol intersectedTypeSymbol;
                        CastingType isIntersectedCastPossible = FirCastDiagnosticsHelpersKt.checkCasting(intersectedType, rhsLowerType, isSafeCase, context2);
                        FirRegularClassSymbol firRegularClassSymbol = intersectedTypeSymbol = TypeUtilsKt.toRegularClassSymbol(intersectedType, session2);
                        if (firRegularClassSymbol != null) {
                            FirClassSymbol $this$isInterface$iv2 = firRegularClassSymbol;
                            boolean $i$f$isInterface3 = false;
                            ClassKind $this$isInterface$iv$iv2 = $this$isInterface$iv2.getClassKind();
                            boolean $i$f$isInterface4 = false;
                            boolean bl4 = $this$isInterface$iv$iv2 == ClassKind.INTERFACE;
                            bl3 = !bl4;
                        } else {
                            bl3 = false;
                        }
                        if (bl3 && isIntersectedCastPossible == CastingType.Impossible) {
                            return CastingType.Impossible;
                        }
                        result2 |= isIntersectedCastPossible != CastingType.Impossible;
                    }
                    return result2 ? CastingType.Possible : CastingType.Impossible;
                }
                boolean lhsNullable = FirTypeUtilsKt.getCanBeNull(lhsLowerType);
                boolean rhsNullable = FirTypeUtilsKt.getCanBeNull(rhsLowerType);
                if (ConeBuiltinTypeUtilsKt.isNothing(lhsLowerType)) {
                    return CastingType.Possible;
                }
                if (ConeBuiltinTypeUtilsKt.isNullableNothing(lhsLowerType) && !rhsNullable) {
                    return isSafeCase ? CastingType.Always : CastingType.Impossible;
                }
                if (ConeBuiltinTypeUtilsKt.isNothing(rhsLowerType)) {
                    return CastingType.Impossible;
                }
                if (ConeBuiltinTypeUtilsKt.isNullableNothing(rhsLowerType)) {
                    return lhsNullable ? CastingType.Possible : CastingType.Impossible;
                }
                if (lhsNullable && rhsNullable) {
                    return CastingType.Possible;
                }
                if (lhsLowerType instanceof ConeTypeParameterType || rhsLowerType instanceof ConeTypeParameterType) {
                    return CastingType.Possible;
                }
                FirRegularClassSymbol lhsClassSymbol = TypeUtilsKt.toRegularClassSymbol(lhsLowerType, session2);
                FirRegularClassSymbol rhsClassSymbol = TypeUtilsKt.toRegularClassSymbol(rhsLowerType, session2);
                Object object = lhsClassSymbol;
                ConeSimpleKotlinType lhsNormalizedType = FirCastDiagnosticsHelpersKt.getCorrespondingKotlinClass(object != null && (object = ScopeUtilsKt.defaultType((FirClassSymbol)object)) != null ? (ConeSimpleKotlinType)object : lhsLowerType, session2);
                Object object2 = rhsClassSymbol;
                ConeSimpleKotlinType rhsNormalizedType = FirCastDiagnosticsHelpersKt.getCorrespondingKotlinClass(object2 != null && (object2 = ScopeUtilsKt.defaultType((FirClassSymbol)object2)) != null ? (ConeSimpleKotlinType)object2 : rhsLowerType, session2);
                TypeCheckerState state = TypeComponentsKt.getTypeContext(session2).newTypeCheckerState(false, false);
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, state, (KotlinTypeMarker)lhsNormalizedType, (KotlinTypeMarker)rhsNormalizedType, false, 8, null) || AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, state, (KotlinTypeMarker)rhsNormalizedType, (KotlinTypeMarker)lhsNormalizedType, false, 8, null)) {
                    return CastingType.Possible;
                }
                if (FirCastDiagnosticsHelpersKt.isRoughSubtypeOf(lhsNormalizedType, rhsNormalizedType, state, session2) || FirCastDiagnosticsHelpersKt.isRoughSubtypeOf(rhsNormalizedType, lhsNormalizedType, state, session2)) {
                    return CastingType.Possible;
                }
                if (FirCastDiagnosticsHelpersKt.isFinal(lhsNormalizedType, session2) || FirCastDiagnosticsHelpersKt.isFinal(rhsNormalizedType, session2)) {
                    return CastingType.Impossible;
                }
                FirClassifierSymbol<?> $i$f$isInterface4 = TypeUtilsKt.toSymbol(lhsNormalizedType, session2);
                FirClassSymbol lhsNormalizedTypeSymbol = $i$f$isInterface4 instanceof FirClassSymbol ? (FirClassSymbol)$i$f$isInterface4 : null;
                FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol(rhsNormalizedType, session2);
                FirClassSymbol rhsNormalizedTypeSymbol = firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null;
                FirClassSymbol firClassSymbol = lhsNormalizedTypeSymbol;
                if (firClassSymbol != null) {
                    $this$isInterface$iv = firClassSymbol;
                    $i$f$isInterface2 = false;
                    $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                    $i$f$isInterface = false;
                    bl2 = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                } else {
                    bl2 = false;
                }
                if (bl2) break block22;
                FirClassSymbol firClassSymbol2 = rhsNormalizedTypeSymbol;
                if (firClassSymbol2 != null) {
                    $this$isInterface$iv = firClassSymbol2;
                    $i$f$isInterface2 = false;
                    $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
                    $i$f$isInterface = false;
                    bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
                } else {
                    bl = false;
                }
                if (!bl) break block23;
            }
            return CastingType.Possible;
        }
        return CastingType.Impossible;
    }

    private static final boolean isRoughSubtypeOf(ConeSimpleKotlinType type2, ConeSimpleKotlinType superType2, TypeCheckerState state, FirSession session2) {
        boolean result2;
        block9: {
            boolean bl;
            result2 = false;
            TypeConstructorMarker superTypeConstructor = TypeSystemContextHelpersKt.typeConstructor(superType2, state.getTypeSystemContext());
            TypeCheckerState this_$iv = state;
            boolean $i$f$anySupertype = false;
            SimpleTypeMarker typeMarker = type2;
            boolean bl2 = false;
            Intrinsics.checkNotNull(typeMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType");
            ConeSimpleKotlinType correspondingKotlinClass = FirCastDiagnosticsHelpersKt.getCorrespondingKotlinClass((ConeSimpleKotlinType)typeMarker, session2);
            if (Intrinsics.areEqual(TypeSystemContextHelpersKt.typeConstructor(correspondingKotlinClass, state.getTypeSystemContext()), superTypeConstructor)) {
                result2 = true;
                bl = true;
            } else {
                bl = false;
            }
            if (!bl) {
                this_$iv.initialize();
                ArrayDeque<SimpleTypeMarker> arrayDeque = this_$iv.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<SimpleTypeMarker> deque$iv = arrayDeque;
                Set<SimpleTypeMarker> set = this_$iv.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<SimpleTypeMarker> visitedSupertypes$iv = set;
                deque$iv.push(type2);
                while (!((Collection)deque$iv).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy policy$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        throw new IllegalStateException(("Too many supertypes for type: " + (SimpleTypeMarker)type2 + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes$iv, null, null, null, 0, null, null, 63, null)).toString());
                    }
                    SimpleTypeMarker current$iv = deque$iv.pop();
                    Intrinsics.checkNotNull(current$iv);
                    if (!visitedSupertypes$iv.add(current$iv)) continue;
                    SimpleTypeMarker it = current$iv;
                    boolean bl3 = false;
                    TypeCheckerState.SupertypesPolicy supertypesPolicy = TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    TypeCheckerState.SupertypesPolicy it$iv = supertypesPolicy;
                    boolean bl4 = false;
                    if ((!Intrinsics.areEqual(it$iv, TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? supertypesPolicy : null) == null) continue;
                    policy$iv = policy$iv;
                    TypeSystemContext $this$anySupertype_u24lambda_u243$iv = this_$iv.getTypeSystemContext();
                    boolean bl5 = false;
                    Collection<KotlinTypeMarker> supertypes$iv = $this$anySupertype_u24lambda_u243$iv.supertypes($this$anySupertype_u24lambda_u243$iv.typeConstructor(current$iv));
                    for (KotlinTypeMarker supertype$iv : supertypes$iv) {
                        boolean bl6;
                        SimpleTypeMarker newType$iv;
                        typeMarker = newType$iv = policy$iv.transformType(this_$iv, supertype$iv);
                        bl2 = false;
                        Intrinsics.checkNotNull(typeMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType");
                        correspondingKotlinClass = FirCastDiagnosticsHelpersKt.getCorrespondingKotlinClass((ConeSimpleKotlinType)typeMarker, session2);
                        if (Intrinsics.areEqual(TypeSystemContextHelpersKt.typeConstructor(correspondingKotlinClass, state.getTypeSystemContext()), superTypeConstructor)) {
                            result2 = true;
                            bl6 = true;
                        } else {
                            bl6 = false;
                        }
                        if (bl6) {
                            this_$iv.clear();
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                this_$iv.clear();
            }
        }
        return result2;
    }

    private static final ConeSimpleKotlinType getCorrespondingKotlinClass(ConeSimpleKotlinType type2, FirSession session2) {
        Object object = FirPlatformClassMapperKt.getPlatformClassMapper(session2).getCorrespondingKotlinClass(ConeTypeUtilsKt.getClassId(type2));
        return object != null && (object = ScopeUtilsKt.defaultType((ClassId)object, CollectionsKt.emptyList())) != null ? (ConeSimpleKotlinType)object : type2;
    }

    private static final boolean isFinal(ConeSimpleKotlinType type2, FirSession session2) {
        return !TypeUtilsKt.canHaveSubtypes(type2, session2);
    }

    public static final boolean isCastErased(@NotNull ConeKotlinType supertype2, @NotNull ConeKotlinType subtype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(subtype, "subtype");
        Intrinsics.checkNotNullParameter(context2, "context");
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession());
        boolean isNonReifiedTypeParameter = FirCastDiagnosticsHelpersKt.isNonReifiedTypeParameter(subtype);
        boolean isUpcast = FirCastDiagnosticsHelpersKt.isUpcast(context2, supertype2, subtype);
        if (isNonReifiedTypeParameter && !isUpcast) {
            boolean nullableToDefinitelyNotNull;
            boolean bl = nullableToDefinitelyNotNull = !FirTypeUtilsKt.getCanBeNull(subtype) && Intrinsics.areEqual(TypeUtilsKt.withNullability$default(supertype2, ConeNullability.NOT_NULL, typeContext2, null, false, 12, null), subtype);
            if (!nullableToDefinitelyNotNull) {
                return true;
            }
        }
        if (!(supertype2 instanceof ConeErrorType) && ConeTypeUtilsKt.isMarkedNullable(supertype2) || !(subtype instanceof ConeErrorType) && ConeTypeUtilsKt.isMarkedNullable(subtype)) {
            return FirCastDiagnosticsHelpersKt.isCastErased(TypeUtilsKt.withNullability$default(supertype2, ConeNullability.NOT_NULL, typeContext2, null, false, 12, null), TypeUtilsKt.withNullability$default(subtype, ConeNullability.NOT_NULL, typeContext2, null, false, 12, null), context2);
        }
        if (isUpcast) {
            return false;
        }
        if (isNonReifiedTypeParameter) {
            return true;
        }
        if (subtype instanceof ConeTypeParameterType) {
            return false;
        }
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol(subtype, context2.getSession());
        if (firRegularClassSymbol == null) {
            return true;
        }
        FirRegularClassSymbol regularClassSymbol = firRegularClassSymbol;
        Set<FirClassLikeSymbol<?>> outerClasses2 = LookupTagUtilsKt.getClassAndItsOuterClassesWhenLocal(regularClassSymbol, context2.getSession());
        FirClassLikeSymbol $this$isLocal$iv = regularClassSymbol;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getClassId().isLocal()) {
            boolean bl;
            block12: {
                Iterable $this$any$iv = regularClassSymbol.getTypeParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                        boolean bl2 = false;
                        if (!(!CollectionsKt.contains((Iterable)outerClasses2, it.getContainingDeclarationSymbol()))) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        ConeKotlinType staticallyKnownSubtype = FirCastDiagnosticsHelpersKt.findStaticallyKnownSubtype(supertype2, regularClassSymbol, context2);
        return !AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)staticallyKnownSubtype, (KotlinTypeMarker)subtype, false);
    }

    @NotNull
    public static final ConeKotlinType findStaticallyKnownSubtype(@NotNull ConeKotlinType supertype2, @NotNull FirRegularClassSymbol subTypeClassSymbol, @NotNull CheckerContext context2) {
        Collection collection;
        boolean bl;
        Intrinsics.checkNotNullParameter(supertype2, "supertype");
        Intrinsics.checkNotNullParameter(subTypeClassSymbol, "subTypeClassSymbol");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean bl2 = bl = !ConeTypeUtilsKt.isMarkedNullable(supertype2);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = false;
            String $i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22 = "This method only makes sense for non-nullable types";
            throw new AssertionError((Object)$i$a$-assert-FirCastDiagnosticsHelpersKt$findStaticallyKnownSubtype$22);
        }
        FirSession session2 = context2.getSession();
        ConeInferenceContext typeContext2 = TypeComponentsKt.getTypeContext(session2);
        ConeClassLikeType subtypeWithVariablesType = ScopeUtilsKt.defaultType(subTypeClassSymbol);
        TypeCheckerState typeCheckerState2 = TypeComponentsKt.getTypeContext(context2.getSession()).newTypeCheckerState(false, false);
        if (supertype2 instanceof ConeIntersectionType) {
            collection = ((ConeIntersectionType)supertype2).getIntersectedTypes();
        } else {
            ArrayList<ConeKotlinType> arrayList = new ArrayList<ConeKotlinType>(1);
            ArrayList<ConeKotlinType> it = arrayList;
            boolean bl3 = false;
            it.add(supertype2);
            collection = arrayList;
        }
        Collection normalizedTypes = collection;
        Map resultSubstitution = new LinkedHashMap();
        for (ConeKotlinType normalizedType : normalizedTypes) {
            Map map;
            SimpleTypeMarker supertypeWithVariables = CollectionsKt.firstOrNull(AbstractTypeChecker.INSTANCE.findCorrespondingSupertypes(typeCheckerState2, subtypeWithVariablesType, TypeSystemContextHelpersKt.typeConstructor(normalizedType, typeContext2)));
            List<FirTypeParameterSymbol> variables2 = subTypeClassSymbol.getTypeParameterSymbols();
            if (supertypeWithVariables != null) {
                Map result2 = new LinkedHashMap();
                map = TypeUnificationKt.doUnify(context2.getSession(), supertype2, (ConeKotlinTypeProjection)((Object)supertypeWithVariables), CollectionsKt.toSet((Iterable)variables2), result2) ? result2 : (Map)new LinkedHashMap();
            } else {
                map = new LinkedHashMap();
            }
            Map substitution = map;
            for (FirTypeParameterSymbol variable2 : variables2) {
                ConeTypeProjection value2 = (ConeTypeProjection)substitution.get(variable2);
                ConeKotlinType resultValue = value2 == null ? null : (value2 instanceof ConeStarProjection ? (ConeKotlinType)new ConeStubTypeForTypeVariableInSubtyping(new ConeTypeVariable("", null), ConeNullability.NULLABLE) : ConeTypeProjectionKt.getType(value2));
                if (resultValue == null) continue;
                resultSubstitution.put(variable2, resultValue);
            }
        }
        ConeSubstitutorByMap substitutor2 = new ConeSubstitutorByMap(resultSubstitution, session2);
        return substitutor2.substituteOrSelf(subtypeWithVariablesType);
    }

    public static final boolean isNonReifiedTypeParameter(@NotNull ConeKotlinType $this$isNonReifiedTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isNonReifiedTypeParameter, "<this>");
        return $this$isNonReifiedTypeParameter instanceof ConeTypeParameterType && !((ConeTypeParameterType)$this$isNonReifiedTypeParameter).getLookupTag().getTypeParameterSymbol().isReified();
    }

    public static final boolean isUpcast(@NotNull CheckerContext context2, @NotNull ConeKotlinType candidateType, @NotNull ConeKotlinType targetType) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(candidateType, "candidateType");
        Intrinsics.checkNotNullParameter(targetType, "targetType");
        if (!AbstractTypeChecker.INSTANCE.isSubtypeOf(TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)candidateType, (KotlinTypeMarker)targetType, false)) {
            return false;
        }
        return CompilerConeAttributesKt.isExtensionFunctionType(candidateType) == CompilerConeAttributesKt.isExtensionFunctionType(targetType);
    }
}

