/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BlockInfo;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntIncr;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "isPrefix", "", "(Z)V", "invoke", "Lorg/jetbrains/kotlin/backend/jvm/codegen/PromisedValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "codegen", "Lorg/jetbrains/kotlin/backend/jvm/codegen/ExpressionCodegen;", "data", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BlockInfo;", "backend.jvm.codegen"})
public final class IntIncr
extends IntrinsicMethod {
    private final boolean isPrefix;

    public IntIncr(boolean isPrefix) {
        this.isPrefix = isPrefix;
    }

    @Override
    @NotNull
    public PromisedValue invoke(@NotNull IrFunctionAccessExpression expression2, @NotNull ExpressionCodegen codegen2, @NotNull BlockInfo data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(codegen2, "codegen");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrExpression irExpression = expression2.getValueArgument(0);
        IrGetValue irGetValue = irExpression instanceof IrGetValue ? (IrGetValue)irExpression : null;
        if (irGetValue == null) {
            throw new IllegalStateException(("IrGetValue expected as valueArgument #0: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)).toString());
        }
        IrGetValue irGetValue2 = irGetValue;
        IrExpression irExpression2 = expression2.getValueArgument(1);
        IrConst irConst = irExpression2 instanceof IrConst ? (IrConst)irExpression2 : null;
        if (irConst == null) {
            throw new IllegalStateException(("IrConst expected as valueArgument #1: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)).toString());
        }
        IrConst irDelta = irConst;
        if (!Intrinsics.areEqual(irDelta.getKind(), IrConstKind.Int.INSTANCE)) {
            throw new IllegalStateException(("Int const expected: " + DumpIrTreeKt.dump$default(irDelta, null, 1, null)).toString());
        }
        int delta = ((Number)IrConstKind.Int.INSTANCE.valueOf(irDelta)).intValue();
        if (delta > 127 || delta < -128) {
            throw new IllegalStateException(("Int const should be in (Byte.MIN_VALUE .. Byte.MAX_VALUE): " + DumpIrTreeKt.dump$default(irDelta, null, 1, null)).toString());
        }
        int varIndex = codegen2.getFrameMap().getIndex(irGetValue2.getSymbol());
        if (varIndex == -1) {
            throw new IllegalStateException(("Unmapped variable: " + RenderIrElementKt.render$default(irGetValue2, null, 1, null)).toString());
        }
        if (this.isPrefix) {
            codegen2.getMv().iinc(varIndex, delta);
            PromisedValueKt.materialize((PromisedValue)irGetValue2.accept(codegen2, data2));
        } else {
            PromisedValueKt.materialize((PromisedValue)irGetValue2.accept(codegen2, data2));
            codegen2.getMv().iinc(varIndex, delta);
        }
        Type type2 = Type.INT_TYPE;
        Intrinsics.checkNotNullExpressionValue(type2, "INT_TYPE");
        return new MaterialValue(codegen2, type2, irGetValue2.getType());
    }
}

