/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirInternals;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirAbstractSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirCommonSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJsSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirJvmSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirNativeSessionFactory;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtCodeFragmentModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibraryModule;
import org.jetbrains.kotlin.analysis.project.structure.KtLibrarySourceModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptDependencyModule;
import org.jetbrains.kotlin.analysis.project.structure.KtScriptModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSdkModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.platform.JsPlatform;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatform;

@LLFirInternals
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002JK\u0010\u0010\u001a\u00020\b\"\b\b\u0000\u0010\u0011*\u00020\u00072\u0006\u0010\u000e\u001a\u0002H\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\b0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0015\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ5\u0010\u001d\u001a\u00020\u001c2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0014H\u0082\bJ\u0006\u0010\u001f\u001a\u00020\u001cJ \u0010 \u001a\u00020\u001c2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0018J \u0010#\u001a\u00020\u001c2\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u0007J(\u0010%\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00072\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "binaryCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/SessionStorage;", "codeFragmentSessionCache", "sourceCache", "createPlatformAwareSessionFactory", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirAbstractSessionFactory;", "module", "createSession", "getCachedSession", "T", "storage", "factory", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;Ljava/util/concurrent/ConcurrentMap;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "getSession", "preferBinary", "", "getSessionNoCaching", "getSessionNoCaching$low_level_api_fir", "removeAllCodeFragmentSessions", "", "removeAllMatchingSessionsFrom", "shouldBeRemoved", "removeAllScriptSessions", "removeAllScriptSessionsFrom", "removeAllSessions", "includeLibraryModules", "removeAllSessionsFrom", "removeSession", "removeSessionFrom", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nLLFirSessionCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n+ 2 utils.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/util/UtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n148#1:214\n149#1,5:218\n148#1:223\n149#1,5:227\n37#2,2:211\n1#3:213\n764#4:215\n855#4,2:216\n764#4:224\n855#4,2:225\n1853#4,2:232\n764#4:234\n855#4,2:235\n1724#4,3:237\n1724#4,3:240\n1724#4,3:243\n*S KotlinDebug\n*F\n+ 1 LLFirSessionCache.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache\n*L\n114#1:214\n114#1:218,5\n133#1:223\n133#1:227,5\n72#1:211,2\n114#1:215\n114#1:216,2\n133#1:224\n133#1:225,2\n139#1:232,2\n148#1:234\n148#1:235,2\n176#1:237,3\n177#1:240,3\n178#1:243,3\n*E\n"})
public final class LLFirSessionCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<KtModule, LLFirSession> sourceCache;
    @NotNull
    private final ConcurrentMap<KtModule, LLFirSession> binaryCache;
    @NotNull
    private final ConcurrentMap<KtModule, LLFirSession> codeFragmentSessionCache;

    public LLFirSessionCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        this.project = project;
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createConcurrentSoftValueMap(...)");
        this.sourceCache = concurrentMap;
        ConcurrentMap concurrentMap2 = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap2, "createConcurrentSoftValueMap(...)");
        this.binaryCache = concurrentMap2;
        ConcurrentMap concurrentMap3 = CollectionFactory.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap3, "createConcurrentSoftValueMap(...)");
        this.codeFragmentSessionCache = concurrentMap3;
    }

    @NotNull
    public final LLFirSession getSession(@NotNull KtModule module2, boolean preferBinary) {
        Intrinsics.checkNotNullParameter(module2, "module");
        if (module2 instanceof KtBinaryModule && (preferBinary || module2 instanceof KtSdkModule)) {
            return this.getCachedSession(module2, this.binaryCache, (Function1)new Function1<KtBinaryModule, LLFirSession>(this, module2){
                final /* synthetic */ LLFirSessionCache this$0;
                final /* synthetic */ KtModule $module;
                {
                    this.this$0 = $receiver;
                    this.$module = $module;
                    super(1);
                }

                public final LLFirSession invoke(KtBinaryModule it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return LLFirSessionCache.access$createPlatformAwareSessionFactory(this.this$0, this.$module).createBinaryLibrarySession((KtBinaryModule)this.$module);
                }
            });
        }
        ConcurrentMap<KtModule, LLFirSession> targetCache = module2 instanceof KtCodeFragmentModule ? this.codeFragmentSessionCache : this.sourceCache;
        return this.getCachedSession(module2, targetCache, (Function1)new Function1<KtModule, LLFirSession>((Object)this){

            public final LLFirSession invoke(KtModule p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return LLFirSessionCache.access$createSession((LLFirSessionCache)this.receiver, p0);
            }

            public final String getSignature() {
                return "createSession(Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;";
            }

            public final String getName() {
                return "createSession";
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(LLFirSessionCache.class);
            }
        });
    }

    public static /* synthetic */ LLFirSession getSession$default(LLFirSessionCache lLFirSessionCache, KtModule ktModule2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lLFirSessionCache.getSession(ktModule2, bl);
    }

    @NotNull
    public final LLFirSession getSessionNoCaching$low_level_api_fir(@NotNull KtModule module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        return this.createSession(module2);
    }

    private final <T extends KtModule> LLFirSession getCachedSession(T module2, ConcurrentMap<KtModule, LLFirSession> storage2, Function1<? super T, ? extends LLFirSession> factory2) {
        LLFirSession lLFirSession;
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
        LLFirSession session2 = lLFirSession = storage2.computeIfAbsent(module2, arg_0 -> LLFirSessionCache.getCachedSession$lambda$0(new Function1<KtModule, LLFirSession>(factory2, module2){
            final /* synthetic */ Function1<T, LLFirSession> $factory;
            final /* synthetic */ T $module;
            {
                this.$factory = $factory;
                this.$module = $module;
                super(1);
            }

            public final LLFirSession invoke(KtModule it) {
                return this.$factory.invoke(this.$module);
            }
        }, arg_0));
        boolean bl = false;
        if (!session2.isValid()) {
            boolean bl2 = false;
            String string2 = "A session acquired via `getSession` should always be valid. Module: " + module2;
            throw new IllegalArgumentException(string2.toString());
        }
        LLFirSession lLFirSession2 = lLFirSession;
        Intrinsics.checkNotNullExpressionValue(lLFirSession2, "also(...)");
        return lLFirSession2;
    }

    public final boolean removeSession(@NotNull KtModule module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean didSourceSessionExist = this.removeSessionFrom(module2, this.sourceCache);
        boolean didBinarySessionExist = module2 instanceof KtBinaryModule && this.removeSessionFrom(module2, this.binaryCache);
        boolean didCodeFragmentSessionExist = module2 instanceof KtCodeFragmentModule && this.removeSessionFrom(module2, this.codeFragmentSessionCache);
        return didSourceSessionExist || didBinarySessionExist || didCodeFragmentSessionExist;
    }

    private final boolean removeSessionFrom(KtModule module2, ConcurrentMap<KtModule, LLFirSession> storage2) {
        LLFirSession lLFirSession = (LLFirSession)storage2.remove(module2);
        if (lLFirSession == null) {
            return false;
        }
        LLFirSession session2 = lLFirSession;
        session2.markInvalid$low_level_api_fir();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeAllSessions(boolean includeLibraryModules) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (includeLibraryModules) {
            this.removeAllSessionsFrom(this.sourceCache);
            this.removeAllSessionsFrom(this.binaryCache);
        } else {
            void $this$filterTo$iv$iv$iv;
            LLFirSessionCache lLFirSessionCache = this;
            ConcurrentMap<KtModule, LLFirSession> storage$iv = this.sourceCache;
            boolean $i$f$removeAllMatchingSessionsFrom = false;
            Iterable $this$filter$iv$iv = storage$iv.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                boolean bl = false;
                KtModule module$iv = (KtModule)entry.getKey();
                Intrinsics.checkNotNull(module$iv);
                KtModule it = module$iv;
                boolean bl2 = false;
                boolean bl3 = !(it instanceof KtBinaryModule) && !(it instanceof KtLibrarySourceModule);
                if (!bl3) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            List scriptEntries$iv = (List)destination$iv$iv$iv;
            for (Map.Entry entry : scriptEntries$iv) {
                KtModule module$iv = (KtModule)entry.getKey();
                LLFirSession session$iv = (LLFirSession)entry.getValue();
                session$iv.markInvalid$low_level_api_fir();
                storage$iv.remove(module$iv);
            }
        }
        this.removeAllCodeFragmentSessions();
    }

    public final void removeAllCodeFragmentSessions() {
        this.removeAllSessionsFrom(this.codeFragmentSessionCache);
    }

    public final void removeAllScriptSessions() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeAllScriptSessionsFrom(this.sourceCache);
        this.removeAllScriptSessionsFrom(this.binaryCache);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllScriptSessionsFrom(ConcurrentMap<KtModule, LLFirSession> storage2) {
        void $this$filterTo$iv$iv$iv;
        LLFirSessionCache this_$iv = this;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$filter$iv$iv = storage2.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            boolean bl = false;
            KtModule module$iv = (KtModule)entry.getKey();
            Intrinsics.checkNotNull(module$iv);
            KtModule it = module$iv;
            boolean bl2 = false;
            boolean bl3 = it instanceof KtScriptModule || it instanceof KtScriptDependencyModule;
            if (!bl3) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List scriptEntries$iv = (List)destination$iv$iv$iv;
        for (Map.Entry entry : scriptEntries$iv) {
            KtModule module$iv = (KtModule)entry.getKey();
            LLFirSession session$iv = (LLFirSession)entry.getValue();
            session$iv.markInvalid$low_level_api_fir();
            storage2.remove(module$iv);
        }
    }

    private final void removeAllSessionsFrom(ConcurrentMap<KtModule, LLFirSession> storage2) {
        Iterable $this$forEach$iv = storage2.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLFirSession it = (LLFirSession)element$iv;
            boolean bl = false;
            it.markInvalid$low_level_api_fir();
        }
        storage2.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllMatchingSessionsFrom(ConcurrentMap<KtModule, LLFirSession> storage2, Function1<? super KtModule, Boolean> shouldBeRemoved) {
        void $this$filterTo$iv$iv;
        boolean $i$f$removeAllMatchingSessionsFrom = false;
        Iterable $this$filter$iv = storage2.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            KtModule module2 = (KtModule)entry.getKey();
            Intrinsics.checkNotNull(module2);
            if (!shouldBeRemoved.invoke(module2).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List scriptEntries = (List)destination$iv$iv;
        for (Map.Entry entry : scriptEntries) {
            KtModule module3 = (KtModule)entry.getKey();
            LLFirSession session2 = (LLFirSession)entry.getValue();
            session2.markInvalid$low_level_api_fir();
            storage2.remove(module3);
        }
    }

    private final LLFirSession createSession(KtModule module2) {
        LLFirSession lLFirSession;
        LLFirAbstractSessionFactory sessionFactory = this.createPlatformAwareSessionFactory(module2);
        KtModule ktModule2 = module2;
        if (ktModule2 instanceof KtSourceModule) {
            lLFirSession = sessionFactory.createSourcesSession((KtSourceModule)module2);
        } else if (ktModule2 instanceof KtLibraryModule ? true : ktModule2 instanceof KtLibrarySourceModule) {
            lLFirSession = sessionFactory.createLibrarySession(module2);
        } else if (ktModule2 instanceof KtSdkModule) {
            lLFirSession = sessionFactory.createBinaryLibrarySession((KtBinaryModule)module2);
        } else if (ktModule2 instanceof KtScriptModule) {
            lLFirSession = sessionFactory.createScriptSession((KtScriptModule)module2);
        } else if (ktModule2 instanceof KtCodeFragmentModule) {
            LLFirSession contextSession = this.getSession(((KtCodeFragmentModule)module2).getContextModule(), false);
            lLFirSession = sessionFactory.createCodeFragmentSession((KtCodeFragmentModule)module2, contextSession);
        } else if (ktModule2 instanceof KtNotUnderContentRootModule) {
            lLFirSession = sessionFactory.createNotUnderContentRootResolvableSession((KtNotUnderContentRootModule)module2);
        } else {
            throw new IllegalStateException(("Unexpected module kind: " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).toString());
        }
        return lLFirSession;
    }

    private final LLFirAbstractSessionFactory createPlatformAwareSessionFactory(KtModule module2) {
        LLFirAbstractSessionFactory lLFirAbstractSessionFactory;
        SimplePlatform it;
        boolean bl;
        boolean $i$f$all;
        Iterable $this$all$iv;
        TargetPlatform targetPlatform;
        block13: {
            targetPlatform = module2.getPlatform();
            $this$all$iv = targetPlatform;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (SimplePlatform)element$iv;
                    boolean bl2 = false;
                    if (it instanceof JvmPlatform) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            lLFirAbstractSessionFactory = new LLFirJvmSessionFactory(this.project);
        } else {
            boolean bl3;
            block14: {
                $this$all$iv = targetPlatform;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (SimplePlatform)element$iv;
                        boolean bl4 = false;
                        if (it instanceof JsPlatform) continue;
                        bl3 = false;
                        break block14;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                lLFirAbstractSessionFactory = new LLFirJsSessionFactory(this.project);
            } else {
                boolean bl5;
                block15: {
                    $this$all$iv = targetPlatform;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (SimplePlatform)element$iv;
                            boolean bl6 = false;
                            if (it instanceof NativePlatform) continue;
                            bl5 = false;
                            break block15;
                        }
                        bl5 = true;
                    }
                }
                lLFirAbstractSessionFactory = bl5 ? (LLFirAbstractSessionFactory)new LLFirNativeSessionFactory(this.project) : (LLFirAbstractSessionFactory)new LLFirCommonSessionFactory(this.project);
            }
        }
        return lLFirAbstractSessionFactory;
    }

    private static final LLFirSession getCachedSession$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (LLFirSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ LLFirAbstractSessionFactory access$createPlatformAwareSessionFactory(LLFirSessionCache $this, KtModule module2) {
        return $this.createPlatformAwareSessionFactory(module2);
    }

    public static final /* synthetic */ LLFirSession access$createSession(LLFirSessionCache $this, KtModule module2) {
        return $this.createSession(module2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionCache;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LLFirSessionCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            LLFirSessionCache lLFirSessionCache = project.getService(LLFirSessionCache.class);
            Intrinsics.checkNotNullExpressionValue(lLFirSessionCache, "getService(...)");
            return lLFirSessionCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

