/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PatternCondition<T> {
    private static final Logger LOG = Logger.getInstance(PatternCondition.class);
    @NonNls
    private static final String PARAMETER_FIELD_PREFIX = "val$";
    private final String myDebugMethodName;

    public PatternCondition(@Nullable @NonNls String debugMethodName) {
        this.myDebugMethodName = debugMethodName;
    }

    public String getDebugMethodName() {
        return this.myDebugMethodName;
    }

    private static void appendValue(StringBuilder builder2, String indent, Object obj) {
        if (obj instanceof ElementPattern) {
            ((ElementPattern)obj).getCondition().append(builder2, indent + "  ");
        } else if (obj instanceof Object[]) {
            PatternCondition.appendArray(builder2, indent, (Object[])obj);
        } else if (obj instanceof Collection) {
            PatternCondition.appendArray(builder2, indent, ((Collection)obj).toArray());
        } else if (obj instanceof String) {
            builder2.append('\"').append(obj).append('\"');
        } else {
            builder2.append(obj);
        }
    }

    protected static void appendArray(StringBuilder builder2, String indent, Object[] objects) {
        builder2.append("[");
        boolean first = true;
        for (Object o : objects) {
            if (!first) {
                builder2.append(", ");
            }
            first = false;
            PatternCondition.appendValue(builder2, indent, o);
        }
        builder2.append("]");
    }

    public abstract boolean accepts(@NotNull T var1, ProcessingContext var2);

    @NonNls
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        this.append(builder2, "");
        return builder2.toString();
    }

    public void append(StringBuilder builder2, String indent) {
        builder2.append(this.myDebugMethodName);
        builder2.append("(");
        this.appendParams(builder2, indent);
        builder2.append(")");
    }

    private void appendParams(final StringBuilder builder2, final String indent) {
        this.processParameters((PairProcessor<String, Object>)new PairProcessor<String, Object>(){
            int count;
            String prevName;
            int prevOffset;

            @Override
            public boolean process(String name2, Object value2) {
                ++this.count;
                if (this.count == 2) {
                    builder2.insert(this.prevOffset, this.prevName + "=");
                }
                if (this.count > 1) {
                    builder2.append(", ");
                }
                this.prevOffset = builder2.length();
                if (this.count > 1) {
                    builder2.append(name2).append("=");
                }
                PatternCondition.appendValue(builder2, indent, value2);
                this.prevName = name2;
                return true;
            }
        });
    }

    public boolean processParameters(PairProcessor<? super String, Object> processor2) {
        for (Class<?> aClass = this.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            for (Field field2 : aClass.getDeclaredFields()) {
                Object value2;
                String name2;
                String fixedName;
                if (Modifier.isStatic(field2.getModifiers()) || (field2.isSynthetic() || aClass.equals(PatternCondition.class)) && !field2.getName().startsWith(PARAMETER_FIELD_PREFIX) || processor2.process(fixedName = (name2 = field2.getName()).startsWith(PARAMETER_FIELD_PREFIX) ? name2.substring(PARAMETER_FIELD_PREFIX.length()) : name2, value2 = this.getFieldValue(field2))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFieldValue(Field field2) {
        boolean accessible = field2.isAccessible();
        try {
            field2.setAccessible(true);
            Object object = field2.get(this);
            return object;
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
        }
        finally {
            field2.setAccessible(accessible);
        }
        return null;
    }
}

