/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.lang.LighterASTNode;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u0010\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J>\u0010\u0017\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001fH\u0002J \u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationOnSuperclass", "superTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkClassCannotBeExtendedDirectly", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "checkProjectionInImmediateArgumentToSupertype", "", "coneType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkExpandedTypeCannotBeInherited", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "fullyExpandedType", "checkSupertypeOnTypeAliasWithTypeProjection", "checkDelegationNotToInterface", "checkNamedFunctionTypeParameter", "findSourceForParameterName", "Lorg/jetbrains/kotlin/KtSourceElement;", "Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "checkDelegationWithoutPrimaryConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 7 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,272:1\n40#2:273\n12574#3,2:274\n21#4:276\n57#4:285\n37#4:287\n21#4:288\n1#5:277\n803#6,7:278\n34#7:286\n*S KotlinDebug\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n*L\n87#1:273\n191#1:274,2\n204#1:276\n254#1:285\n255#1:287\n260#1:288\n241#1:278,7\n254#1:286\n*E\n"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration2.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        boolean isInterface = declaration2.getClassKind() == ClassKind.INTERFACE;
        boolean nullableSupertypeReported = false;
        boolean extensionFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = !isInterface;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        HashSet superClassSymbols = new HashSet();
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            if (superTypeRef.getSource() == null) continue;
            KtSourceElement ktSourceElement2 = superTypeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.EnumSuperTypeRef.INSTANCE)) continue;
            ConeKotlinType coneType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(superTypeRef));
            if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                nullableSupertypeReported = true;
            }
            if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.FunctionalTypeWithExtensionAsSupertype)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
                extensionFunctionSupertypeReported = true;
            }
            this.checkAnnotationOnSuperclass(superTypeRef, context2, reporter);
            ConeKotlinType fullyExpandedType2 = FirTypeUtilsKt.getConeType(superTypeRef);
            FirClassifierSymbol<?> symbol = TypeUtilsKt.toSymbol(fullyExpandedType2, context2.getSession());
            if (symbol instanceof FirRegularClassSymbol) {
                boolean isObject;
                if (!superClassSymbols.add(symbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), (DiagnosticContext)context2, null, 8, null);
                }
                if (((FirRegularClassSymbol)symbol).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), (DiagnosticContext)context2, null, 8, null);
                    } else {
                        classAppeared = true;
                    }
                    if (!interfaceWithSuperclassReported) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), (DiagnosticContext)context2, null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl = isObject = ((FirRegularClassSymbol)symbol).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject) {
                    FirClassLikeSymbol $this$modality$iv = (FirClassLikeSymbol)symbol;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            this.checkClassCannotBeExtendedDirectly(symbol, reporter, superTypeRef, context2);
            this.checkNamedFunctionTypeParameter(superTypeRef, context2, reporter);
            boolean bl = !(coneType.getTypeArguments().length == 0) ? !this.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter, context2) : !this.checkExpandedTypeCannotBeInherited((FirBasedSymbol)symbol, fullyExpandedType2, reporter, superTypeRef, coneType, context2);
            boolean shouldCheckSupertypeOnTypealiasWithTypeProjection = bl;
            if (!shouldCheckSupertypeOnTypealiasWithTypeProjection) continue;
            this.checkSupertypeOnTypeAliasWithTypeProjection(coneType, fullyExpandedType2, superTypeRef, reporter, context2);
        }
        this.checkDelegationNotToInterface(declaration2, context2, reporter);
        this.checkDelegationWithoutPrimaryConstructor(declaration2, context2, reporter);
        if (declaration2 instanceof FirRegularClass && ((FirRegularClass)declaration2).getSuperTypeRefs().size() > 1) {
            FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(CollectionsKt.listOf((Object)new Pair(null, (Object)((FirRegularClass)declaration2).getSymbol())), context2, reporter, ((FirRegularClass)declaration2).getSource(), true);
        }
    }

    private final void checkAnnotationOnSuperclass(FirTypeRef superTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirAnnotation annotation : superTypeRef.getAnnotations()) {
            if (annotation.getUseSiteTarget() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkClassCannotBeExtendedDirectly(FirClassifierSymbol<?> symbol, DiagnosticReporter reporter, FirTypeRef superTypeRef, CheckerContext context2) {
        if (symbol instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)symbol).getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), symbol, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean checkProjectionInImmediateArgumentToSupertype(ConeKotlinType coneType, FirTypeRef superTypeRef, DiagnosticReporter reporter, CheckerContext context2) {
        List<FirTypeRefSource> list = FirHelpersKt.extractArgumentsTypeRefAndSource(superTypeRef);
        if (list == null) {
            return false;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list;
        boolean result2 = false;
        ConeTypeProjection[] coneTypeProjectionArray = coneType.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[i];
            if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
            FirTypeRefSource firTypeRefSource = (FirTypeRefSource)CollectionsKt.getOrNull(typeRefAndSourcesForArguments, (int)index);
            if (firTypeRefSource == null) continue;
            KtSourceElement argSource = firTypeRefSource.component2();
            KtSourceElement ktSourceElement = argSource;
            if (ktSourceElement == null) {
                ktSourceElement = superTypeRef.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
            result2 = true;
        }
        return result2;
    }

    private final boolean checkExpandedTypeCannotBeInherited(FirBasedSymbol<?> symbol, ConeKotlinType fullyExpandedType2, DiagnosticReporter reporter, FirTypeRef superTypeRef, ConeKotlinType coneType, CheckerContext context2) {
        if (symbol instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)symbol).getClassKind() == ClassKind.INTERFACE) {
            for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
                if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getEXPANDED_TYPE_CANNOT_BE_INHERITED(), (Object)coneType, (DiagnosticContext)context2, null, 16, null);
                return true;
            }
        }
        return false;
    }

    private final void checkSupertypeOnTypeAliasWithTypeProjection(ConeKotlinType coneType, ConeKotlinType fullyExpandedType2, FirTypeRef superTypeRef, DiagnosticReporter reporter, CheckerContext context2) {
        if (TypeUtilsKt.toSymbol(coneType, context2.getSession()) instanceof FirTypeAliasSymbol) {
            boolean bl;
            block3: {
                ConeTypeProjection[] $this$any$iv = fullyExpandedType2.getTypeArguments();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    ConeTypeProjection element$iv;
                    ConeTypeProjection it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!FirHelpersKt.isConflictingOrNotInvariant(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCONSTRUCTOR_OR_SUPERTYPE_ON_TYPEALIAS_WITH_TYPE_PROJECTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkDelegationNotToInterface(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirDeclaration subDeclaration : declaration2.getDeclarations()) {
            FirRegularClassSymbol delegatedClassSymbol;
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName()) || (delegatedClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirField)subDeclaration).getReturnTypeRef(), context2.getSession())) == null || delegatedClassSymbol.getClassKind() == ClassKind.INTERFACE) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirField)subDeclaration).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkNamedFunctionTypeParameter(FirTypeRef superTypeRef, CheckerContext context2, DiagnosticReporter reporter) {
        FirTypeRef firTypeRef = superTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)superTypeRef : null;
        if (firTypeRef == null || (firTypeRef = firTypeRef.getDelegatedTypeRef()) == null) {
            return;
        }
        FirTypeRef delegatedTypeRef = firTypeRef;
        if (!(delegatedTypeRef instanceof FirFunctionTypeRef)) {
            return;
        }
        for (FirFunctionTypeParameter parameter2 : ((FirFunctionTypeRef)delegatedTypeRef).getParameters()) {
            KtSourceElement source;
            if (parameter2.getName() == null || this.findSourceForParameterName(parameter2) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"named parameter in function type in supertype position", (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KtSourceElement findSourceForParameterName(FirFunctionTypeParameter $this$findSourceForParameterName) {
        void endOffset$iv;
        void startOffset$iv;
        void $this$toKtLightSourceElement_u24default$iv;
        LighterASTNode node;
        Object v2;
        FlyweightCapableTreeStructure<LighterASTNode> treeStructure;
        block4: {
            KtSourceElement ktSourceElement = $this$findSourceForParameterName.getSource();
            if (ktSourceElement == null) {
                return null;
            }
            KtSourceElement source = ktSourceElement;
            Name name2 = $this$findSourceForParameterName.getName();
            if (name2 == null) {
                return null;
            }
            Name name3 = name2;
            treeStructure = source.getTreeStructure();
            List<LighterASTNode> nodes = LightTreeUtilsKt.getChildren(source.getLighterASTNode(), treeStructure);
            Iterable iterable = nodes;
            for (Object t : iterable) {
                LighterASTNode it = (LighterASTNode)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtTokens.IDENTIFIER) && Intrinsics.areEqual((Object)treeStructure.toString(it), (Object)name3.getIdentifier()))) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        LighterASTNode lighterASTNode = v2;
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode lighterASTNode2 = node = lighterASTNode;
        int n = node.getStartOffset();
        int n2 = node.getEndOffset();
        KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
        boolean $i$f$toKtLightSourceElement = false;
        return new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, (int)startOffset$iv, (int)endOffset$iv, treeStructure, kind$iv);
    }

    private final void checkDelegationWithoutPrimaryConstructor(FirClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirClass $this$isInterface$iv = declaration2;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl) {
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return;
        }
        FirConstructorSymbol primaryConstructor2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
        if (primaryConstructor2 != null) {
            return;
        }
        for (FirDeclaration subDeclaration : declaration2.getDeclarations()) {
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirField)subDeclaration).getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Delegation without primary constructor is not supported", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

