/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkOuterClassArgumentsRequired", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOuterClassArgumentsRequiredChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOuterClassArgumentsRequiredChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class FirOuterClassArgumentsRequiredChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOuterClassArgumentsRequiredChecker INSTANCE = new FirOuterClassArgumentsRequiredChecker();

    private FirOuterClassArgumentsRequiredChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            this.checkOuterClassArgumentsRequired(superTypeRef, declaration2, context2, reporter);
        }
    }

    private final void checkOuterClassArgumentsRequired(FirTypeRef typeRef, FirRegularClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirClassLikeSymbol<?> symbol;
        if (!(typeRef instanceof FirResolvedTypeRef) || typeRef instanceof FirErrorTypeRef) {
            return;
        }
        ConeKotlinType type2 = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(((FirResolvedTypeRef)typeRef).getType());
        FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
        if (delegatedTypeRef instanceof FirUserTypeRef && type2 instanceof ConeClassLikeType && (symbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), context2.getSession())) instanceof FirRegularClassSymbol) {
            ConeTypeProjection[] typeArguments2 = DeclarationUtilsKt.toTypeProjections(((FirUserTypeRef)delegatedTypeRef).getQualifier());
            List<FirTypeParameterSymbol> typeParameters2 = ((FirRegularClassSymbol)symbol).getTypeParameterSymbols();
            int n = typeParameters2.size();
            for (int index = typeArguments2.length; index < n; ++index) {
                FirTypeParameterSymbol typeParameter = typeParameters2.get(index);
                if (DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(typeParameter, declaration2, context2.getSession())) continue;
                FirBasedSymbol<?> firBasedSymbol = typeParameter.getContainingDeclarationSymbol();
                FirRegularClassSymbol firRegularClassSymbol = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
                if (firRegularClassSymbol == null) break;
                FirRegularClassSymbol outerClass = firRegularClassSymbol;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedTypeRef)typeRef).getSource(), FirErrors.INSTANCE.getOUTER_CLASS_ARGUMENTS_REQUIRED(), (Object)outerClass, (DiagnosticContext)context2, null, 16, null);
                break;
            }
        }
        List<FirTypeRefSource> list = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
        if (list == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list;
        for (FirTypeRefSource firTypeRefSource : typeRefAndSourcesForArguments) {
            FirTypeRef it;
            if (firTypeRefSource.getTypeRef() == null) continue;
            boolean bl = false;
            INSTANCE.checkOuterClassArgumentsRequired(it, declaration2, context2, reporter);
        }
    }
}

