/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedPsiElementImplUtil {
    private static final Logger LOG = Logger.getInstance(SharedPsiElementImplUtil.class);

    private SharedPsiElementImplUtil() {
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset, @Nullable Language lang) {
        PsiElement element2;
        if (thisElement == null) {
            return null;
        }
        PsiElement psiElement = element2 = lang != null ? thisElement.getContainingFile().getViewProvider().findElementAt(offset, lang) : thisElement.findElementAt(offset);
        if (element2 == null || element2 instanceof OuterLanguageElement) {
            return null;
        }
        offset = thisElement.getTextRange().getStartOffset() + offset - element2.getTextRange().getStartOffset();
        ArrayList referencesList = new ArrayList();
        while (element2 != null) {
            SharedPsiElementImplUtil.addReferences(offset, element2, referencesList);
            if (element2 instanceof PsiFile || element2 instanceof HintedReferenceHost && !((HintedReferenceHost)element2).shouldAskParentForReferences(new PsiReferenceService.Hints(null, offset))) break;
            offset = element2.getStartOffsetInParent() + offset;
            element2 = element2.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(PsiReference.EMPTY_ARRAY), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(thisElement, offset, null);
    }

    private static void addReferences(int offset, PsiElement element2, Collection<? super PsiReference> outReferences) {
        PsiReference[] references = element2 instanceof HintedReferenceHost ? ((HintedReferenceHost)element2).getReferences(new PsiReferenceService.Hints(null, offset)) : element2.getReferences();
        for (PsiReference reference2 : references) {
            if (reference2 == null) {
                LOG.error("Null reference returned from " + element2 + " of " + element2.getClass());
                continue;
            }
            for (TextRange range : ReferenceRange.getRanges(reference2)) {
                LOG.assertTrue(range != null, reference2);
                if (!range.containsOffset(offset)) continue;
                outReferences.add(reference2);
            }
        }
    }

    public static PsiReference @NotNull [] getReferences(PsiElement thisElement) {
        PsiReference[] psiReferenceArray;
        PsiReference ref = thisElement.getReference();
        if (ref != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = ref;
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            SharedPsiElementImplUtil.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiElement getNextSibling(PsiElement element2) {
        if (element2 instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element2).getViewProvider();
            element2 = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element2 == null) {
            return null;
        }
        PsiElement parent2 = element2.getParent();
        if (parent2 == null) {
            return null;
        }
        PsiElement[] children2 = parent2.getChildren();
        int index = SharedPsiElementImplUtil.getChildIndex(children2, element2);
        return 0 <= index && index < children2.length - 1 ? children2[index + 1] : null;
    }

    @Nullable
    public static PsiElement getPrevSibling(PsiElement element2) {
        if (element2 instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element2).getViewProvider();
            element2 = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element2 == null) {
            return null;
        }
        PsiElement parent2 = element2.getParent();
        if (parent2 == null) {
            return null;
        }
        PsiElement[] children2 = parent2.getChildren();
        int index = SharedPsiElementImplUtil.getChildIndex(children2, element2);
        return index > 0 ? children2[index - 1] : null;
    }

    private static int getChildIndex(PsiElement[] children2, PsiElement child) {
        int i = ArrayUtil.indexOfIdentity(children2, child);
        if (i != -1) {
            return i;
        }
        LOG.error("Cannot find element among its parent' children. element: '" + child + "'; parent: '" + child.getParent() + "'; children: " + Arrays.asList(children2) + ";  file:" + child.getContainingFile());
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/SharedPsiElementImplUtil", "getReferences"));
    }
}

