/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlagsKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDataClassConsistentDataCopyAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDataClassConsistentDataCopyAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,60:1\n68#2:61\n68#2:62\n18#3:63\n*S KotlinDebug\n*F\n+ 1 FirDataClassConsistentDataCopyAnnotationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDataClassConsistentDataCopyAnnotationChecker\n*L\n26#1:61\n29#1:62\n47#1:63\n*E\n"})
public final class FirDataClassConsistentDataCopyAnnotationChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirDataClassConsistentDataCopyAnnotationChecker INSTANCE = new FirDataClassConsistentDataCopyAnnotationChecker();

    private FirDataClassConsistentDataCopyAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block8: {
            FirAnnotation consistentCopy;
            block11: {
                Visibility visibility;
                FirAnnotation exposedCopy;
                block9: {
                    block10: {
                        boolean $i$f$isData;
                        FirRegularClass $this$isData$iv;
                        block6: {
                            block7: {
                                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                                consistentCopy = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), context2.getSession());
                                exposedCopy = FirAnnotationUtilsKt.getAnnotationByClassId(declaration2, StandardClassIds.Annotations.INSTANCE.getExposedCopyVisibility(), context2.getSession());
                                if (consistentCopy == null) break block6;
                                if (!(declaration2 instanceof FirRegularClass)) break block7;
                                $this$isData$iv = (FirRegularClass)declaration2;
                                $i$f$isData = false;
                                if ($this$isData$iv.getStatus().isData()) break block6;
                            }
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), (DiagnosticContext)context2, null, 8, null);
                            break block8;
                        }
                        if (exposedCopy == null) break block9;
                        if (!(declaration2 instanceof FirRegularClass)) break block10;
                        $this$isData$iv = (FirRegularClass)declaration2;
                        $i$f$isData = false;
                        if ($this$isData$iv.getStatus().isData()) break block9;
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_WRONG_ANNOTATION_TARGET(), (DiagnosticContext)context2, null, 8, null);
                    break block8;
                }
                if (consistentCopy != null && exposedCopy != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)exposedCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), (DiagnosticContext)context2, null, 8, null);
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getDATA_CLASS_CONSISTENT_COPY_AND_EXPOSED_COPY_ARE_INCOMPATIBLE_ANNOTATIONS(), (DiagnosticContext)context2, null, 8, null);
                }
                if (consistentCopy == null) break block8;
                if (AnalysisFlagsKt.doesDataClassCopyRespectConstructorVisibility(context2.getLanguageVersionSettings())) break block11;
                FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(declaration2, context2.getSession());
                if (firConstructorSymbol != null) {
                    FirCallableSymbol $this$visibility$iv = firConstructorSymbol;
                    boolean $i$f$getVisibility = false;
                    visibility = $this$visibility$iv.getResolvedStatus().getVisibility();
                } else {
                    visibility = null;
                }
                if (!Intrinsics.areEqual(visibility, (Object)Visibilities.Public.INSTANCE)) break block8;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)consistentCopy.getSource(), FirErrors.INSTANCE.getREDUNDANT_ANNOTATION(), (Object)StandardClassIds.Annotations.INSTANCE.getConsistentCopyVisibility(), (DiagnosticContext)context2, null, 16, null);
        }
    }
}

