/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isKClassWithBadArgument", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "frontend"})
@SourceDebugExtension(value={"SMAP\nKClassWithIncorrectTypeArgumentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KClassWithIncorrectTypeArgumentChecker.kt\norg/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1#2:68\n*E\n"})
public final class KClassWithIncorrectTypeArgumentChecker
implements DeclarationChecker {
    @NotNull
    public static final KClassWithIncorrectTypeArgumentChecker INSTANCE = new KClassWithIncorrectTypeArgumentChecker();

    private KClassWithIncorrectTypeArgumentChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor instanceof CallableMemberDescriptor) || Intrinsics.areEqual((Object)((CallableMemberDescriptor)descriptor).getVisibility(), (Object)DescriptorVisibilities.LOCAL)) {
            return;
        }
        if (!(declaration2 instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration2).getTypeReference() != null) {
            return;
        }
        if (descriptor instanceof PropertyAccessorDescriptor) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        Ref.ObjectRef typeParameterWithoutNotNullableUpperBound = new Ref.ObjectRef();
        TypeUtilsKt.contains(returnType2, (Function1<? super UnwrappedType, Boolean>)((Function1)arg_0 -> KClassWithIncorrectTypeArgumentChecker.check$lambda$1(descriptor, typeParameterWithoutNotNullableUpperBound, arg_0)));
        if (typeParameterWithoutNotNullableUpperBound.element != null) {
            BindingTrace bindingTrace = context2.getTrace();
            PsiElement psiElement = declaration2;
            Object object = typeParameterWithoutNotNullableUpperBound.element;
            Intrinsics.checkNotNull((Object)object);
            bindingTrace.report(Errors.KCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE.on((KtNamedDeclaration)psiElement, (TypeParameterDescriptor)object));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassWithBadArgument(UnwrappedType $this$isKClassWithBadArgument) {
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull($this$isKClassWithBadArgument.getArguments());
        Object object = typeProjection;
        if (typeProjection == null) return false;
        TypeProjection it = object;
        boolean bl = false;
        if (it.isStarProjection()) {
            return false;
        }
        UnwrappedType unwrappedType = it.getType().unwrap();
        object = unwrappedType;
        if (unwrappedType == null) {
            return false;
        }
        Object argumentType = object;
        ClassifierDescriptor classifierDescriptor = $this$isKClassWithBadArgument.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) return false;
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor klass = classDescriptor;
        if (!KotlinBuiltIns.isKClass(klass)) return false;
        KotlinType kotlinType = (KotlinType)argumentType;
        SimpleType simpleType = TypeUtilsKt.getBuiltIns((KotlinType)argumentType).getAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getAnyType(...)");
        if (TypeUtilsKt.isSubtypeOf(kotlinType, simpleType)) return false;
        return true;
    }

    private static final boolean check$lambda$1(DeclarationDescriptor $descriptor, Ref.ObjectRef $typeParameterWithoutNotNullableUpperBound, UnwrappedType type2) {
        boolean kClassWithBadArgument;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
            Intrinsics.checkNotNullParameter((Object)$typeParameterWithoutNotNullableUpperBound, (String)"$typeParameterWithoutNotNullableUpperBound");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            kClassWithBadArgument = INSTANCE.isKClassWithBadArgument(type2);
            if (!kClassWithBadArgument) break block2;
            Object object = (TypeProjection)CollectionsKt.singleOrNull(type2.getArguments());
            if (object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null && (object = object.getDeclarationDescriptor()) != null) {
                Object it = object;
                boolean bl = false;
                if (it instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)((TypeParameterDescriptor)it).getContainingDeclaration(), (Object)$descriptor)) {
                    $typeParameterWithoutNotNullableUpperBound.element = it;
                }
            }
        }
        return kClassWithBadArgument;
    }
}

