/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"isInvoke", "", "Lorg/jetbrains/kotlin/name/CallableId;", "isFunctionOrSuspendFunctionInvoke", "isSuspendFunctionInvoke", "isFunctionInvoke", "isKFunctionInvoke", "isIteratorNext", "isIteratorHasNext", "isIterator", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "semantics"})
@SourceDebugExtension(value={"SMAP\nCallableIdUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallableIdUtils.kt\norg/jetbrains/kotlin/fir/resolve/CallableIdUtilsKt\n+ 2 FirSymbolProvider.kt\norg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProviderKt\n+ 3 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,54:1\n83#2:55\n84#2,2:57\n26#3:56\n*S KotlinDebug\n*F\n+ 1 CallableIdUtils.kt\norg/jetbrains/kotlin/fir/resolve/CallableIdUtilsKt\n*L\n51#1:55\n51#1:57,2\n51#1:56\n*E\n"})
public final class CallableIdUtilsKt {
    public static final boolean isInvoke(@NotNull CallableId $this$isInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isInvoke, (String)"<this>");
        return CallableIdUtilsKt.isFunctionInvoke($this$isInvoke) || CallableIdUtilsKt.isKFunctionInvoke($this$isInvoke);
    }

    public static final boolean isFunctionOrSuspendFunctionInvoke(@NotNull CallableId $this$isFunctionOrSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionOrSuspendFunctionInvoke, (String)"<this>");
        return CallableIdUtilsKt.isFunctionInvoke($this$isFunctionOrSuspendFunctionInvoke) || CallableIdUtilsKt.isSuspendFunctionInvoke($this$isFunctionOrSuspendFunctionInvoke);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuspendFunctionInvoke(@NotNull CallableId $this$isSuspendFunctionInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isSuspendFunctionInvoke.getCallableName().asString(), (Object)"invoke")) return false;
        FqName fqName = $this$isSuspendFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, (String)"SuspendFunction", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isSuspendFunctionInvoke.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_COROUTINES_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFunctionInvoke(@NotNull CallableId $this$isFunctionInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isFunctionInvoke.getCallableName().asString(), (Object)"invoke")) return false;
        FqName fqName = $this$isFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, (String)"Function", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isFunctionInvoke.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKFunctionInvoke(@NotNull CallableId $this$isKFunctionInvoke) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunctionInvoke, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isKFunctionInvoke.getCallableName().asString(), (Object)"invoke")) return false;
        FqName fqName = $this$isKFunctionInvoke.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.startsWith$default((String)object, (String)"KFunction", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isKFunctionInvoke.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorNext(@NotNull CallableId $this$isIteratorNext) {
        Intrinsics.checkNotNullParameter((Object)$this$isIteratorNext, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isIteratorNext.getCallableName().asString(), (Object)"next")) return false;
        FqName fqName = $this$isIteratorNext.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, (String)"Iterator", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isIteratorNext.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIteratorHasNext(@NotNull CallableId $this$isIteratorHasNext) {
        Intrinsics.checkNotNullParameter((Object)$this$isIteratorHasNext, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isIteratorHasNext.getCallableName().asString(), (Object)"hasNext")) return false;
        FqName fqName = $this$isIteratorHasNext.getClassName();
        Object object = fqName;
        if (fqName == null) return false;
        String string2 = ((FqName)object).asString();
        object = string2;
        if (string2 == null) return false;
        if (!StringsKt.endsWith$default((String)object, (String)"Iterator", (boolean)false, (int)2, null)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual((Object)$this$isIteratorHasNext.getPackageName(), (Object)StandardClassIds.INSTANCE.getBASE_COLLECTIONS_PACKAGE())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIterator(@NotNull CallableId $this$isIterator) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterator, (String)"<this>");
        if (!Intrinsics.areEqual((Object)$this$isIterator.getCallableName().asString(), (Object)"iterator")) return false;
        Object[] objectArray = new String[]{"kotlin", "kotlin.collections", "kotlin.ranges"};
        if (!ArraysKt.contains((Object[])objectArray, (Object)$this$isIterator.getPackageName().asString())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final FqName fqName(@NotNull FirAnnotation $this$fqName, @NotNull FirSession session) {
        FirBasedSymbol firBasedSymbol;
        void $this$getSymbolByTypeRef$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fqName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirSymbolProvider firSymbolProvider = FirSymbolProviderKt.getSymbolProvider(session);
        FirTypeRef typeRef$iv = $this$fqName.getAnnotationTypeRef();
        boolean $i$f$getSymbolByTypeRef = false;
        FirTypeRef $this$coneTypeSafe$iv$iv = typeRef$iv;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeSimpleKotlinType)) {
            coneKotlinType = null;
        }
        ConeSimpleKotlinType coneSimpleKotlinType = (ConeSimpleKotlinType)((ConeKotlinType)((ConeSimpleKotlinType)coneKotlinType));
        ConeSimpleKotlinType coneSimpleKotlinType2 = coneSimpleKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType(coneSimpleKotlinType, $this$getSymbolByTypeRef$iv.getSession()) : null;
        Object object = coneSimpleKotlinType2 instanceof ConeLookupTagBasedType ? (ConeLookupTagBasedType)coneSimpleKotlinType2 : null;
        if (object == null || (object = ((ConeLookupTagBasedType)object).getLookupTag()) == null) {
            firBasedSymbol = null;
        } else {
            Object lookupTag$iv = object;
            FirClassifierSymbol<?> firClassifierSymbol = LookupTagUtilsKt.getSymbolByLookupTag((FirSymbolProvider)$this$getSymbolByTypeRef$iv, (ConeClassifierLookupTag)lookupTag$iv);
            if (!(firClassifierSymbol instanceof FirRegularClassSymbol)) {
                firClassifierSymbol = null;
            }
            firBasedSymbol = (FirRegularClassSymbol)firClassifierSymbol;
        }
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)firBasedSymbol;
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol symbol = firRegularClassSymbol;
        return symbol.getClassId().asSingleFqName();
    }
}

