/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PropertyInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PropertyInitializationInfoData;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "ignoreWarnings", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getIgnoreWarnings", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "Data", "AddAllWrites", "FindVisibleWrites", "RemoveVisibleWrites", "checkers"})
public final class UnusedChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final UnusedChecker INSTANCE = new UnusedChecker();

    private UnusedChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void analyze(@NotNull PropertyInitializationInfoData data, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Data ownData = new Data(data.getProperties());
        data.getGraph().traverse(new AddAllWrites(), ownData);
        if (!((Collection)ownData.getUnreadWrites()).isEmpty()) {
            ownData.setWritesByNode(CfgTraverserKt.traverseToFixedPoint(data.getGraph(), new FindVisibleWrites(data.getProperties())));
        }
        data.getGraph().traverse(new RemoveVisibleWrites(), ownData);
        Set variablesWithUnobservedWrites = new LinkedHashSet();
        for (FirStatement entry : ownData.getUnreadWrites()) {
            if (entry instanceof FirVariableAssignment) {
                Object object = ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)entry);
                if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) continue;
                Object variableSymbol = object;
                variablesWithUnobservedWrites.add(variableSymbol);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirVariableAssignment)entry).getLValue().getSource(), FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!(entry instanceof FirProperty) || ownData.getVariablesWithoutReads().containsKey(((FirProperty)entry).getSymbol()) || this.getIgnoreWarnings(((FirProperty)entry).getSymbol())) continue;
            FirExpression firExpression = ((FirProperty)entry).getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), (DiagnosticContext)context2, null, 8, null);
        }
        for (Map.Entry entry : ownData.getVariablesWithoutReads().entrySet()) {
            FirPropertySymbol symbol = (FirPropertySymbol)entry.getKey();
            FirProperty fir = (FirProperty)entry.getValue();
            if (this.getIgnoreWarnings(symbol)) continue;
            FirExpression firExpression = fir.getInitializer();
            FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
            if ((firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) || Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter(fir), (Object)true)) continue;
            KtDiagnosticFactory0 error = variablesWithUnobservedWrites.contains(symbol) ? FirErrors.INSTANCE.getVARIABLE_NEVER_READ() : FirErrors.INSTANCE.getUNUSED_VARIABLE();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)fir.getSource(), error, (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getIgnoreWarnings(FirPropertySymbol $this$ignoreWarnings) {
        if (Intrinsics.areEqual((Object)$this$ignoreWarnings.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) return true;
        if ($this$ignoreWarnings.getSource() == null) return true;
        KtSourceElement ktSourceElement = $this$ignoreWarnings.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) return true;
        KtSourceElement ktSourceElement2 = $this$ignoreWarnings.getInitializerSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) return false;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$AddAllWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$Data;", "<init>", "()V", "visitNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "data", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    private static final class AddAllWrites
    extends ControlFlowGraphVisitor<Unit, Data> {
        @Override
        public void visitNode(@NotNull CFGNode<?> node, @NotNull Data data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (node.getFir().getInitializer() != null) {
                data.getUnreadWrites().add(node.getFir());
            }
            data.getVariablesWithoutReads().put(node.getFir().getSymbol(), node.getFir());
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(node.getFir());
            if (CollectionsKt.contains((Iterable)data.getLocalProperties(), firReference != null ? FirReferenceUtilsKt.toResolvedPropertySymbol$default(firReference, false, 1, null) : null)) {
                data.getUnreadWrites().add(node.getFir());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bRr\u0010\t\u001aZ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012L\u0012J\u0012\u0004\u0012\u00020\u000e\u0012<\u0012:\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011j\u0002`\u00100\rj\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0011j\u0002`\u0010`\u000f0\rj\u0002`\f0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\bR\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$Data;", "", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Set;)V", "getLocalProperties", "()Ljava/util/Set;", "writesByNode", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PathAwareVariableWriteInfo;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/VariableWrites;", "Lkotlinx/collections/immutable/PersistentSet;", "getWritesByNode", "()Ljava/util/Map;", "setWritesByNode", "(Ljava/util/Map;)V", "unreadWrites", "", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getUnreadWrites", "variablesWithoutReads", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getVariablesWithoutReads", "checkers"})
    private static final class Data {
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>>> writesByNode;
        @NotNull
        private final Set<FirStatement> unreadWrites;
        @NotNull
        private final Map<FirPropertySymbol, FirProperty> variablesWithoutReads;

        public Data(@NotNull Set<? extends FirPropertySymbol> localProperties) {
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            this.localProperties = localProperties;
            this.writesByNode = MapsKt.emptyMap();
            this.unreadWrites = new LinkedHashSet();
            this.variablesWithoutReads = new LinkedHashMap();
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final Map<CFGNode<?>, PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>>> getWritesByNode() {
            return this.writesByNode;
        }

        public final void setWritesByNode(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.writesByNode = map;
        }

        @NotNull
        public final Set<FirStatement> getUnreadWrites() {
            return this.unreadWrites;
        }

        @NotNull
        public final Map<FirPropertySymbol, FirProperty> getVariablesWithoutReads() {
            return this.variablesWithoutReads;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\u0001B\u0015\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0083\u0001\u0010\n\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u0002`\u000b2$\u0010\r\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u0002`\u000b2$\u0010\u000e\u001a \u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u0002`\u000b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a2\u0006\u0002\u0010\u0010J\u00bf\u0001\u0010\u0011\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003`\u00140\fj\u0002`\u0012*J\u0012\u0004\u0012\u00020\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003`\u00140\fj\u0002`\u00122\u0006\u0010\u0015\u001a\u00020\u00022\u0014\u0010\u0016\u001a\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003H\u0002\u00a2\u0006\u0002\u0010\u0017J\u00ad\u0001\u0010\u0018\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003`\u00140\fj\u0002`\u00122\u0006\u0010\u000f\u001a\u00020\u00192N\u0010\u0016\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003`\u00140\fj\u0002`\u0012H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u00ad\u0001\u0010\u001b\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003`\u00140\fj\u0002`\u00122\u0006\u0010\u000f\u001a\u00020\u001c2N\u0010\u0016\u001aJ\u0012\u0004\u0012\u00020\u0013\u0012<\u0012:\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u00030\fj\u001c\u0012\u0004\u0012\u00020\u0002\u0012\u0012\u0012\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\u0002`\u0003`\u00140\fj\u0002`\u0012H\u0016\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$FindVisibleWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/VariableWrites;", "Lkotlinx/collections/immutable/PersistentSet;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "properties", "", "<init>", "(Ljava/util/Set;)V", "mergeInfo", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/VariableWriteInfo;", "Lkotlinx/collections/immutable/PersistentMap;", "a", "b", "node", "(Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;)Lkotlinx/collections/immutable/PersistentMap;", "overwrite", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/PathAwareVariableWriteInfo;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "symbol", "data", "(Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;Lkotlinx/collections/immutable/PersistentSet;)Lkotlinx/collections/immutable/PersistentMap;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;Lkotlinx/collections/immutable/PersistentMap;)Lkotlinx/collections/immutable/PersistentMap;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;Lkotlinx/collections/immutable/PersistentMap;)Lkotlinx/collections/immutable/PersistentMap;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$FindVisibleWrites\n+ 2 PathAwareControlFlowGraphVisitor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitorKt\n+ 3 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n82#2:161\n83#2:163\n84#2:167\n86#2:170\n89#2:171\n53#3:162\n53#3:172\n412#4:164\n412#4:173\n1246#5,2:165\n1249#5:169\n1246#5,4:174\n1#6:168\n1#6:178\n*S KotlinDebug\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$FindVisibleWrites\n*L\n95#1:161\n95#1:163\n95#1:167\n95#1:170\n98#1:171\n95#1:162\n98#1:172\n95#1:164\n98#1:173\n95#1:165,2\n95#1:169\n98#1:174,4\n95#1:168\n*E\n"})
    private static final class FindVisibleWrites
    extends PathAwareControlFlowGraphVisitor<FirPropertySymbol, PersistentSet<? extends CFGNode<?>>> {
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindVisibleWrites(@NotNull Set<? extends FirPropertySymbol> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> mergeInfo(@NotNull PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> a, @NotNull PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>> b, @NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> $this$merge$iv = a;
            boolean $i$f$merge = false;
            PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>> $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder<FirPropertySymbol, PersistentSet<CFGNode<?>>> builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl = false;
            Map $this$mapValuesTo$iv$iv = b;
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                Map map;
                Object k;
                block4: {
                    Object rightValue$iv;
                    block3: {
                        void p1;
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map2 = it$iv;
                        boolean bl2 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        k = it$iv$iv.getKey();
                        map = map2;
                        boolean bl3 = false;
                        Object label$iv = entry2.getKey();
                        rightValue$iv = entry2.getValue();
                        object = $this$merge$iv.get(label$iv);
                        if (object == null) break block3;
                        Object leftValue$iv = object;
                        boolean bl4 = false;
                        Collection collection = (Collection)rightValue$iv;
                        PersistentSet p0 = (PersistentSet)leftValue$iv;
                        boolean bl5 = false;
                        PersistentSet persistentSet = p0.addAll(p1);
                        object = persistentSet;
                        if (persistentSet != null) break block4;
                    }
                    object = rightValue$iv;
                }
                Object v = object;
                map.put(k, v);
            }
            return builder2.build();
        }

        /*
         * WARNING - void declaration
         */
        private final PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> overwrite(PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> $this$overwrite, FirPropertySymbol symbol, PersistentSet<? extends CFGNode<?>> data) {
            PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> $this$transformValues$iv = $this$overwrite;
            boolean $i$f$transformValues = false;
            PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> $this$mutate$iv$iv = $this$transformValues$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = builder2;
            boolean bl = false;
            Map $this$mapValuesTo$iv$iv = $this$transformValues$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map = it$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl3 = false;
                Object values$iv = entry2.getValue();
                PersistentMap it = (PersistentMap)values$iv;
                boolean bl4 = false;
                PersistentMap<FirPropertySymbol, PersistentSet<? extends CFGNode<?>>> persistentMap = it.put(symbol, data);
                map2.put(k, persistentMap);
            }
            return builder2.build();
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> visitVariableDeclarationNode(@NotNull VariableDeclarationNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> data) {
            PersistentSet<Object> persistentSet;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirPropertySymbol firPropertySymbol = node.getFir().getSymbol();
            if (node.getFir().getInitializer() != null) {
                VariableDeclarationNode[] variableDeclarationNodeArray = new VariableDeclarationNode[]{node};
                persistentSet = ExtensionsKt.persistentSetOf(variableDeclarationNodeArray);
            } else {
                persistentSet = ExtensionsKt.persistentSetOf();
            }
            return this.overwrite(data, firPropertySymbol, persistentSet);
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<FirPropertySymbol, ? extends PersistentSet<? extends CFGNode<?>>>> data) {
            Object object;
            block3: {
                block2: {
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block2;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block3;
                }
                return data;
            }
            Object symbol = object;
            VariableAssignmentNode[] variableAssignmentNodeArray = new VariableAssignmentNode[]{node};
            return this.overwrite(data, (FirPropertySymbol)symbol, ExtensionsKt.persistentSetOf(variableAssignmentNodeArray));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001c\u0010\u000e\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u0003H\u0002J$\u0010\u000f\u001a\u00020\u00022\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$RemoveVisibleWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$Data;", "<init>", "()V", "visitNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "data", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitFunctionCallNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallNode;", "visitAnnotations", "visitQualifiedAccess", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$RemoveVisibleWrites\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1#2:161\n1863#3,2:162\n1863#3:164\n1863#3,2:165\n1864#3:167\n*S KotlinDebug\n*F\n+ 1 UnusedChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/UnusedChecker$RemoveVisibleWrites\n*L\n135#1:162,2\n150#1:164\n151#1:165,2\n150#1:167\n*E\n"})
    private static final class RemoveVisibleWrites
    extends ControlFlowGraphVisitor<Unit, Data> {
        @Override
        public void visitNode(@NotNull CFGNode<?> node, @NotNull Data data) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitAnnotations(node, data);
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.visitAnnotations(node, data);
            this.visitQualifiedAccess(node, node.getFir(), data);
        }

        @Override
        public void visitFunctionCallNode(@NotNull FunctionCallNode node, @NotNull Data data) {
            block0: {
                FirQualifiedAccessExpression firQualifiedAccessExpression;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.visitAnnotations(node, data);
                FirFunctionCall firFunctionCall = node.getFir();
                FirImplicitInvokeCall firImplicitInvokeCall = firFunctionCall instanceof FirImplicitInvokeCall ? (FirImplicitInvokeCall)firFunctionCall : null;
                FirExpression firExpression = firImplicitInvokeCall != null ? firImplicitInvokeCall.getExplicitReceiver() : null;
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
                if (firQualifiedAccessExpression == null) break block0;
                FirQualifiedAccessExpression it = firQualifiedAccessExpression;
                boolean bl = false;
                this.visitQualifiedAccess(node, it, data);
            }
        }

        private final void visitAnnotations(CFGNode<?> node, Data data) {
            block1: {
                Object obj = node.getFir();
                Object object = obj instanceof FirAnnotationContainer ? (FirAnnotationContainer)obj : null;
                if (object == null || (object = object.getAnnotations()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAnnotation call2 = (FirAnnotation)element$iv;
                    boolean bl = false;
                    call2.accept(new FirVisitorVoid(this, node, data){
                        final /* synthetic */ RemoveVisibleWrites this$0;
                        final /* synthetic */ CFGNode<?> $node;
                        final /* synthetic */ Data $data;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                            this.$data = $data;
                        }

                        public void visitElement(FirElement element2) {
                            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                            if (element2 instanceof FirQualifiedAccessExpression) {
                                RemoveVisibleWrites.access$visitQualifiedAccess(this.this$0, this.$node, (FirQualifiedAccessExpression)element2, this.$data);
                            }
                            element2.acceptChildren(this);
                        }
                    });
                }
            }
        }

        private final void visitQualifiedAccess(CFGNode<?> node, FirQualifiedAccessExpression fir, Data data) {
            block3: {
                FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(fir.getCalleeReference(), false, 1, null);
                if (firPropertySymbol == null) {
                    return;
                }
                FirPropertySymbol symbol = firPropertySymbol;
                data.getVariablesWithoutReads().remove(symbol);
                PersistentMap<EdgeLabel, PersistentMap<FirPropertySymbol, PersistentSet<CFGNode<?>>>> persistentMap = data.getWritesByNode().get(node);
                if (persistentMap == null || (persistentMap = (ImmutableCollection)persistentMap.values()) == null) break block3;
                Iterable $this$forEach$iv = (Iterable)((Object)persistentMap);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PersistentMap dataForLabel = (PersistentMap)element$iv;
                    boolean bl = false;
                    PersistentSet persistentSet = (PersistentSet)dataForLabel.get(symbol);
                    if (persistentSet == null) continue;
                    Iterable $this$forEach$iv2 = persistentSet;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CFGNode it = (CFGNode)element$iv2;
                        boolean bl2 = false;
                        Collection collection = data.getUnreadWrites();
                        Object e = it.getFir();
                        TypeIntrinsics.asMutableCollection((Object)collection).remove(e);
                    }
                }
            }
        }

        public static final /* synthetic */ void access$visitQualifiedAccess(RemoveVisibleWrites $this, CFGNode node, FirQualifiedAccessExpression fir, Data data) {
            $this.visitQualifiedAccess(node, fir, data);
        }
    }
}

