/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.actualizer.ClassActualizationInfo;
import org.jetbrains.kotlin.backend.common.actualizer.ExpectActualCollectorKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.IrExpectActualMatchingContext;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualChecker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualMatcher;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCheckingCompatibility;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector;", "", "<init>", "()V", "collectAndCheckMapping", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "data", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "ExpectActualLinkCollectorVisitor", "MatchingContext", "ir.actualization"})
final class ExpectActualLinkCollector {
    public final void collectAndCheckMapping(@NotNull IrModuleFragment declaration2, @NotNull MatchingContext data) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ExpectActualLinkCollectorVisitor.INSTANCE.visitModuleFragment(declaration2, (Object)data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016J \u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016J&\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$ExpectActualLinkCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "<init>", "()V", "visitFile", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "data", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "matchExpectCallable", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "context", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "matchAndCheckExpectDeclaration", "expectSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "actualSymbols", "", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.actualization"})
    private static final class ExpectActualLinkCollectorVisitor
    implements IrElementVisitor<Unit, MatchingContext> {
        @NotNull
        public static final ExpectActualLinkCollectorVisitor INSTANCE = new ExpectActualLinkCollectorVisitor();

        private ExpectActualLinkCollectorVisitor() {
        }

        @Override
        public void visitFile(@NotNull IrFile declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            IrElementVisitor.DefaultImpls.visitFile(this, declaration2, data.withNewCurrentFile(declaration2));
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration2.isExpect()) {
                this.matchExpectCallable(declaration2, AdditionalIrUtilsKt.getCallableId(declaration2), data);
            }
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (declaration2.isExpect()) {
                this.matchExpectCallable(declaration2, AdditionalIrUtilsKt.getCallableId(declaration2), data);
            }
        }

        private final void matchExpectCallable(IrDeclarationWithName declaration2, CallableId callableId, MatchingContext context2) {
            IrSymbol irSymbol2 = declaration2.getSymbol();
            List list = context2.getClassActualizationInfo$ir_actualization().getActualTopLevels().get(callableId);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            this.matchAndCheckExpectDeclaration(irSymbol2, list, context2);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!declaration2.isExpect()) {
                return;
            }
            ClassId classId = AdditionalIrUtilsKt.getClassIdOrFail(declaration2);
            IrClassSymbol expectClassSymbol = declaration2.getSymbol();
            IrSymbol actualClassLikeSymbol = data.getClassActualizationInfo$ir_actualization().getActualWithoutExpansion(classId);
            this.matchAndCheckExpectDeclaration(expectClassSymbol, CollectionsKt.listOfNotNull((Object)actualClassLikeSymbol), data);
        }

        private final void matchAndCheckExpectDeclaration(IrSymbol expectSymbol, List<? extends IrSymbol> actualSymbols, MatchingContext context2) {
            DeclarationSymbolMarker matched = AbstractExpectActualMatcher.INSTANCE.matchSingleExpectTopLevelDeclarationAgainstPotentialActuals(expectSymbol, actualSymbols, context2);
            if (matched != null) {
                AbstractExpectActualChecker.INSTANCE.checkSingleExpectTopLevelDeclarationAgainstMatchedActual(expectSymbol, matched, context2, context2.getLanguageVersionSettings$ir_actualization());
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element2, @NotNull MatchingContext data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            element2.acceptChildren(this, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConstructor(this, declaration2, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitField(this, declaration2, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration2, data);
        }

        @Override
        public void visitScript(@NotNull IrScript declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitScript(this, declaration2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration2, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration2, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitVariable(this, declaration2, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitReturnableBlock(this, expression2, data);
        }

        @Override
        public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitConst(@NotNull IrConst<?> expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstantValue(@NotNull IrConstantValue expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data);
        }

        @Override
        public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data);
        }

        @Override
        public void visitConstantObject(@NotNull IrConstantObject expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data);
        }

        @Override
        public void visitConstantArray(@NotNull IrConstantArray expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
        }

        @Override
        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitLoop(this, loop, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitSetValue(@NotNull IrSetValue expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull MatchingContext data) {
            IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u000bJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u000eH\u0016JB\u0010)\u001a\u00020\"2\u0006\u0010'\u001a\u00020*2\u001c\u0010+\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0.0,2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000100H\u0016J>\u00102\u001a\u00020\"2\u0006\u0010'\u001a\u00020*2\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0.0,2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000100H\u0016J\u0014\u00104\u001a\u00020\"*\u00020\u00072\u0006\u0010(\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/ExpectActualLinkCollector$MatchingContext;", "Lorg/jetbrains/kotlin/backend/common/actualizer/IrExpectActualMatchingContext;", "typeSystemContext", "Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "expectActualTracker", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "classActualizationInfo", "Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "currentExpectFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "destination", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrTypeSystemContext;Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Ljava/util/Map;)V", "getClassActualizationInfo$ir_actualization", "()Lorg/jetbrains/kotlin/backend/common/actualizer/ClassActualizationInfo;", "getDestination", "()Ljava/util/Map;", "currentExpectIoFile", "Ljava/io/File;", "getCurrentExpectIoFile", "()Ljava/io/File;", "currentExpectIoFile$delegate", "Lkotlin/Lazy;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings$ir_actualization", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "withNewCurrentFile", "newCurrentFile", "onMatchedClasses", "", "expectClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "actualClassSymbol", "onMatchedCallables", "expectSymbol", "actualSymbol", "onIncompatibleMembersFromClassScope", "Lorg/jetbrains/kotlin/mpp/DeclarationSymbolMarker;", "actualSymbolsByIncompatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCheckingCompatibility$Incompatible;", "", "containingExpectClassSymbol", "Lorg/jetbrains/kotlin/mpp/RegularClassSymbolMarker;", "containingActualClassSymbol", "onMismatchedMembersFromClassScope", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility$Mismatch;", "reportWithCurrentFile", "ir.actualization"})
    public static final class MatchingContext
    extends IrExpectActualMatchingContext {
        @NotNull
        private final IrDiagnosticReporter diagnosticsReporter;
        @Nullable
        private final ExpectActualTracker expectActualTracker;
        @NotNull
        private final ClassActualizationInfo classActualizationInfo;
        @Nullable
        private final IrFile currentExpectFile;
        @NotNull
        private final Map<IrSymbol, IrSymbol> destination;
        @NotNull
        private final Lazy currentExpectIoFile$delegate;

        public MatchingContext(@NotNull IrTypeSystemContext typeSystemContext2, @NotNull IrDiagnosticReporter diagnosticsReporter, @Nullable ExpectActualTracker expectActualTracker, @NotNull ClassActualizationInfo classActualizationInfo, @Nullable IrFile currentExpectFile, @NotNull Map<IrSymbol, IrSymbol> destination) {
            Intrinsics.checkNotNullParameter((Object)typeSystemContext2, (String)"typeSystemContext");
            Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
            Intrinsics.checkNotNullParameter((Object)classActualizationInfo, (String)"classActualizationInfo");
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            super(typeSystemContext2, classActualizationInfo.getActualClasses());
            this.diagnosticsReporter = diagnosticsReporter;
            this.expectActualTracker = expectActualTracker;
            this.classActualizationInfo = classActualizationInfo;
            this.currentExpectFile = currentExpectFile;
            this.destination = destination;
            this.currentExpectIoFile$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> MatchingContext.currentExpectIoFile_delegate$lambda$0(this));
        }

        public /* synthetic */ MatchingContext(IrTypeSystemContext irTypeSystemContext, IrDiagnosticReporter irDiagnosticReporter, ExpectActualTracker expectActualTracker, ClassActualizationInfo classActualizationInfo, IrFile irFile, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                map = new LinkedHashMap();
            }
            this(irTypeSystemContext, irDiagnosticReporter, expectActualTracker, classActualizationInfo, irFile, map);
        }

        @NotNull
        public final ClassActualizationInfo getClassActualizationInfo$ir_actualization() {
            return this.classActualizationInfo;
        }

        @NotNull
        public final Map<IrSymbol, IrSymbol> getDestination() {
            return this.destination;
        }

        private final File getCurrentExpectIoFile() {
            Lazy lazy = this.currentExpectIoFile$delegate;
            return (File)lazy.getValue();
        }

        @NotNull
        public final LanguageVersionSettings getLanguageVersionSettings$ir_actualization() {
            return this.diagnosticsReporter.getLanguageVersionSettings();
        }

        @NotNull
        public final MatchingContext withNewCurrentFile(@NotNull IrFile newCurrentFile) {
            Intrinsics.checkNotNullParameter((Object)newCurrentFile, (String)"newCurrentFile");
            return new MatchingContext(this.getTypeContext(), this.diagnosticsReporter, this.expectActualTracker, this.classActualizationInfo, newCurrentFile, this.destination);
        }

        @Override
        public void onMatchedClasses(@NotNull IrClassSymbol expectClassSymbol, @NotNull IrClassSymbol actualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectClassSymbol, (String)"expectClassSymbol");
            Intrinsics.checkNotNullParameter((Object)actualClassSymbol, (String)"actualClassSymbol");
            this.destination.put(expectClassSymbol, actualClassSymbol);
            ExpectActualTracker expectActualTracker = this.expectActualTracker;
            if (expectActualTracker != null) {
                this.reportWithCurrentFile(expectActualTracker, actualClassSymbol);
            }
            IrActualizerUtilsKt.recordActualForExpectDeclaration(expectClassSymbol, actualClassSymbol, this.destination, this.diagnosticsReporter);
        }

        @Override
        public void onMatchedCallables(@NotNull IrSymbol expectSymbol, @NotNull IrSymbol actualSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter((Object)actualSymbol, (String)"actualSymbol");
            ExpectActualTracker expectActualTracker = this.expectActualTracker;
            if (expectActualTracker != null) {
                this.reportWithCurrentFile(expectActualTracker, actualSymbol);
            }
            IrActualizerUtilsKt.recordActualForExpectDeclaration(expectSymbol, actualSymbol, this.destination, this.diagnosticsReporter);
        }

        @Override
        public void onIncompatibleMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull Map<ExpectActualCheckingCompatibility.Incompatible<?>, ? extends List<? extends DeclarationSymbolMarker>> actualSymbolsByIncompatibility, @Nullable RegularClassSymbolMarker containingExpectClassSymbol, @Nullable RegularClassSymbolMarker containingActualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbolsByIncompatibility, (String)"actualSymbolsByIncompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            for (Map.Entry<ExpectActualCheckingCompatibility.Incompatible<?>, List<DeclarationSymbolMarker>> entry : actualSymbolsByIncompatibility.entrySet()) {
                ExpectActualCheckingCompatibility.Incompatible<?> incompatibility = entry.getKey();
                List<DeclarationSymbolMarker> actualMemberSymbols = entry.getValue();
                for (DeclarationSymbolMarker declarationSymbolMarker : actualMemberSymbols) {
                    if (!(declarationSymbolMarker instanceof IrSymbol)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    IrActualizerUtilsKt.reportExpectActualIncompatibility(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)declarationSymbolMarker, incompatibility);
                }
            }
        }

        @Override
        public void onMismatchedMembersFromClassScope(@NotNull DeclarationSymbolMarker expectSymbol, @NotNull Map<ExpectActualMatchingCompatibility.Mismatch, ? extends List<? extends DeclarationSymbolMarker>> actualSymbolsByIncompatibility, @Nullable RegularClassSymbolMarker containingExpectClassSymbol, @Nullable RegularClassSymbolMarker containingActualClassSymbol) {
            Intrinsics.checkNotNullParameter((Object)expectSymbol, (String)"expectSymbol");
            Intrinsics.checkNotNullParameter(actualSymbolsByIncompatibility, (String)"actualSymbolsByIncompatibility");
            if (!(expectSymbol instanceof IrSymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (actualSymbolsByIncompatibility.isEmpty() && !IrActualizerUtilsKt.containsOptionalExpectation(((IrSymbol)expectSymbol).getOwner())) {
                IrActualizerUtilsKt.reportMissingActual(this.diagnosticsReporter, (IrSymbol)expectSymbol);
            }
            for (Map.Entry<ExpectActualMatchingCompatibility.Mismatch, ? extends List<? extends DeclarationSymbolMarker>> entry : actualSymbolsByIncompatibility.entrySet()) {
                ExpectActualMatchingCompatibility.Mismatch incompatibility = entry.getKey();
                List<? extends DeclarationSymbolMarker> actualMemberSymbols = entry.getValue();
                for (DeclarationSymbolMarker declarationSymbolMarker : actualMemberSymbols) {
                    if (!(declarationSymbolMarker instanceof IrSymbol)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    IrActualizerUtilsKt.reportExpectActualMismatch(this.diagnosticsReporter, (IrSymbol)expectSymbol, (IrSymbol)declarationSymbolMarker, incompatibility);
                }
            }
        }

        private final void reportWithCurrentFile(ExpectActualTracker $this$reportWithCurrentFile, IrSymbol actualSymbol) {
            if (this.currentExpectFile != null) {
                File actualIoFile;
                IrFile irFile = this.classActualizationInfo.getActualSymbolsToFile().get(actualSymbol);
                File file2 = actualIoFile = irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
                if (actualIoFile != null) {
                    File file3 = this.getCurrentExpectIoFile();
                    Intrinsics.checkNotNull((Object)file3);
                    $this$reportWithCurrentFile.report(file3, actualIoFile);
                }
            }
        }

        private static final File currentExpectIoFile_delegate$lambda$0(MatchingContext this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            IrFile irFile = this$0.currentExpectFile;
            return irFile != null ? ExpectActualCollectorKt.access$toIoFile(irFile) : null;
        }
    }
}

