/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.project.structure;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.RawPluginDescriptor;
import com.intellij.ide.plugins.ReadModuleContext;
import com.intellij.mock.MockProject;
import com.intellij.openapi.components.ServiceDescriptor;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointDescriptor;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.platform.util.plugins.DataLoader;
import com.intellij.util.NoOpXmlInterner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.ZipFilePool;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.impl.MessageBusEx;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisNonPublicApi;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.utils.SmartList;

@KtAnalysisNonPublicApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0016\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0017*\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0006\u001a#\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/PluginStructureProvider;", "", "<init>", "()V", "fakePluginDescriptor", "Lcom/intellij/openapi/extensions/DefaultPluginDescriptor;", "pluginDescriptorsCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/PluginStructureProvider$PluginDesignation;", "kotlin.jvm.PlatformType", "Lcom/intellij/ide/plugins/RawPluginDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "getOrCalculatePluginDescriptor", "designation", "registerProjectExtensionPoints", "", "project", "Lcom/intellij/mock/MockProject;", "pluginRelativePath", "", "registerProjectServices", "registerProjectListeners", "registerServiceWithInterface", "T", "interfaceClass", "Ljava/lang/Class;", "implementationClass", "ReadContext", "ResourceDataLoader", "PluginDesignation", "analysis-api-standalone-base"})
public final class PluginStructureProvider {
    @NotNull
    public static final PluginStructureProvider INSTANCE = new PluginStructureProvider();
    @NotNull
    private static final DefaultPluginDescriptor fakePluginDescriptor = new DefaultPluginDescriptor("analysis-api-standalone-base-loader");
    @NotNull
    private static final ConcurrentMap<PluginDesignation, RawPluginDescriptor> pluginDescriptorsCache;

    private PluginStructureProvider() {
    }

    private final RawPluginDescriptor getOrCalculatePluginDescriptor(PluginDesignation designation) {
        RawPluginDescriptor rawPluginDescriptor = pluginDescriptorsCache.computeIfAbsent(designation, arg_0 -> PluginStructureProvider.getOrCalculatePluginDescriptor$lambda$1(arg_0 -> PluginStructureProvider.getOrCalculatePluginDescriptor$lambda$0(designation, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rawPluginDescriptor, (String)"computeIfAbsent(...)");
        return rawPluginDescriptor;
    }

    public final void registerProjectExtensionPoints(@NotNull MockProject project, @NotNull String pluginRelativePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pluginRelativePath, (String)"pluginRelativePath");
        RawPluginDescriptor pluginDescriptor = this.getOrCalculatePluginDescriptor(new PluginDesignation(pluginRelativePath, project));
        List list = pluginDescriptor.projectContainerDescriptor.extensionPoints;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (ExtensionPointDescriptor extensionPointDescriptor : list) {
            CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)project.getExtensionArea(), extensionPointDescriptor.name, project.loadClass(extensionPointDescriptor.className, fakePluginDescriptor));
        }
    }

    public final void registerProjectServices(@NotNull MockProject project, @NotNull String pluginRelativePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pluginRelativePath, (String)"pluginRelativePath");
        RawPluginDescriptor pluginDescriptor = this.getOrCalculatePluginDescriptor(new PluginDesignation(pluginRelativePath, project));
        for (ServiceDescriptor serviceDescriptor : pluginDescriptor.projectContainerDescriptor.getServices()) {
            Class serviceImplementationClass;
            Intrinsics.checkNotNullExpressionValue(project.loadClass(serviceDescriptor.serviceImplementation, fakePluginDescriptor), (String)"loadClass(...)");
            String serviceInterface = serviceDescriptor.serviceInterface;
            if (serviceInterface != null) {
                Class serviceInterfaceClass;
                Intrinsics.checkNotNullExpressionValue(project.loadClass(serviceInterface, fakePluginDescriptor), (String)"loadClass(...)");
                this.registerServiceWithInterface(project, serviceInterfaceClass, serviceImplementationClass);
                continue;
            }
            project.registerService(serviceImplementationClass);
        }
    }

    public final void registerProjectListeners(@NotNull MockProject project, @NotNull String pluginRelativePath) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pluginRelativePath, (String)"pluginRelativePath");
        RawPluginDescriptor pluginDescriptor = this.getOrCalculatePluginDescriptor(new PluginDesignation(pluginRelativePath, project));
        List list = pluginDescriptor.projectContainerDescriptor.listeners;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((collection = (Collection)list).isEmpty()) {
            boolean bl = false;
            return;
        }
        List listenerDescriptors = (List)collection;
        Map listenersMap = new LinkedHashMap();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            listenerDescriptor.pluginDescriptor = fakePluginDescriptor;
            listenersMap.computeIfAbsent(listenerDescriptor.topicClassName, arg_0 -> PluginStructureProvider.registerProjectListeners$lambda$4(PluginStructureProvider::registerProjectListeners$lambda$3, arg_0)).add(listenerDescriptor);
        }
        MessageBus messageBus = KotlinMessageBusProviderKt.getAnalysisMessageBus(project);
        Intrinsics.checkNotNull((Object)messageBus, (String)"null cannot be cast to non-null type com.intellij.util.messages.impl.MessageBusEx");
        ((MessageBusEx)messageBus).setLazyListeners(listenersMap);
    }

    private final <T> void registerServiceWithInterface(MockProject $this$registerServiceWithInterface, Class<T> interfaceClass, Class<T> implementationClass) {
        $this$registerServiceWithInterface.registerService(interfaceClass, implementationClass);
    }

    private static final RawPluginDescriptor getOrCalculatePluginDescriptor$lambda$0(PluginDesignation $designation, PluginDesignation it) {
        Intrinsics.checkNotNullParameter((Object)$designation, (String)"$designation");
        RawPluginDescriptor descriptor = new RawPluginDescriptor();
        PluginXmlPathResolver.DEFAULT_PATH_RESOLVER.resolvePath(ReadContext.INSTANCE, new ResourceDataLoader($designation.getClassLoader()), $designation.getRelativePath(), descriptor);
        return descriptor;
    }

    private static final RawPluginDescriptor getOrCalculatePluginDescriptor$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RawPluginDescriptor)$tmp0.invoke(p0);
    }

    private static final List registerProjectListeners$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new SmartList();
    }

    private static final List registerProjectListeners$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentSoftKeySoftValueMap(...)");
        pluginDescriptorsCache = concurrentMap;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/PluginStructureProvider$PluginDesignation;", "", "relativePath", "", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/String;Ljava/lang/ClassLoader;)V", "project", "Lcom/intellij/mock/MockProject;", "(Ljava/lang/String;Lcom/intellij/mock/MockProject;)V", "getRelativePath", "()Ljava/lang/String;", "getClassLoader", "()Ljava/lang/ClassLoader;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "analysis-api-standalone-base"})
    private static final class PluginDesignation {
        @NotNull
        private final String relativePath;
        @NotNull
        private final ClassLoader classLoader;

        public PluginDesignation(@NotNull String relativePath, @NotNull ClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            this.relativePath = relativePath;
            this.classLoader = classLoader;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        @NotNull
        public final ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public PluginDesignation(@NotNull String relativePath, @NotNull MockProject project) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ClassLoader classLoader = project.loadClass(PluginDesignation.class.getName(), fakePluginDescriptor).getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            this(relativePath, classLoader);
        }

        @NotNull
        public final String component1() {
            return this.relativePath;
        }

        @NotNull
        public final ClassLoader component2() {
            return this.classLoader;
        }

        @NotNull
        public final PluginDesignation copy(@NotNull String relativePath, @NotNull ClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            return new PluginDesignation(relativePath, classLoader);
        }

        public static /* synthetic */ PluginDesignation copy$default(PluginDesignation pluginDesignation, String string2, ClassLoader classLoader, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = pluginDesignation.relativePath;
            }
            if ((n & 2) != 0) {
                classLoader = pluginDesignation.classLoader;
            }
            return pluginDesignation.copy(string2, classLoader);
        }

        @NotNull
        public String toString() {
            return "PluginDesignation(relativePath=" + this.relativePath + ", classLoader=" + this.classLoader + ')';
        }

        public int hashCode() {
            int result2 = this.relativePath.hashCode();
            result2 = result2 * 31 + this.classLoader.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginDesignation)) {
                return false;
            }
            PluginDesignation pluginDesignation = (PluginDesignation)other;
            if (!Intrinsics.areEqual((Object)this.relativePath, (Object)pluginDesignation.relativePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.classLoader, (Object)pluginDesignation.classLoader);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/PluginStructureProvider$ReadContext;", "Lcom/intellij/ide/plugins/ReadModuleContext;", "<init>", "()V", "interner", "Lcom/intellij/util/NoOpXmlInterner;", "getInterner", "()Lcom/intellij/util/NoOpXmlInterner;", "isMissingIncludeIgnored", "", "()Z", "analysis-api-standalone-base"})
    private static final class ReadContext
    implements ReadModuleContext {
        @NotNull
        public static final ReadContext INSTANCE = new ReadContext();

        private ReadContext() {
        }

        @Override
        @NotNull
        public NoOpXmlInterner getInterner() {
            return NoOpXmlInterner.INSTANCE;
        }

        @Override
        public boolean isMissingIncludeIgnored() {
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/PluginStructureProvider$ResourceDataLoader;", "Lcom/intellij/platform/util/plugins/DataLoader;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Ljava/lang/ClassLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "pool", "Lcom/intellij/util/lang/ZipFilePool;", "getPool", "()Lcom/intellij/util/lang/ZipFilePool;", "load", "Ljava/io/InputStream;", "path", "", "toString", "analysis-api-standalone-base"})
    private static final class ResourceDataLoader
    implements DataLoader {
        @NotNull
        private final ClassLoader classLoader;

        public ResourceDataLoader(@NotNull ClassLoader classLoader) {
            Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
            this.classLoader = classLoader;
        }

        @NotNull
        public final ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Override
        @Nullable
        public ZipFilePool getPool() {
            return null;
        }

        @Override
        @Nullable
        public InputStream load(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            URL uRL = this.classLoader.getResource(path);
            return uRL != null ? uRL.openStream() : null;
        }

        @Override
        @NotNull
        public String toString() {
            return "resources data loader";
        }

        @Override
        public boolean isExcludedFromSubSearch(@NotNull Path jarFile) {
            return DataLoader.DefaultImpls.isExcludedFromSubSearch(this, jarFile);
        }
    }
}

