/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.components;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.components.KtAnalysisScopeProvider;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KtAnalysisScopeProviderImplKt;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KtAnalysisScopeProviderResolveScope;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.providers.KotlinResolutionScopeProvider;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u001a*\u00020\u001cH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KtAnalysisScopeProviderImpl;", "Lorg/jetbrains/kotlin/analysis/api/components/KtAnalysisScopeProvider;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "shadowedScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;Lcom/intellij/psi/search/GlobalSearchScope;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "baseResolveScope", "getBaseResolveScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "baseResolveScope$delegate", "Lkotlin/Lazy;", "resolveScope", "Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KtAnalysisScopeProviderResolveScope;", "getResolveScope", "()Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KtAnalysisScopeProviderResolveScope;", "resolveScope$delegate", "getAnalysisScope", "canBeAnalysed", "", "psi", "Lcom/intellij/psi/PsiElement;", "isFromGeneratedModule", "analysis-api-impl-base"})
public final class KtAnalysisScopeProviderImpl
extends KtAnalysisScopeProvider {
    @NotNull
    private final KtAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;
    @NotNull
    private final GlobalSearchScope shadowedScope;
    @NotNull
    private final Lazy baseResolveScope$delegate;
    @NotNull
    private final Lazy resolveScope$delegate;

    public KtAnalysisScopeProviderImpl(@NotNull KtAnalysisSession analysisSession, @NotNull KtLifetimeToken token, @NotNull GlobalSearchScope shadowedScope) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)shadowedScope, (String)"shadowedScope");
        this.analysisSession = analysisSession;
        this.token = token;
        this.shadowedScope = shadowedScope;
        this.baseResolveScope$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtAnalysisScopeProviderImpl.baseResolveScope_delegate$lambda$0(this));
        this.resolveScope$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KtAnalysisScopeProviderImpl.resolveScope_delegate$lambda$1(this));
    }

    @Override
    @NotNull
    protected KtAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    private final GlobalSearchScope getBaseResolveScope() {
        Lazy lazy = this.baseResolveScope$delegate;
        return (GlobalSearchScope)lazy.getValue();
    }

    private final KtAnalysisScopeProviderResolveScope getResolveScope() {
        Lazy lazy = this.resolveScope$delegate;
        return (KtAnalysisScopeProviderResolveScope)lazy.getValue();
    }

    @Override
    @NotNull
    public GlobalSearchScope getAnalysisScope() {
        return this.getResolveScope();
    }

    @Override
    public boolean canBeAnalysed(@NotNull PsiElement psi) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return PsiUtilsKt.contains(this.getBaseResolveScope(), psi) && !PsiUtilsKt.contains(this.shadowedScope, psi) || this.isFromGeneratedModule(psi);
    }

    private final boolean isFromGeneratedModule(PsiElement $this$isFromGeneratedModule) {
        PsiFile psiFile = $this$isFromGeneratedModule.getContainingFile();
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return false;
        }
        KtFile ktFile2 = ktFile;
        VirtualFile virtualFile = ktFile2.getVirtualFile();
        return virtualFile != null ? KtAnalysisScopeProviderImplKt.access$isFromGeneratedModule(virtualFile, this.getAnalysisSession().getUseSiteModule()) : false;
    }

    private static final GlobalSearchScope baseResolveScope_delegate$lambda$0(KtAnalysisScopeProviderImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return KotlinResolutionScopeProvider.Companion.getInstance(this$0.getAnalysisSession().getUseSiteModule().getProject()).getResolutionScope(this$0.getAnalysisSession().getUseSiteModule());
    }

    private static final KtAnalysisScopeProviderResolveScope resolveScope_delegate$lambda$1(KtAnalysisScopeProviderImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new KtAnalysisScopeProviderResolveScope(this$0.getBaseResolveScope(), this$0.getAnalysisSession().getUseSiteModule(), this$0.shadowedScope);
    }
}

