/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KtAnalysisSession;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationApplicationWithArgumentsInfo;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtArrayAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtConstantAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtEnumEntryAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtKClassAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtUnsupportedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValue;
import org.jetbrains.kotlin.analysis.api.base.KtConstantValueFactory;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KtSymbolPointer;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEnumEntryDeserializedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedSymbolError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedTypeQualifierError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.ArrayFqNames;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u0004\u0018\u00010\u0010\"\u0004\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J.\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0014*\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0016*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter;", "", "<init>", "()V", "toNamedConstantValue", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtNamedAnnotationValue;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KtAnalysisSession;", "argumentMapping", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "builder", "Lorg/jetbrains/kotlin/analysis/api/fir/KtSymbolByFirBuilder;", "convertConstantExpression", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtConstantAnnotationValue;", "T", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "convertVarargsExpression", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KtAnnotationValue;", "Lorg/jetbrains/kotlin/psi/KtElement;", "toConstantValue", "firExpression", "computeErrorCallClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationValueConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationValueConverter.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n126#2:241\n153#2,3:242\n1#3:245\n57#4,4:246\n1863#5,2:250\n*S KotlinDebug\n*F\n+ 1 FirAnnotationValueConverter.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirAnnotationValueConverter\n*L\n43#1:241\n43#1:242,3\n139#1:246,4\n139#1:250,2\n*E\n"})
public final class FirAnnotationValueConverter {
    @NotNull
    public static final FirAnnotationValueConverter INSTANCE = new FirAnnotationValueConverter();

    private FirAnnotationValueConverter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtNamedAnnotationValue> toNamedConstantValue(@NotNull KtAnalysisSession analysisSession, @NotNull Map<Name, ? extends FirExpression> argumentMapping2, @NotNull KtSymbolByFirBuilder builder2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter(argumentMapping2, (String)"argumentMapping");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Map<Name, ? extends FirExpression> $this$map$iv = argumentMapping2;
        boolean $i$f$map = false;
        Map<Name, ? extends FirExpression> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name2 = (Name)entry.getKey();
            FirExpression expression2 = (FirExpression)entry.getValue();
            KtAnnotationValue ktAnnotationValue = INSTANCE.convertConstantExpression(expression2, builder2);
            if (ktAnnotationValue == null) {
                ktAnnotationValue = new KtUnsupportedAnnotationValue(analysisSession.getToken());
            }
            collection.add(new KtNamedAnnotationValue(name2, ktAnnotationValue, analysisSession.getToken()));
        }
        return (List)destination$iv$iv;
    }

    private final <T> KtConstantAnnotationValue convertConstantExpression(FirLiteralExpression<T> $this$convertConstantExpression, KtAnalysisSession analysisSession) {
        KtConstantAnnotationValue ktConstantAnnotationValue;
        KtConstantValue constantValue;
        KtConstantValue ktConstantValue;
        PsiElement psiElement = UtilsKt.getPsi($this$convertConstantExpression);
        KtElement expression2 = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        ConeKotlinType type2 = $this$convertConstantExpression.getConeTypeOrNull();
        if ($this$convertConstantExpression.getValue() == null) {
            ktConstantValue = new KtConstantValue.KtNullConstantValue(expression2);
        } else if (type2 == null) {
            PsiElement psiElement2;
            ktConstantValue = KtConstantValueFactory.INSTANCE.createConstantValue($this$convertConstantExpression.getValue(), (psiElement2 = UtilsKt.getPsi($this$convertConstantExpression)) instanceof KtElement ? (KtElement)psiElement2 : null);
        } else if (ConeBuiltinTypeUtilsKt.isBoolean(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Boolean");
            ktConstantValue = new KtConstantValue.KtBooleanConstantValue((Boolean)t, expression2);
        } else if (ConeBuiltinTypeUtilsKt.isChar(type2)) {
            char c;
            T t = $this$convertConstantExpression.getValue();
            Character c2 = t instanceof Character ? (Character)t : null;
            if (c2 != null) {
                c = c2.charValue();
            } else {
                T t2 = $this$convertConstantExpression.getValue();
                Intrinsics.checkNotNull(t2, (String)"null cannot be cast to non-null type kotlin.Number");
                c = (char)((Number)t2).intValue();
            }
            ktConstantValue = new KtConstantValue.KtCharConstantValue(c, expression2);
        } else if (ConeBuiltinTypeUtilsKt.isByte(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtByteConstantValue(((Number)t).byteValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isUByte(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedByteConstantValue(UByte.constructor-impl((byte)((Number)t).byteValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isShort(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtShortConstantValue(((Number)t).shortValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isUShort(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedShortConstantValue(UShort.constructor-impl((short)((Number)t).shortValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isInt(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtIntConstantValue(((Number)t).intValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isUInt(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedIntConstantValue(UInt.constructor-impl((int)((Number)t).intValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isLong(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtLongConstantValue(((Number)t).longValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isULong(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtUnsignedLongConstantValue(ULong.constructor-impl((long)((Number)t).longValue()), expression2, null);
        } else if (ConeBuiltinTypeUtilsKt.isString(type2)) {
            ktConstantValue = new KtConstantValue.KtStringConstantValue(String.valueOf($this$convertConstantExpression.getValue()), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isFloat(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtFloatConstantValue(((Number)t).floatValue(), expression2);
        } else if (ConeBuiltinTypeUtilsKt.isDouble(type2)) {
            T t = $this$convertConstantExpression.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Number");
            ktConstantValue = new KtConstantValue.KtDoubleConstantValue(((Number)t).doubleValue(), expression2);
        } else {
            ktConstantValue = null;
        }
        KtConstantValue ktConstantValue2 = constantValue = ktConstantValue;
        if (ktConstantValue2 != null) {
            KtConstantValue it = ktConstantValue2;
            boolean bl = false;
            ktConstantAnnotationValue = new KtConstantAnnotationValue(it, analysisSession.getToken());
        } else {
            ktConstantAnnotationValue = null;
        }
        return ktConstantAnnotationValue;
    }

    private final Pair<Collection<KtAnnotationValue>, KtElement> convertVarargsExpression(Collection<? extends FirExpression> $this$convertVarargsExpression, KtSymbolByFirBuilder builder2) {
        List list;
        KtElement representativePsi = null;
        List $this$convertVarargsExpression_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirExpression firExpression : $this$convertVarargsExpression) {
            KtAnnotationValue converted;
            if (INSTANCE.convertConstantExpression(firExpression, builder2) == null) continue;
            boolean bl2 = (firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression) && converted instanceof KtArrayAnnotationValue ? $this$convertVarargsExpression_u24lambda_u242.addAll(((KtArrayAnnotationValue)converted).getValues()) : $this$convertVarargsExpression_u24lambda_u242.add(converted);
            KtElement ktElement = representativePsi;
            if (ktElement == null) {
                ktElement = converted.getSourcePsi();
            }
            representativePsi = ktElement;
        }
        List flattenedVarargs = CollectionsKt.build((List)list);
        return TuplesKt.to((Object)flattenedVarargs, representativePsi);
    }

    @Nullable
    public final KtAnnotationValue toConstantValue(@NotNull FirExpression firExpression, @NotNull KtSymbolByFirBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)firExpression, (String)"firExpression");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return this.convertConstantExpression(firExpression, builder2);
    }

    private final KtAnnotationValue convertConstantExpression(FirExpression $this$convertConstantExpression, KtSymbolByFirBuilder builder2) {
        KtAnnotationValue ktAnnotationValue;
        Object object;
        KtLifetimeToken token = builder2.getAnalysisSession().getToken();
        PsiElement psiElement = UtilsKt.getPsi($this$convertConstantExpression);
        KtElement sourcePsi = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        FirLiteralExpression<?> firLiteralExpression = $this$convertConstantExpression;
        if (firLiteralExpression instanceof FirLiteralExpression) {
            object = this.convertConstantExpression($this$convertConstantExpression, builder2.getAnalysisSession());
        } else if (firLiteralExpression instanceof FirNamedArgumentExpression) {
            object = this.convertConstantExpression(((FirNamedArgumentExpression)((Object)$this$convertConstantExpression)).getExpression(), builder2);
        } else if (firLiteralExpression instanceof FirSpreadArgumentExpression) {
            object = this.convertConstantExpression(((FirSpreadArgumentExpression)((Object)$this$convertConstantExpression)).getExpression(), builder2);
        } else if (firLiteralExpression instanceof FirVarargArgumentsExpression) {
            Pair<Collection<KtAnnotationValue>, KtElement> pair = this.convertVarargsExpression((Collection<? extends FirExpression>)((FirVarargArgumentsExpression)((Object)$this$convertConstantExpression)).getArguments(), builder2);
            Collection annotationValues = (Collection)pair.component1();
            KtElement representativePsi = (KtElement)pair.component2();
            KtElement ktElement = representativePsi;
            if (ktElement == null) {
                ktElement = sourcePsi;
            }
            object = new KtArrayAnnotationValue(annotationValues, ktElement, token);
        } else if (firLiteralExpression instanceof FirArrayLiteral) {
            object = new KtArrayAnnotationValue((Collection)this.convertVarargsExpression((Collection<? extends FirExpression>)((FirArrayLiteral)((Object)$this$convertConstantExpression)).getArgumentList().getArguments(), builder2).getFirst(), sourcePsi, token);
        } else if (firLiteralExpression instanceof FirFunctionCall) {
            FirNamedReference representativePsi = ((FirFunctionCall)((Object)$this$convertConstantExpression)).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = representativePsi instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)representativePsi : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference2 = firResolvedNamedReference;
            FirBasedSymbol<?> resolvedSymbol = reference2.getResolvedSymbol();
            if (resolvedSymbol instanceof FirConstructorSymbol) {
                KtAnnotationApplicationValue ktAnnotationApplicationValue;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(resolvedSymbol, builder2.getRootSession());
                if (firClassLikeSymbol == null) {
                    return null;
                }
                FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
                Object object2 = classSymbol.getFir();
                FirClass firClass = object2 instanceof FirClass ? (FirClass)object2 : null;
                if ((firClass != null ? firClass.getClassKind() : null) == ClassKind.ANNOTATION_CLASS) {
                    KtFirAnalysisSession $this$resolvedArgumentMapping$iv;
                    Map resultMap = new LinkedHashMap();
                    FirCall firCall = (FirCall)((Object)$this$convertConstantExpression);
                    boolean $i$f$getResolvedArgumentMapping = false;
                    FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
                    LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
                    Object object3 = linkedHashMap;
                    if (linkedHashMap != null && (object3 = ((LinkedHashMap)object3).entrySet()) != null) {
                        Iterable $this$forEach$iv = (Iterable)object3;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Map.Entry entry = (Map.Entry)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)entry);
                            Object k = entry.getKey();
                            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                            FirExpression arg = (FirExpression)k;
                            Object v = entry.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                            FirValueParameter param = (FirValueParameter)v;
                            resultMap.put(param.getName(), arg);
                        }
                    }
                    KtCallElement ktCallElement = (object2 = UtilsKt.getPsi($this$convertConstantExpression)) instanceof KtCallElement ? (KtCallElement)object2 : null;
                    $this$resolvedArgumentMapping$iv = builder2.getAnalysisSession();
                    Integer n = null;
                    List<KtNamedAnnotationValue> list = this.toNamedConstantValue(builder2.getAnalysisSession(), resultMap, builder2);
                    AnnotationUseSiteTarget annotationUseSiteTarget = null;
                    KtCallElement ktCallElement2 = ktCallElement;
                    ClassId classId = ((FirConstructorSymbol)resolvedSymbol).getCallableId().getClassId();
                    boolean bl = false;
                    KtSymbolPointer<KtConstructorSymbol> ktSymbolPointer = builder2.getFunctionLikeBuilder().buildConstructorSymbol((FirConstructorSymbol)resolvedSymbol).createPointer();
                    KtLifetimeToken ktLifetimeToken = token;
                    KtSymbolPointer<KtConstructorSymbol> ktSymbolPointer2 = ktSymbolPointer;
                    Integer n2 = n;
                    List<KtNamedAnnotationValue> list2 = list;
                    AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget;
                    KtCallElement ktCallElement3 = ktCallElement2;
                    ClassId classId2 = classId;
                    KtLifetimeToken ktLifetimeToken2 = token;
                    KtAnnotationApplicationWithArgumentsInfo ktAnnotationApplicationWithArgumentsInfo = new KtAnnotationApplicationWithArgumentsInfo(classId2, ktCallElement3, annotationUseSiteTarget2, list2, n2, ktSymbolPointer2, ktLifetimeToken);
                    ktAnnotationApplicationValue = new KtAnnotationApplicationValue(ktAnnotationApplicationWithArgumentsInfo, ktLifetimeToken2);
                } else {
                    ktAnnotationApplicationValue = null;
                }
                object = ktAnnotationApplicationValue;
            } else if (resolvedSymbol instanceof FirNamedFunctionSymbol) {
                if (ArrayFqNames.ARRAY_CALL_FQ_NAMES.contains(((FirNamedFunctionSymbol)resolvedSymbol).getCallableId().asSingleFqName())) {
                    object = (FirExpression)CollectionsKt.singleOrNull(((FirFunctionCall)((Object)$this$convertConstantExpression)).getArgumentList().getArguments());
                    if (object == null || (object = this.convertConstantExpression((FirExpression)object, builder2)) == null) {
                        object = new KtArrayAnnotationValue(CollectionsKt.emptyList(), sourcePsi, token);
                    }
                } else {
                    object = null;
                }
            } else {
                object = resolvedSymbol instanceof FirEnumEntrySymbol ? (KtAnnotationValue)new KtEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi, token) : null;
            }
        } else if (firLiteralExpression instanceof FirPropertyAccessExpression) {
            FirReference classSymbol = ((FirPropertyAccessExpression)((Object)$this$convertConstantExpression)).getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference = classSymbol instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)classSymbol : null;
            if (firResolvedNamedReference == null) {
                return null;
            }
            FirResolvedNamedReference reference3 = firResolvedNamedReference;
            FirBasedSymbol<?> resolvedSymbol = reference3.getResolvedSymbol();
            object = resolvedSymbol instanceof FirEnumEntrySymbol ? new KtEnumEntryAnnotationValue(((FirEnumEntrySymbol)resolvedSymbol).getCallableId(), sourcePsi, token) : null;
        } else if (firLiteralExpression instanceof FirEnumEntryDeserializedAccessExpression) {
            object = new KtEnumEntryAnnotationValue(new CallableId(((FirEnumEntryDeserializedAccessExpression)((Object)$this$convertConstantExpression)).getEnumClassId(), ((FirEnumEntryDeserializedAccessExpression)((Object)$this$convertConstantExpression)).getEnumEntryName()), sourcePsi, token);
        } else if (firLiteralExpression instanceof FirGetClassCall) {
            KtKClassAnnotationValue ktKClassAnnotationValue;
            ConeKotlinType coneType;
            ConeKotlinType coneKotlinType = FirAnnotationUtilsKt.getTargetType((FirGetClassCall)((Object)$this$convertConstantExpression));
            ConeKotlinType coneKotlinType2 = coneType = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType(coneKotlinType, builder2.getRootSession()) : null;
            if (coneType instanceof ConeClassLikeType && !(coneType instanceof ConeErrorType)) {
                ClassId classId = ((ConeClassLikeType)coneType).getLookupTag().getClassId();
                KtType type2 = builder2.getTypeBuilder().buildKtType(coneType);
                ktKClassAnnotationValue = new KtKClassAnnotationValue(type2, classId, sourcePsi, token);
            } else {
                ConeDiagnostic coneDiagnostic;
                ClassId classId;
                ClassId classId3 = classId = this.computeErrorCallClassId((FirGetClassCall)((Object)$this$convertConstantExpression));
                if (classId3 != null) {
                    ClassId p0 = classId3;
                    boolean bl = false;
                    coneDiagnostic = new ConeUnresolvedSymbolError(p0);
                } else {
                    coneDiagnostic = new ConeSimpleDiagnostic("Unresolved class reference", null, 2, null);
                }
                ConeDiagnostic diagnostic = coneDiagnostic;
                KtType errorType = builder2.getTypeBuilder().buildKtType(new ConeErrorType(diagnostic, false, null, null, null, 30, null));
                ktKClassAnnotationValue = new KtKClassAnnotationValue(errorType, classId, sourcePsi, token);
            }
            object = ktKClassAnnotationValue;
        } else {
            object = ktAnnotationValue = null;
        }
        if (object == null) {
            firLiteralExpression = FirCompileTimeConstantEvaluator.INSTANCE.evaluate((FirElement)$this$convertConstantExpression, KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
            ktAnnotationValue = firLiteralExpression != null ? this.convertConstantExpression(firLiteralExpression, builder2.getAnalysisSession()) : null;
        }
        return ktAnnotationValue;
    }

    private final ClassId computeErrorCallClassId(FirGetClassCall call2) {
        FqNameUnsafe fqNameUnsafe;
        String fqNameString;
        List list;
        List qualifierParts = new ArrayList();
        FirAnnotationValueConverter.computeErrorCallClassId$process(qualifierParts, call2.getArgument());
        List it = list = CollectionsKt.filterNotNull((Iterable)CollectionsKt.asReversedMutable((List)qualifierParts));
        boolean bl = false;
        List list2 = !((Collection)it).isEmpty() ? list : null;
        String string2 = fqNameString = list2 != null ? CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)".", null, null, (int)0, null, null, (int)62, null) : null;
        if (fqNameString != null && (fqNameUnsafe = new FqNameUnsafe(fqNameString)).isSafe()) {
            FqName fqName = fqNameUnsafe.toSafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"toSafe(...)");
            return ClassId.Companion.topLevel(fqName);
        }
        return null;
    }

    private static final void computeErrorCallClassId$process(List<String> qualifierParts, FirExpression expression2) {
        block1: {
            ConeDiagnostic diagnostic;
            ConeErrorType errorType;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(expression2);
            ConeErrorType coneErrorType = errorType = coneKotlinType instanceof ConeErrorType ? (ConeErrorType)coneKotlinType : null;
            ConeDiagnostic coneDiagnostic = diagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
            String unresolvedName = diagnostic instanceof ConeUnresolvedTypeQualifierError ? ((ConeUnresolvedTypeQualifierError)diagnostic).getQualifier() : (diagnostic instanceof ConeUnresolvedNameError ? ((ConeUnresolvedNameError)diagnostic).getQualifier() : null);
            ((Collection)qualifierParts).add(unresolvedName);
            if (errorType == null || !(expression2 instanceof FirPropertyAccessExpression)) break block1;
            FirExpression firExpression = ((FirPropertyAccessExpression)expression2).getExplicitReceiver();
            if (firExpression != null) {
                FirExpression it = firExpression;
                boolean bl = false;
                FirAnnotationValueConverter.computeErrorCallClassId$process(qualifierParts, it);
            }
        }
    }
}

