/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "()V", "DANGEROUS_CHARS", "", "", "INVALID_CHARS", "getINVALID_CHARS", "()Ljava/util/Set;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkIdentifier", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "checkNamed", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "reportIfNeeded", "name", "", "reportOn", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmSimpleNameBacktickChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSimpleNameBacktickChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,80:1\n1855#2,2:81\n1855#2,2:83\n1855#2,2:85\n1083#3,2:87\n1083#3,2:89\n*S KotlinDebug\n*F\n+ 1 JvmSimpleNameBacktickChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmSimpleNameBacktickChecker\n*L\n39#1:81,2\n42#1:83,2\n45#1:85,2\n64#1:87,2\n72#1:89,2\n*E\n"})
public final class JvmSimpleNameBacktickChecker
implements IdentifierChecker {
    @NotNull
    public static final JvmSimpleNameBacktickChecker INSTANCE = new JvmSimpleNameBacktickChecker();
    @NotNull
    private static final Set<Character> INVALID_CHARS;
    @NotNull
    private static final Set<Character> DANGEROUS_CHARS;

    private JvmSimpleNameBacktickChecker() {
    }

    @NotNull
    public final Set<Character> getINVALID_CHARS() {
        return INVALID_CHARS;
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), (Function0<? extends PsiElement>)new Function0<PsiElement>(simpleNameExpression){
            final /* synthetic */ KtSimpleNameExpression $simpleNameExpression;
            {
                this.$simpleNameExpression = $simpleNameExpression;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                return this.$simpleNameExpression.getIdentifier();
            }
        }, diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration2, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        if (declaration2 instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list2 = ((KtDestructuringDeclaration)declaration2).getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "getEntries(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtCallableDeclaration) {
            List<KtParameter> list3 = ((KtCallableDeclaration)declaration2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list4 = ((KtTypeParameterListOwner)declaration2).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list4, "getTypeParameters(...)");
            $this$forEach$iv = list4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                INSTANCE.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration2 instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration2, diagnosticHolder);
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration2, DiagnosticSink diagnosticHolder) {
        String string2 = declaration2.getName();
        if (string2 == null) {
            return;
        }
        String name2 = string2;
        this.reportIfNeeded(name2, (Function0<? extends PsiElement>)new Function0<PsiElement>(declaration2){
            final /* synthetic */ KtNamedDeclaration $declaration;
            {
                this.$declaration = $declaration;
                super(0);
            }

            @Nullable
            public final PsiElement invoke() {
                PsiElement psiElement = this.$declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = this.$declaration;
                }
                return psiElement;
            }
        }, diagnosticHolder);
    }

    private final void reportIfNeeded(String name2, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string2 = KtPsiUtil.unquoteIdentifier(name2);
        Intrinsics.checkNotNullExpressionValue(string2, "unquoteIdentifier(...)");
        String text = string2;
        if (((CharSequence)text).length() == 0) {
            PsiElement psiElement = reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "should not be empty"));
        } else {
            boolean bl;
            char it;
            char element$iv;
            int n;
            boolean $i$f$any;
            CharSequence $this$any$iv;
            block10: {
                $this$any$iv = text;
                $i$f$any = false;
                for (n = 0; n < $this$any$iv.length(); ++n) {
                    it = element$iv = $this$any$iv.charAt(n);
                    boolean bl2 = false;
                    if (!INVALID_CHARS.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                PsiElement psiElement = reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(Errors.INVALID_CHARACTERS.on(psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)INVALID_CHARS, (Iterable)StringsKt.toSet(text)), "", null, null, 0, null, null, 62, null)));
            } else {
                boolean bl3;
                block11: {
                    $this$any$iv = text;
                    $i$f$any = false;
                    for (n = 0; n < $this$any$iv.length(); ++n) {
                        it = element$iv = $this$any$iv.charAt(n);
                        boolean bl4 = false;
                        if (!DANGEROUS_CHARS.contains(Character.valueOf(it))) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
                if (bl3) {
                    PsiElement psiElement = reportOn.invoke();
                    if (psiElement == null) {
                        return;
                    }
                    diagnosticHolder.report(ErrorsJvm.DANGEROUS_CHARACTERS.on(psiElement, CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)DANGEROUS_CHARS, (Iterable)StringsKt.toSet(text)), "", null, null, 0, null, null, 62, null)));
                }
            }
        }
    }

    static {
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\')};
        INVALID_CHARS = SetsKt.setOf(characterArray);
        characterArray = new Character[]{Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('%')};
        DANGEROUS_CHARS = SetsKt.setOf(characterArray);
    }
}

