/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.UrlUtilRt;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassLoadingLocks;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader
implements ClassPath.ClassDataConsumer {
    private static final boolean isParallelCapable = UrlClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = UrlClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> skipFindingResource = new ThreadLocal();
    private final List<Path> files;
    protected final ClassPath classPath;
    private final ClassLoadingLocks<String> classLoadingLocks;
    private final boolean isBootstrapResourcesAllowed;
    @NotNull
    protected final ClassPath.ClassDataConsumer classDataConsumer;
    @ApiStatus.Internal
    @Nullable
    public BiPredicate<String, Boolean> resolveScopeManager;

    final void appendToClassPathForInstrumentation(@NotNull String jar) {
        if (jar == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        this.addFiles(Collections.singletonList(Paths.get(jar, new String[0])));
    }

    @ApiStatus.Internal
    @NotNull
    public final ClassPath getClassPath() {
        ClassPath classPath2 = this.classPath;
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        return classPath2;
    }

    @ApiStatus.Internal
    @NotNull
    public static Collection<Map.Entry<String, Path>> getLoadedClasses() {
        Collection<Map.Entry<String, Path>> collection = ClassPath.getLoadedClasses();
        if (collection == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public final List<Path> getBaseUrls() {
        List<Path> list2 = this.classPath.getBaseUrls();
        if (list2 == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public final Map<String, Long> getLoadingStats() {
        Map<String, Long> map = ClassPath.getLoadingStats();
        if (map == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent2) {
        if (parent2 == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        this(UrlClassLoader.createDefaultBuilderForJdk(parent2), null, isParallelCapable);
        UrlClassLoader.registerInClassLoaderValueMap(parent2, this);
    }

    protected static void registerInClassLoaderValueMap(@NotNull ClassLoader parent2, @NotNull ClassLoader classLoader) {
        if (parent2 == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        if (classLoader == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(classLoader, f.get(parent2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    protected static Builder createDefaultBuilderForJdk(@NotNull ClassLoader parent2) {
        if (parent2 == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        Builder configuration2 = new Builder();
        if (parent2 instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)parent2).getURLs();
            configuration2.files = new ArrayList<Path>(urls.length);
            for (URL url : urls) {
                configuration2.files.add(Paths.get(url.getPath(), new String[0]));
            }
        } else {
            String[] parts2 = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
            configuration2.files = new ArrayList<Path>(parts2.length);
            for (String s : parts2) {
                configuration2.files.add(new File(s).toPath());
            }
        }
        configuration2.parent = parent2.getParent();
        configuration2.lockJars = true;
        configuration2.useCache = true;
        configuration2.isClassPathIndexEnabled = true;
        configuration2.isBootstrapResourcesAllowed = Boolean.parseBoolean(System.getProperty("idea.allow.bootstrap.resources", "true"));
        configuration2.autoAssignUrlsWithProtectionDomain();
        Builder builder2 = configuration2;
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        return builder2;
    }

    protected UrlClassLoader(@NotNull Builder builder2, boolean isParallelCapable) {
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(10);
        }
        this(builder2, null, isParallelCapable);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    protected UrlClassLoader(@NotNull Builder builder2) {
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(11);
        }
        this(builder2, null, false);
    }

    protected UrlClassLoader(@NotNull Builder builder2, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean isParallelCapable) {
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(12);
        }
        this(builder2, resourceFileFactory, isParallelCapable, false);
    }

    protected UrlClassLoader(@NotNull Builder builder2, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean isParallelCapable, boolean isMimicJarUrlConnectionNeeded) {
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(13);
        }
        super(builder2.parent);
        this.classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
        this.files = builder2.files;
        Set<Path> urlsWithProtectionDomain = builder2.pathsWithProtectionDomain;
        if (urlsWithProtectionDomain == null) {
            urlsWithProtectionDomain = Collections.emptySet();
        }
        this.classPath = new ClassPath(this.files, urlsWithProtectionDomain, builder2, resourceFileFactory, isMimicJarUrlConnectionNeeded);
        this.isBootstrapResourcesAllowed = builder2.isBootstrapResourcesAllowed;
        this.classLoadingLocks = isParallelCapable ? new ClassLoadingLocks() : null;
    }

    protected UrlClassLoader(@NotNull List<Path> files2, @NotNull ClassPath classPath2) {
        if (files2 == null) {
            UrlClassLoader.$$$reportNull$$$0(14);
        }
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(15);
        }
        super(null);
        this.classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
        this.files = files2;
        this.classPath = classPath2;
        this.isBootstrapResourcesAllowed = false;
        this.classLoadingLocks = new ClassLoadingLocks();
    }

    @Deprecated
    public final void addURL(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(16);
        }
        this.addFiles(Collections.singletonList(Paths.get(url.getPath(), new String[0])));
    }

    @ApiStatus.Internal
    public final void addFiles(@NotNull List<Path> files2) {
        if (files2 == null) {
            UrlClassLoader.$$$reportNull$$$0(17);
        }
        this.classPath.addFiles(files2);
        this.files.addAll(files2);
    }

    @NotNull
    public final List<URL> getUrls() {
        ArrayList<URL> result2 = new ArrayList<URL>();
        for (Path file2 : this.files) {
            try {
                result2.add(file2.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ArrayList<URL> arrayList = result2;
        if (arrayList == null) {
            UrlClassLoader.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    public final List<Path> getFiles() {
        List<Path> list2 = Collections.unmodifiableList(this.files);
        if (list2 == null) {
            UrlClassLoader.$$$reportNull$$$0(19);
        }
        return list2;
    }

    public final boolean hasLoadedClass(String name2) {
        Class<?> aClass = this.findLoadedClass(name2);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        Class<?> clazz;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(20);
        }
        if (name2.startsWith("com.intellij.util.lang.")) {
            return appClassLoader.loadClass(name2);
        }
        try {
            clazz = this.classPath.findClass(name2, this.classDataConsumer);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name2, e);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name2);
        }
        return clazz;
    }

    private void definePackageIfNeeded(String name2, Loader loader) throws IOException {
        int lastDotIndex = name2.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName2 = name2.substring(0, lastDotIndex);
        if (this.isPackageDefined(packageName2)) {
            return;
        }
        try {
            Map<Loader.Attribute, String> attributes2 = loader.getAttributes();
            if (attributes2 == null || attributes2.isEmpty()) {
                this.definePackage(packageName2, null, null, null, null, null, null, null);
            } else {
                this.definePackage(packageName2, attributes2.get((Object)Loader.Attribute.SPEC_TITLE), attributes2.get((Object)Loader.Attribute.SPEC_VERSION), attributes2.get((Object)Loader.Attribute.SPEC_VENDOR), attributes2.get((Object)Loader.Attribute.IMPL_TITLE), attributes2.get((Object)Loader.Attribute.IMPL_VERSION), attributes2.get((Object)Loader.Attribute.IMPL_VENDOR), null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isPackageDefined(String packageName2) {
        return this.getPackage(packageName2) != null;
    }

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    @Override
    public boolean isByteBufferSupported(@NotNull String name2, @Nullable ProtectionDomain protectionDomain) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(21);
        }
        return true;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, byte[] data2, Loader loader, @Nullable ProtectionDomain protectionDomain) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(22);
        }
        this.definePackageIfNeeded(name2, loader);
        return super.defineClass(name2, data2, 0, data2.length, protectionDomain == null ? this.getProtectionDomain() : protectionDomain);
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, ByteBuffer data2, Loader loader, @Nullable ProtectionDomain protectionDomain) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(23);
        }
        this.definePackageIfNeeded(name2, loader);
        return super.defineClass(name2, data2, protectionDomain == null ? this.getProtectionDomain() : protectionDomain);
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(24);
        }
        if (skipFindingResource.get() != null) {
            return null;
        }
        Resource resource = this.doFindResource(name2);
        return resource != null ? resource.getURL() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name2) {
        Resource resource;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(25);
        }
        if ((resource = this.doFindResource(name2)) != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                this.logError("Cannot load resource " + name2, e);
                return null;
            }
        }
        if (this.isBootstrapResourcesAllowed) {
            skipFindingResource.set(Boolean.TRUE);
            try {
                URL url = super.getResource(name2);
                if (url != null) {
                    try {
                        InputStream inputStream = url.openStream();
                        return inputStream;
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                skipFindingResource.set(null);
            }
        }
        return null;
    }

    @Nullable
    private Resource doFindResource(String name2) {
        String canonicalPath = UrlClassLoader.toCanonicalPath(name2);
        Resource resource = this.classPath.findResource(canonicalPath);
        if (resource == null && canonicalPath.startsWith("/") && this.classPath.findResource(canonicalPath.substring(1)) != null) {
            this.logError("Calling `ClassLoader#getResource` with leading slash doesn't work; strip", new IllegalArgumentException(name2));
        }
        return resource;
    }

    public final void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        if (dir == null) {
            UrlClassLoader.$$$reportNull$$$0(26);
        }
        if (fileNameFilter == null) {
            UrlClassLoader.$$$reportNull$$$0(27);
        }
        if (consumer == null) {
            UrlClassLoader.$$$reportNull$$$0(28);
        }
        this.classPath.processResources(dir, fileNameFilter, consumer);
    }

    @Override
    @NotNull
    protected Enumeration<URL> findResources(@NotNull String name2) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(29);
        }
        Enumeration<URL> enumeration = this.classPath.getResources(name2);
        if (enumeration == null) {
            UrlClassLoader.$$$reportNull$$$0(30);
        }
        return enumeration;
    }

    @Override
    @NotNull
    protected final Object getClassLoadingLock(String className) {
        Object object = this.classLoadingLocks == null ? this : this.classLoadingLocks.getOrCreateLock(className);
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(31);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> loadClassInsideSelf(@NotNull String name2, boolean forceLoadFromSubPluginClassloader) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(32);
        }
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name2);
            if (c != null) {
                return c;
            }
            if (!forceLoadFromSubPluginClassloader) {
                ClassLoader parent2 = this.getParent();
                if (parent2 != null) {
                    try {
                        c = parent2.loadClass(name2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c != null) {
                    return c;
                }
            }
            return this.classPath.findClass(name2, this.classDataConsumer);
        }
    }

    @NotNull
    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    protected static String toCanonicalPath(@NotNull String path) {
        char next;
        if (path == null) {
            UrlClassLoader.$$$reportNull$$$0(33);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/') {
                path = path.substring(2);
            }
        }
        int index2 = -1;
        do {
            char c = next = (index2 = path.indexOf(47, index2 + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index2 + 1);
        } while (next != '.' && next != '/' && index2 != -1);
        if (index2 == -1) {
            return path;
        }
        StringBuilder result2 = new StringBuilder(path.length());
        int start = UrlClassLoader.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    UrlClassLoader.processDots(result2, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0) {
            UrlClassLoader.processDots(result2, dots, start);
        }
        return result2.toString();
    }

    private static void processDots(StringBuilder result2, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!StringUtilRt.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = StringUtilRt.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result2.append('.');
            }
            result2.append('/');
        }
    }

    private static int processRoot(String path, StringBuilder result2) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            result2.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result2.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private void logError(String message2, Throwable t) {
        try {
            Class<?> logger = Class.forName("com.intellij.openapi.diagnostic.Logger", false, this);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object instance = lookup.findStatic(logger, "getInstance", MethodType.methodType(logger, Class.class)).invoke(this.getClass());
            lookup.findVirtual(logger, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class)).bindTo(instance).invokeExact(message2, t);
        }
        catch (Throwable tt) {
            tt.addSuppressed(t);
            tt.printStackTrace(System.err);
        }
    }

    @NotNull
    public static String urlToFilePath(@NotNull String url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(34);
        }
        int start = url.startsWith("file:") ? "file:".length() : 0;
        int end = url.indexOf("!/");
        if (url.charAt(start) == '/' && url.length() > start + 2 && url.charAt(start + 2) == ':') {
            ++start;
        }
        String string2 = UrlUtilRt.unescapePercentSequences(url, start, end < 0 ? url.length() : end).toString();
        if (string2 == null) {
            UrlClassLoader.$$$reportNull$$$0(35);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 16: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBuilderForJdk";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "findResources";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerInClassLoaderValueMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBuilderForJdk";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isByteBufferSupported";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "consumeClassData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadClassInsideSelf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        private static final boolean isClassPathIndexEnabledGlobalValue = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
        List<Path> files = Collections.emptyList();
        @Nullable
        Set<Path> pathsWithProtectionDomain;
        ClassLoader parent;
        boolean lockJars = true;
        boolean useCache;
        boolean isClassPathIndexEnabled;
        boolean isBootstrapResourcesAllowed;
        boolean errorOnMissingJar = true;
        @Nullable
        CachePoolImpl cachePool;
        Predicate<? super Path> cachingCondition;

        Builder() {
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2022.2")
        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            ArrayList<Path> files2 = new ArrayList<Path>(urls.size());
            for (URL url : urls) {
                files2.add(Paths.get(UrlClassLoader.urlToFilePath(url.getPath()), new String[0]));
            }
            this.files = files2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        public Builder files(@NotNull List<Path> paths) {
            if (paths == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.files = paths;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        Builder urlsWithProtectionDomain(@NotNull Set<Path> value2) {
            if (value2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.pathsWithProtectionDomain = value2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        public Builder parent(ClassLoader parent2) {
            this.parent = parent2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder allowLock(boolean lockJars) {
            this.lockJars = lockJars;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder useCache() {
            this.useCache = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder useCache(boolean useCache) {
            this.useCache = useCache;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.isClassPathIndexEnabled = isClassPathIndexEnabledGlobalValue;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder useCache(@NotNull CachePool pool, @NotNull Predicate<? super Path> condition) {
            if (pool == null) {
                Builder.$$$reportNull$$$0(11);
            }
            if (condition == null) {
                Builder.$$$reportNull$$$0(12);
            }
            this.useCache = true;
            this.cachePool = (CachePoolImpl)pool;
            this.cachingCondition = condition;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder2;
        }

        @NotNull
        public Builder noPreload() {
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder allowBootstrapResources() {
            Builder builder2 = this.allowBootstrapResources(true);
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder2;
        }

        @NotNull
        public Builder allowBootstrapResources(boolean allowBootstrapResources) {
            this.isBootstrapResourcesAllowed = allowBootstrapResources;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder2;
        }

        @NotNull
        public Builder setLogErrorOnMissingJar(boolean log) {
            this.errorOnMissingJar = log;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return builder2;
        }

        @NotNull
        public Builder autoAssignUrlsWithProtectionDomain() {
            HashSet<Path> result2 = null;
            for (Path path : this.files) {
                if (!Builder.isUrlNeedsProtectionDomain(path)) continue;
                if (result2 == null) {
                    result2 = new HashSet<Path>();
                }
                result2.add(path);
            }
            this.pathsWithProtectionDomain = result2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return builder2;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this, null, isParallelCapable);
        }

        private static boolean isUrlNeedsProtectionDomain(@NotNull Path file2) {
            int offset;
            String path;
            if (file2 == null) {
                Builder.$$$reportNull$$$0(19);
            }
            return (path = file2.toString()).endsWith(".jar") && (path.startsWith("bcprov-", offset = path.lastIndexOf(file2.getFileSystem().getSeparator().charAt(0)) + 1) || path.startsWith("bcpkix-", offset));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pool";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "files";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urlsWithProtectionDomain";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parent";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowLock";
                    break;
                }
                case 8: 
                case 9: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCache";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "usePersistentClasspathIndexForLocalClassDirectories";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "noPreload";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowBootstrapResources";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setLogErrorOnMissingJar";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "autoAssignUrlsWithProtectionDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "files";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "urlsWithProtectionDomain";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "useCache";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "isUrlNeedsProtectionDomain";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface CachePool {
    }
}

