/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ReservedMembersAndConstructsForValueClass;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nValueClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ReservedMembersAndConstructsForValueClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,280:1\n1747#2,3:281\n*S KotlinDebug\n*F\n+ 1 ValueClassDeclarationChecker.kt\norg/jetbrains/kotlin/resolve/checkers/ReservedMembersAndConstructsForValueClass\n*L\n256#1:281,3\n*E\n"})
public final class ReservedMembersAndConstructsForValueClass
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> boxAndUnboxNames;
    @NotNull
    private static final Set<String> equalsAndHashCodeNames;

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context2, "context");
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        if (declarationDescriptor == null) {
            return;
        }
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (!InlineClassesUtilsKt.isValueClass(containingDeclaration)) {
            return;
        }
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
            KtFunction ktFunction = declaration2 instanceof KtFunction ? (KtFunction)declaration2 : null;
            if (ktFunction == null) {
                return;
            }
            KtFunction ktFunction2 = ktFunction;
            String string2 = ((SimpleFunctionDescriptor)descriptor2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String functionName = string2;
            if (boxAndUnboxNames.contains(functionName) || equalsAndHashCodeNames.contains(functionName) && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.CustomEqualsInValueClasses)) {
                PsiElement psiElement = ktFunction2.getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
                PsiElement nameIdentifier = psiElement;
                context2.getTrace().report(Errors.RESERVED_MEMBER_INSIDE_VALUE_CLASS.on(nameIdentifier, functionName));
            } else if (DescriptorUtilKt.isTypedEqualsInValueClass((FunctionDescriptor)descriptor2)) {
                KotlinType parameterType;
                List<TypeParameterDescriptor> list2 = ((SimpleFunctionDescriptor)descriptor2).getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getTypeParameters(...)");
                if (!((Collection)list2).isEmpty()) {
                    context2.getTrace().report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)declaration2)));
                }
                List<ValueParameterDescriptor> list3 = ((SimpleFunctionDescriptor)descriptor2).getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list3, "getValueParameters(...)");
                ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.first(list3);
                KotlinType kotlinType = parameterType = valueParameterDescriptor != null ? valueParameterDescriptor.getType() : null;
                if (parameterType != null) {
                    boolean bl;
                    block20: {
                        Iterable $this$any$iv = parameterType.getArguments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                TypeProjection it = (TypeProjection)element$iv;
                                boolean bl2 = false;
                                if (!(!it.isStarProjection())) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        BindingTrace bindingTrace = context2.getTrace();
                        KtTypeReference ktTypeReference = ((KtFunction)declaration2).getValueParameters().get(0).getTypeReference();
                        Intrinsics.checkNotNull(ktTypeReference);
                        bindingTrace.report(Errors.TYPE_ARGUMENT_ON_TYPED_VALUE_CLASS_EQUALS.on((KtTypeReference)((PsiElement)ktTypeReference)));
                    }
                }
            }
        } else if (declarationDescriptor2 instanceof ConstructorDescriptor && !context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ValueClassesSecondaryConstructorWithBody)) {
            KtSecondaryConstructor ktSecondaryConstructor = declaration2 instanceof KtSecondaryConstructor ? (KtSecondaryConstructor)declaration2 : null;
            if (ktSecondaryConstructor == null) {
                return;
            }
            KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
            KtBlockExpression bodyExpression = secondaryConstructor.getBodyExpression();
            if (secondaryConstructor.hasBlockBody() && bodyExpression != null) {
                PsiElement psiElement = bodyExpression.getLBrace();
                if (psiElement == null) {
                    return;
                }
                PsiElement lBrace = psiElement;
                context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(lBrace, TuplesKt.to(LanguageFeature.ValueClassesSecondaryConstructorWithBody, context2.getLanguageVersionSettings())));
            }
        }
    }

    static {
        String[] stringArray = new String[]{"box", "unbox"};
        boxAndUnboxNames = SetsKt.setOf(stringArray);
        stringArray = new String[]{"equals", "hashCode"};
        equalsAndHashCodeNames = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ReservedMembersAndConstructsForValueClass$Companion;", "", "()V", "boxAndUnboxNames", "", "", "equalsAndHashCodeNames", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

