/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.UtilsKt;
import org.jetbrains.kotlin.mpp.ClassLikeSymbolMarker;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u000f\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H&J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/mpp/ClassLikeSymbolMarker;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "rawStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "getRawStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "resolvedStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "getResolvedStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "typeParameterSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getTypeParameterSymbols", "()Ljava/util/List;", "getDeprecation", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "toLookupTag", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "toString", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "tree"})
@SourceDebugExtension(value={"SMAP\nFirClassLikeSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirClassLikeSymbol.kt\norg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1549#2:100\n1620#2,3:101\n*S KotlinDebug\n*F\n+ 1 FirClassLikeSymbol.kt\norg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol\n*L\n45#1:100\n45#1:101,3\n*E\n"})
public abstract class FirClassLikeSymbol<D extends FirClassLikeDeclaration>
extends FirClassifierSymbol<D>
implements ClassLikeSymbolMarker {
    @NotNull
    private final ClassId classId;

    private FirClassLikeSymbol(ClassId classId) {
        super(null);
        this.classId = classId;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @Override
    @NotNull
    public abstract ConeClassLikeLookupTag toLookupTag();

    @NotNull
    public final Name getName() {
        Name name2 = this.classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue(name2, "getShortClassName(...)");
        return name2;
    }

    @Nullable
    public final DeprecationsPerUseSite getDeprecation(@NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
        if (this.getAnnotations().isEmpty()) {
            return null;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        return ((FirClassLikeDeclaration)this.getFir()).getDeprecationsProvider().getDeprecationsInfo(apiVersion);
    }

    @NotNull
    public final FirDeclarationStatus getRawStatus() {
        return ((FirClassLikeDeclaration)this.getFir()).getStatus();
    }

    @NotNull
    public final FirResolvedDeclarationStatus getResolvedStatus() {
        return UtilsKt.resolvedStatus((FirMemberDeclaration)this.getFir());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> getTypeParameterSymbols() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((FirClassLikeDeclaration)this.getFir()).getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ' ' + this.classId.asString();
    }

    public /* synthetic */ FirClassLikeSymbol(ClassId classId, DefaultConstructorMarker $constructor_marker) {
        this(classId);
    }
}

