/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportIfUnderscore", "isSingleUnderscoreAllowed", "", "checkers"})
public final class FirReservedUnderscoreDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReservedUnderscoreDeclarationChecker INSTANCE = new FirReservedUnderscoreDeclarationChecker();

    private FirReservedUnderscoreDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block4: {
            block5: {
                block3: {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    if (!(declaration2 instanceof FirRegularClass) && !(declaration2 instanceof FirTypeParameter) && (!(declaration2 instanceof FirProperty) || Intrinsics.areEqual(ClassMembersKt.isCatchParameter((FirProperty)declaration2), true)) && !(declaration2 instanceof FirTypeAlias)) break block3;
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                    break block4;
                }
                if (!(declaration2 instanceof FirFunction)) break block5;
                if (declaration2 instanceof FirSimpleFunction) {
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration2, context2, reporter, false, 8, null);
                }
                boolean isSingleUnderscoreAllowed = declaration2 instanceof FirAnonymousFunction || declaration2 instanceof FirPropertyAccessor;
                for (FirValueParameter parameter2 : ((FirFunction)declaration2).getValueParameters()) {
                    this.reportIfUnderscore(parameter2, context2, reporter, isSingleUnderscoreAllowed);
                }
                break block4;
            }
            if (!(declaration2 instanceof FirFile)) break block4;
            for (FirImport firImport : ((FirFile)declaration2).getImports()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(firImport.getAliasSource(), context2, reporter, false);
            }
        }
    }

    private final void reportIfUnderscore(FirDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean isSingleUnderscoreAllowed) {
        FirTypeRef delegatedTypeRef;
        FirTypeRef returnOrReceiverTypeRef;
        FirTypeRef firTypeRef;
        Object $this$reportIfUnderscore_u24lambda_u240;
        KtSourceElement declarationSource = declaration2.getSource();
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind)) {
            String rawName;
            $this$reportIfUnderscore_u24lambda_u240 = SourceNavigator.Companion.forElement(declaration2);
            boolean bl = false;
            String string2 = rawName = $this$reportIfUnderscore_u24lambda_u240.getRawName(declaration2);
            boolean bl2 = string2 != null ? FirUnderscoreHelpersKt.isUnderscore(string2) : false;
            if (!(!bl2 || isSingleUnderscoreAllowed && Intrinsics.areEqual(rawName, "_"))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), (DiagnosticContext)context2, null, 8, null);
            }
        }
        if (($this$reportIfUnderscore_u24lambda_u240 = declaration2) instanceof FirValueParameter) {
            firTypeRef = ((FirValueParameter)declaration2).getReturnTypeRef();
        } else if ($this$reportIfUnderscore_u24lambda_u240 instanceof FirFunction) {
            FirReceiverParameter firReceiverParameter = ((FirFunction)declaration2).getReceiverParameter();
            firTypeRef = firReceiverParameter != null ? firReceiverParameter.getTypeRef() : null;
        } else {
            firTypeRef = returnOrReceiverTypeRef = null;
        }
        if (returnOrReceiverTypeRef instanceof FirResolvedTypeRef && (delegatedTypeRef = ((FirResolvedTypeRef)returnOrReceiverTypeRef).getDelegatedTypeRef()) instanceof FirUserTypeRef) {
            for (FirQualifierPart qualifierPart : ((FirUserTypeRef)delegatedTypeRef).getQualifier()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(qualifierPart.getSource(), context2, reporter, true);
                for (FirTypeProjection typeArgument : qualifierPart.getTypeArgumentList().getTypeArguments()) {
                    FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(typeArgument.getSource(), context2, reporter, true);
                }
            }
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(FirReservedUnderscoreDeclarationChecker firReservedUnderscoreDeclarationChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        firReservedUnderscoreDeclarationChecker.reportIfUnderscore(firDeclaration, checkerContext, diagnosticReporter, bl);
    }
}

