/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirExpectActualDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualCompatibility;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002JX\u0010\u0010\u001a\u00020\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122&\u0010\u0013\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00160\u00142\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010 \u001a\u00020\u00062\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00122\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u001c\u0010&\u001a\u00020\u000f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u00020\u000f*\u0012\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0002\b\u00030\u0014J\u0016\u0010*\u001a\u00020\u000f*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0015H\u0002\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkActualDeclarationHasExpected", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkActual", "", "checkAmbiguousExpects", "actualDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "compatibility", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualCompatibility;", "", "symbol", "checkExpectDeclarationHasNoExternalModifier", "checkExpectDeclarationModifiers", "checkExpectPropertyAccessorModifiers", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "checkExpectPropertyAccessorsModifiers", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias", "expectSymbol", "actualSymbol", "checkOptInAnnotation", "expectDeclarationSymbol", "containsExpectOrActualModifier", "requireActualModifier", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "allStrongIncompatibilities", "isCompatibleOrWeakCompatible", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n37#2:280\n36#2:281\n37#2:282\n36#2:283\n44#2:284\n45#2:285\n36#2:286\n819#3:287\n847#3,2:288\n766#3:292\n857#3:293\n1747#3,3:294\n858#3:297\n1726#3,3:298\n603#4:290\n1#5:291\n*S KotlinDebug\n*F\n+ 1 FirExpectActualDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectActualDeclarationChecker\n*L\n43#1:280\n43#1:281\n53#1:282\n57#1:283\n77#1:284\n109#1:285\n127#1:286\n160#1:287\n160#1:288,2\n233#1:292\n233#1:293\n233#1:294,3\n233#1:297\n247#1:298,3\n205#1:290\n*E\n"})
public final class FirExpectActualDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectActualDeclarationChecker INSTANCE = new FirExpectActualDeclarationChecker();

    private FirExpectActualDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block7: {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    if (!(declaration2 instanceof FirMemberDeclaration)) {
                        return;
                    }
                    if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.MultiPlatformProjects)) break block7;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) break block8;
                    FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration2;
                    boolean $i$f$isActual = false;
                    if (!$this$isActual$iv.getStatus().isActual()) break block9;
                }
                if (this.containsExpectOrActualModifier((FirMemberDeclaration)declaration2)) {
                    KtDiagnosticReportHelpersKt.reportOn(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION(), (DiagnosticContext)context2, (AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getEXPECT_ACTUAL_MODIFIER());
                }
            }
            return;
        }
        FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            this.checkExpectDeclarationModifiers((FirMemberDeclaration)declaration2, context2, reporter);
            this.checkOptInAnnotation((FirMemberDeclaration)declaration2, declaration2.getSymbol(), context2, reporter);
        }
        FirMemberDeclaration $this$isActual$iv = (FirMemberDeclaration)declaration2;
        boolean $i$f$isActual = false;
        if ($this$isActual$iv.getStatus().isActual()) {
            FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$default(this, (FirMemberDeclaration)declaration2, context2, reporter, false, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsExpectOrActualModifier(FirMemberDeclaration declaration2) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(declaration2.getSource());
        if (firModifierList == null) return false;
        FirModifierList modifiers2 = firModifierList;
        boolean bl = false;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "EXPECT_KEYWORD");
        if (modifiers2.contains(ktModifierKeywordToken)) return true;
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken2, "ACTUAL_KEYWORD");
        if (!modifiers2.contains(ktModifierKeywordToken2)) return false;
        return true;
    }

    private final void checkExpectDeclarationModifiers(FirMemberDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        this.checkExpectDeclarationHasNoExternalModifier(declaration2, context2, reporter);
        if (declaration2 instanceof FirProperty) {
            this.checkExpectPropertyAccessorsModifiers((FirProperty)declaration2, context2, reporter);
        }
        if (declaration2 instanceof FirFunction) {
            FirMemberDeclaration $this$isTailRec$iv = declaration2;
            boolean $i$f$isTailRec = false;
            if ($this$isTailRec$iv.getStatus().isTailRec()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPECTED_TAILREC_FUNCTION(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final void checkExpectPropertyAccessorsModifiers(FirProperty property, CheckerContext context2, DiagnosticReporter reporter) {
        FirPropertyAccessor[] firPropertyAccessorArray = new FirPropertyAccessor[]{property.getGetter(), property.getSetter()};
        for (FirPropertyAccessor accessor : CollectionsKt.listOfNotNull(firPropertyAccessorArray)) {
            this.checkExpectPropertyAccessorModifiers(accessor, context2, reporter);
        }
    }

    private final void checkExpectPropertyAccessorModifiers(FirPropertyAccessor accessor, CheckerContext context2, DiagnosticReporter reporter) {
        if (!FirExpectActualDeclarationChecker.checkExpectPropertyAccessorModifiers$isDefault(accessor)) {
            this.checkExpectDeclarationHasNoExternalModifier(accessor, context2, reporter);
        }
    }

    private final void checkExpectDeclarationHasNoExternalModifier(FirMemberDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirMemberDeclaration $this$isExternal$iv = declaration2;
        boolean $i$f$isExternal = false;
        if ($this$isExternal$iv.getStatus().isExternal()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPECTED_EXTERNAL_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualDeclarationHasExpected(FirMemberDeclaration declaration2, CheckerContext context2, DiagnosticReporter reporter, boolean checkActual) {
        FirBasedSymbol<?> expectedSingleCandidate;
        FirBasedSymbol<? extends FirDeclaration> symbol2 = declaration2.getSymbol();
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> map = ExpectActualAttributesKt.getExpectForActual(symbol2);
        if (map == null) {
            return;
        }
        Map<ExpectActualCompatibility<FirBasedSymbol<?>>, List<FirBasedSymbol<?>>> compatibilityToMembersMap = map;
        FirSession session = context2.getSession();
        this.checkAmbiguousExpects(symbol2, compatibilityToMembersMap, symbol2, context2, reporter);
        KtSourceElement source = declaration2.getSource();
        FirMemberDeclaration $this$isActual$iv = declaration2;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            if (this.allStrongIncompatibilities(compatibilityToMembersMap)) {
                return;
            }
            if (compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
                if (checkActual && this.requireActualModifier(symbol2, session)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_MISSING(), (DiagnosticContext)context2, null, 8, null);
                }
                return;
            }
        }
        ExpectActualCompatibility singleIncompatibility = (ExpectActualCompatibility)CollectionsKt.singleOrNull((Iterable)compatibilityToMembersMap.keySet());
        if (singleIncompatibility instanceof ExpectActualCompatibility.Incompatible.ClassScopes) {
            void $this$filterNotTo$iv$iv;
            if (!(symbol2 instanceof FirRegularClassSymbol || symbol2 instanceof FirTypeAliasSymbol)) {
                boolean $i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = false;
                String $i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22 = "Incompatible.ClassScopes is only possible for a class or a typealias: " + declaration2;
                throw new IllegalArgumentException($i$a$-require-FirExpectActualDeclarationChecker$checkActualDeclarationHasExpected$22.toString());
            }
            Iterable $this$filterNot$iv = ((ExpectActualCompatibility.Incompatible.ClassScopes)singleIncompatibility).getUnfulfilled();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Pair p0 = (Pair)element$iv$iv;
                boolean bl = false;
                if (FirExpectActualDeclarationChecker.checkActualDeclarationHasExpected$hasSingleActualSuspect(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonTrivialUnfulfilled = (List)destination$iv$iv;
            if (!((Collection)nonTrivialUnfulfilled).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ACTUAL_CLASS_MEMBER_FOR_EXPECTED_CLASS(), symbol2, (Object)nonTrivialUnfulfilled, (DiagnosticContext)context2, null, 32, null);
            }
        } else if (!compatibilityToMembersMap.containsKey(ExpectActualCompatibility.Compatible.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getACTUAL_WITHOUT_EXPECT(), symbol2, compatibilityToMembersMap, (DiagnosticContext)context2, null, 32, null);
        }
        if ((expectedSingleCandidate = ExpectActualAttributesKt.getSingleExpectForActualOrNull(symbol2)) != null) {
            this.checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias(expectedSingleCandidate, symbol2, context2, reporter);
            this.checkOptInAnnotation(declaration2, expectedSingleCandidate, context2, reporter);
        }
    }

    static /* synthetic */ void checkActualDeclarationHasExpected$default(FirExpectActualDeclarationChecker firExpectActualDeclarationChecker, FirMemberDeclaration firMemberDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        firExpectActualDeclarationChecker.checkActualDeclarationHasExpected(firMemberDeclaration, checkerContext, diagnosticReporter, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAmbiguousExpects(FirBasedSymbol<?> actualDeclaration, Map<ExpectActualCompatibility<FirBasedSymbol<?>>, ? extends List<? extends FirBasedSymbol<?>>> compatibility, FirBasedSymbol<?> symbol2, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$sortedBy$iv;
        Sequence sequence2 = SequencesKt.map(SequencesKt.flattenSequenceOfIterable(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence(compatibility), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.1.INSTANCE), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.2.INSTANCE)), checkAmbiguousExpects.filesWithAtLeastWeaklyCompatibleExpects.3.INSTANCE);
        boolean $i$f$sortedBy = false;
        List filesWithAtLeastWeaklyCompatibleExpects2 = SequencesKt.toList(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                FirModuleData it = (FirModuleData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName().asString());
                it = (FirModuleData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName().asString()));
            }
        }));
        if (filesWithAtLeastWeaklyCompatibleExpects2.size() > 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)actualDeclaration.getSource(), FirErrors.INSTANCE.getAMBIGUOUS_EXPECTS(), symbol2, filesWithAtLeastWeaklyCompatibleExpects2, (DiagnosticContext)context2, null, 32, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias(FirBasedSymbol<?> expectSymbol, FirBasedSymbol<?> actualSymbol, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (!(expectSymbol instanceof FirClassSymbol) || !(actualSymbol instanceof FirTypeAliasSymbol) || ((FirClassSymbol)expectSymbol).getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirContainingNamesAwareScope $this$checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias_u24lambda_u243 = FirDeclaredMemberScopeProviderKt.declaredMemberScope((FirClassSymbol)expectSymbol, expectSymbol.getModuleData().getSession(), null);
        boolean $i$a$-run-FirExpectActualDeclarationChecker$checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias$membersWithDefaultValueParameters$22 = false;
        Iterable iterable = CollectionsKt.plus(FirContainingNamesAwareScopeKt.collectAllFunctions($this$checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias_u24lambda_u243), (Iterable)FirScopeKt.getDeclaredConstructors($this$checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias_u24lambda_u243));
        boolean $i$f$filter = false;
        void $i$a$-run-FirExpectActualDeclarationChecker$checkIfExpectHasDefaultArgumentsAndActualizedWithTypealias$membersWithDefaultValueParameters$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = it.getValueParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirValueParameterSymbol p0 = (FirValueParameterSymbol)element$iv;
                        boolean bl3 = false;
                        if (!p0.getHasDefaultValue()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List membersWithDefaultValueParameters = (List)destination$iv$iv;
        if (membersWithDefaultValueParameters.isEmpty()) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)actualSymbol.getSource(), FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_WITH_ACTUAL_TYPEALIAS(), expectSymbol, (Object)membersWithDefaultValueParameters, (DiagnosticContext)context2, null, 32, null);
    }

    public final boolean allStrongIncompatibilities(@NotNull Map<? extends ExpectActualCompatibility<?>, ?> $this$allStrongIncompatibilities) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$allStrongIncompatibilities, "<this>");
            Iterable $this$all$iv = $this$allStrongIncompatibilities.keySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ExpectActualCompatibility it = (ExpectActualCompatibility)element$iv;
                    boolean bl2 = false;
                    if (it instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)it).getKind() == ExpectActualCompatibility.IncompatibilityKind.STRONG) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isCompatibleOrWeakCompatible(ExpectActualCompatibility<? extends FirBasedSymbol<?>> $this$isCompatibleOrWeakCompatible) {
        return $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Compatible || $this$isCompatibleOrWeakCompatible instanceof ExpectActualCompatibility.Incompatible && ((ExpectActualCompatibility.Incompatible)$this$isCompatibleOrWeakCompatible).getKind() == ExpectActualCompatibility.IncompatibilityKind.WEAK;
    }

    private final boolean requireActualModifier(FirBasedSymbol<?> declaration2, FirSession session) {
        return !DeclarationUtilsKt.isAnnotationConstructor(declaration2, session) && !DeclarationUtilsKt.isPrimaryConstructorOfInlineOrValueClass(declaration2, session);
    }

    private final void checkOptInAnnotation(FirMemberDeclaration declaration2, FirBasedSymbol<?> expectDeclarationSymbol, CheckerContext context2, DiagnosticReporter reporter) {
        if (declaration2 instanceof FirClass && ((FirClass)declaration2).getClassKind() == ClassKind.ANNOTATION_CLASS && !FirAnnotationUtilsKt.hasAnnotation(expectDeclarationSymbol, StandardClassIds.Annotations.INSTANCE.getOptionalExpectation(), context2.getSession()) && FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)declaration2, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getEXPECT_ACTUAL_OPT_IN_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final boolean checkExpectPropertyAccessorModifiers$isDefault(FirPropertyAccessor $this$checkExpectPropertyAccessorModifiers_u24isDefault) {
        KtSourceElement ktSourceElement = $this$checkExpectPropertyAccessorModifiers_u24isDefault.getSource();
        return Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.DefaultAccessor.INSTANCE);
    }

    private static final boolean checkActualDeclarationHasExpected$hasSingleActualSuspect(Pair<? extends FirBasedSymbol<?>, ? extends Map<ExpectActualCompatibility.Incompatible<FirBasedSymbol<?>>, ? extends Collection<? extends FirBasedSymbol<?>>>> expectedWithIncompatibility) {
        Object object;
        FirBasedSymbol actualMember;
        FirBasedSymbol<?> expectedMember = expectedWithIncompatibility.component1();
        Map<ExpectActualCompatibility.Incompatible<FirBasedSymbol<?>>, Collection<FirBasedSymbol<?>>> incompatibility = expectedWithIncompatibility.component2();
        Collection collection = (Collection)CollectionsKt.singleOrNull((Iterable)incompatibility.values());
        FirBasedSymbol firBasedSymbol = actualMember = collection != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(collection) : null;
        return actualMember != null && !INSTANCE.allStrongIncompatibilities(incompatibility) && Intrinsics.areEqual((object = ExpectActualAttributesKt.getExpectForActual(actualMember.getFir())) != null && (object = object.values()) != null && (object = (List)CollectionsKt.singleOrNull((Iterable)object)) != null ? (FirBasedSymbol)CollectionsKt.singleOrNull(object) : null, expectedMember);
    }

    public static final /* synthetic */ boolean access$isCompatibleOrWeakCompatible(FirExpectActualDeclarationChecker $this, ExpectActualCompatibility $receiver) {
        return $this.isCompatibleOrWeakCompatible($receiver);
    }
}

