/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.components;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.calls.KtCompoundAccess;
import org.jetbrains.kotlin.analysis.api.calls.KtExplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.components.KtCallResolver;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0004J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0004J\f\u0010\r\u001a\u00020\u0004*\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/components/AbstractKtCallResolver;", "Lorg/jetbrains/kotlin/analysis/api/components/KtCallResolver;", "()V", "canBeResolvedAsCall", "", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getCompoundAssignKind", "Lorg/jetbrains/kotlin/analysis/api/calls/KtCompoundAccess$CompoundAssign$Kind;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getInOrDecOperationKind", "Lorg/jetbrains/kotlin/analysis/api/calls/KtCompoundAccess$IncOrDecOperation$Kind;", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "isReceiverOfKtSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "toExplicitReceiverValue", "Lorg/jetbrains/kotlin/analysis/api/calls/KtExplicitReceiverValue;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KtType;", "Companion", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nAbstractKtCallResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKtCallResolver.kt\norg/jetbrains/kotlin/analysis/api/impl/base/components/AbstractKtCallResolver\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/analysis/utils/printer/PsiUtilsKt\n*L\n1#1,63:1\n13#2,2:64\n*S KotlinDebug\n*F\n+ 1 AbstractKtCallResolver.kt\norg/jetbrains/kotlin/analysis/api/impl/base/components/AbstractKtCallResolver\n*L\n44#1:64,2\n*E\n"})
public abstract class AbstractKtCallResolver
extends KtCallResolver {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<KtSingleValueToken> nonCallBinaryOperator;

    @NotNull
    protected final KtCompoundAccess.CompoundAssign.Kind getCompoundAssignKind(@NotNull KtBinaryExpression $this$getCompoundAssignKind) {
        KtCompoundAccess.CompoundAssign.Kind kind;
        Intrinsics.checkNotNullParameter($this$getCompoundAssignKind, "<this>");
        IElementType iElementType = $this$getCompoundAssignKind.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.PLUSEQ)) {
            kind = KtCompoundAccess.CompoundAssign.Kind.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.MINUSEQ)) {
            kind = KtCompoundAccess.CompoundAssign.Kind.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.MULTEQ)) {
            kind = KtCompoundAccess.CompoundAssign.Kind.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.PERCEQ)) {
            kind = KtCompoundAccess.CompoundAssign.Kind.REM_ASSIGN;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.DIVEQ)) {
            kind = KtCompoundAccess.CompoundAssign.Kind.DIV_ASSIGN;
        } else {
            throw new IllegalStateException(("unexpected operator " + $this$getCompoundAssignKind.getOperationToken()).toString());
        }
        KtCompoundAccess.CompoundAssign.Kind compoundAssignKind = kind;
        return compoundAssignKind;
    }

    @NotNull
    protected final KtCompoundAccess.IncOrDecOperation.Kind getInOrDecOperationKind(@NotNull KtUnaryExpression $this$getInOrDecOperationKind) {
        KtCompoundAccess.IncOrDecOperation.Kind kind;
        Intrinsics.checkNotNullParameter($this$getInOrDecOperationKind, "<this>");
        IElementType iElementType = $this$getInOrDecOperationKind.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.PLUSPLUS)) {
            kind = KtCompoundAccess.IncOrDecOperation.Kind.INC;
        } else if (Intrinsics.areEqual(iElementType, KtTokens.MINUSMINUS)) {
            kind = KtCompoundAccess.IncOrDecOperation.Kind.DEC;
        } else {
            throw new IllegalStateException(("unexpected operator " + $this$getInOrDecOperationKind.getOperationToken()).toString());
        }
        KtCompoundAccess.IncOrDecOperation.Kind incOrDecOperationKind = kind;
        return incOrDecOperationKind;
    }

    @NotNull
    protected final KtExplicitReceiverValue toExplicitReceiverValue(@NotNull KtExpression $this$toExplicitReceiverValue, @NotNull KtType type2) {
        Intrinsics.checkNotNullParameter($this$toExplicitReceiverValue, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        return new KtExplicitReceiverValue($this$toExplicitReceiverValue, type2, this.isReceiverOfKtSafeQualifiedExpression($this$toExplicitReceiverValue), this.getToken());
    }

    private final boolean isReceiverOfKtSafeQualifiedExpression(KtExpression $this$isReceiverOfKtSafeQualifiedExpression) {
        PsiElement $this$parentOfType_u24default$iv = $this$isReceiverOfKtSafeQualifiedExpression;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtSafeQualifiedExpression ktSafeQualifiedExpression = PsiTreeUtil.getParentOfType($this$parentOfType_u24default$iv, KtSafeQualifiedExpression.class, true);
        if (ktSafeQualifiedExpression == null) {
            return false;
        }
        KtSafeQualifiedExpression safeQualifiedExpression = ktSafeQualifiedExpression;
        return Intrinsics.areEqual(KtPsiUtil.deparenthesize(safeQualifiedExpression.getReceiverExpression()), KtPsiUtil.deparenthesize($this$isReceiverOfKtSafeQualifiedExpression));
    }

    protected final boolean canBeResolvedAsCall(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter(ktElement, "ktElement");
        KtElement ktElement2 = ktElement;
        return ktElement2 instanceof KtBinaryExpression ? !CollectionsKt.contains((Iterable)nonCallBinaryOperator, ((KtBinaryExpression)ktElement).getOperationToken()) : (ktElement2 instanceof KtOperationReferenceExpression ? !CollectionsKt.contains((Iterable)nonCallBinaryOperator, ((KtOperationReferenceExpression)ktElement).getOperationSignTokenType()) : (ktElement2 instanceof KtCallElement ? true : (ktElement2 instanceof KtConstructorCalleeExpression ? true : (ktElement2 instanceof KtDotQualifiedExpression ? true : (ktElement2 instanceof KtNameReferenceExpression ? true : (ktElement2 instanceof KtOperationExpression ? true : ktElement2 instanceof KtArrayAccessExpression))))));
    }

    static {
        KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.ELVIS, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ};
        nonCallBinaryOperator = SetsKt.setOf(ktSingleValueTokenArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/components/AbstractKtCallResolver$Companion;", "", "()V", "nonCallBinaryOperator", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "analysis-api-impl-base"})
    protected static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

