/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.interpretation.CallsEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionalEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConstantValuesInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.EffectDeclarationInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ReturnsEffectInterpreter;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.contracts.model.functors.SubstitutingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "", "()V", "conditionInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "conditionalEffectInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionalEffectInterpreter;", "constantsInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConstantValuesInterpreter;", "effectsInterpreters", "", "Lorg/jetbrains/kotlin/contracts/interpretation/EffectDeclarationInterpreter;", "convertContractDescriptorToFunctor", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "contractDescription", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "interpretCondition", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "booleanExpression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "interpretCondition$resolution", "interpretConstant", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "interpretConstant$resolution", "interpretEffect", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "interpretEffect$resolution", "interpretVariable", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "variableReference", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "interpretVariable$resolution", "resolution"})
@SourceDebugExtension(value={"SMAP\nContractInterpretationDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractInterpretationDispatcher.kt\norg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,2:71\n1603#2,9:73\n1855#2:82\n1856#2:84\n1612#2:85\n1622#2:86\n1603#2,9:87\n1855#2:96\n1856#2:98\n1612#2:99\n1#3:83\n1#3:97\n*S KotlinDebug\n*F\n+ 1 ContractInterpretationDispatcher.kt\norg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher\n*L\n45#1:70\n45#1:71,2\n49#1:73,9\n49#1:82\n49#1:84\n49#1:85\n45#1:86\n57#1:87,9\n57#1:96\n57#1:98\n57#1:99\n49#1:83\n57#1:97\n*E\n"})
public final class ContractInterpretationDispatcher {
    @NotNull
    private final ConstantValuesInterpreter constantsInterpreter = new ConstantValuesInterpreter();
    @NotNull
    private final ConditionInterpreter conditionInterpreter = new ConditionInterpreter(this);
    @NotNull
    private final ConditionalEffectInterpreter conditionalEffectInterpreter = new ConditionalEffectInterpreter(this);
    @NotNull
    private final List<EffectDeclarationInterpreter> effectsInterpreters;

    public ContractInterpretationDispatcher() {
        EffectDeclarationInterpreter[] effectDeclarationInterpreterArray = new EffectDeclarationInterpreter[]{new ReturnsEffectInterpreter(this), new CallsEffectInterpreter(this)};
        this.effectsInterpreters = CollectionsKt.listOf(effectDeclarationInterpreterArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Functor convertContractDescriptorToFunctor(@NotNull ContractDescription contractDescription) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractDescription, "contractDescription");
        Iterable $this$map$iv = contractDescription.getEffects();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ESEffect eSEffect;
            void effect;
            EffectDeclaration effectDeclaration = (EffectDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (effect instanceof ConditionalEffectDeclaration) {
                ConditionalEffect conditionalEffect = this.conditionalEffectInterpreter.interpret((ConditionalEffectDeclaration)effect);
                if (conditionalEffect == null) {
                    return null;
                }
                eSEffect = conditionalEffect;
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.effectsInterpreters;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ESEffect it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
                    boolean bl3 = false;
                    if (it.tryInterpret((EffectDeclaration)effect) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                eSEffect = (ESEffect)CollectionsKt.singleOrNull((List)destination$iv$iv2);
                if (eSEffect == null) {
                    return null;
                }
            }
            collection.add(eSEffect);
        }
        List resultingClauses = (List)destination$iv$iv;
        return new SubstitutingFunctor(resultingClauses, contractDescription.getOwnerFunction());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ESEffect interpretEffect$resolution(@NotNull EffectDeclaration effectDeclaration) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(effectDeclaration, "effectDeclaration");
        Iterable $this$mapNotNull$iv = this.effectsInterpreters;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ESEffect it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
            boolean bl2 = false;
            if (it.tryInterpret(effectDeclaration) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedFunctors = (List)destination$iv$iv;
        return (ESEffect)CollectionsKt.singleOrNull(convertedFunctors);
    }

    @Nullable
    public final ESConstant interpretConstant$resolution(@NotNull ConstantReference constantReference) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        return this.constantsInterpreter.interpretConstant(constantReference);
    }

    @Nullable
    public final ESExpression interpretCondition$resolution(@NotNull BooleanExpression booleanExpression) {
        Intrinsics.checkNotNullParameter(booleanExpression, "booleanExpression");
        return (ESExpression)booleanExpression.accept(this.conditionInterpreter, Unit.INSTANCE);
    }

    @Nullable
    public final ESVariable interpretVariable$resolution(@NotNull VariableReference variableReference) {
        Intrinsics.checkNotNullParameter(variableReference, "variableReference");
        return new ESVariable(variableReference.getDescriptor());
    }
}

