/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.renderer;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B!\b\u0016\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRendererWithJavaFlexibleTypes;", "Lorg/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "idRendererCreator", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "(Lkotlin/jvm/functions/Function0;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "renderFlexibleType", "", "lowerRendered", "upperRendered", "cones"})
public final class ConeTypeRendererWithJavaFlexibleTypes
extends ConeTypeRenderer {
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererWithJavaFlexibleTypes(@NotNull Function0<? extends ConeIdRenderer> idRendererCreator2) {
        Intrinsics.checkNotNullParameter(idRendererCreator2, "idRendererCreator");
        this.idRendererCreator = idRendererCreator2;
    }

    public ConeTypeRendererWithJavaFlexibleTypes(@NotNull StringBuilder builder2, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator2) {
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(idRendererCreator2, "idRendererCreator");
        this.setBuilder(builder2);
        this.idRendererCreator = idRendererCreator2;
        this.setIdRenderer(idRendererCreator2.invoke());
        this.getIdRenderer().setBuilder(builder2);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter(flexibleType, "flexibleType");
        ConeTypeRendererWithJavaFlexibleTypes lowerRenderer = new ConeTypeRendererWithJavaFlexibleTypes(new StringBuilder(), this.idRendererCreator);
        lowerRenderer.render(flexibleType.getLowerBound());
        ConeTypeRendererWithJavaFlexibleTypes upperRenderer = new ConeTypeRendererWithJavaFlexibleTypes(new StringBuilder(), this.idRendererCreator);
        upperRenderer.render(flexibleType.getUpperBound());
        StringBuilder stringBuilder = this.getBuilder();
        String string2 = lowerRenderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String string3 = upperRenderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        stringBuilder.append(this.renderFlexibleType(string2, string3));
    }

    private final String renderFlexibleType(String lowerRendered, String upperRendered) {
        String array;
        String mutableEntry;
        String simpleCollection;
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default(upperRendered, "(", false, 2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String kotlinCollectionsPrefix = stringBuilder.append(StringsKt.replace$default(string2, ".", "/", false, 4, null)).append('/').toString();
        String mutablePrefix = "Mutable";
        String string3 = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string3 != null) {
            return string3;
        }
        String string4 = mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string4 != null) {
            return string4;
        }
        String kotlinPrefix = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '/';
        String string5 = array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + "Array<", upperRendered, kotlinPrefix + "Array<out ", kotlinPrefix + "Array<(out) ");
        if (string5 != null) {
            return string5;
        }
        return "ft<" + lowerRendered + ", " + upperRendered + '>';
    }

    @Override
    protected void render(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        this.render(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
    }
}

