/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.FactoryMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance(JavaMethodsConflictResolver.class);
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;
    @NotNull
    private final PsiFile myContainingFile;

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel, @NotNull PsiFile containingFile2) {
        if (argumentsList == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(0);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(1);
        }
        if (containingFile2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(2);
        }
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
        this.myContainingFile = containingFile2;
    }

    @Override
    public final CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(3);
        }
        if (this.myArgumentsList instanceof PsiExpressionList && MethodCandidateInfo.isOverloadCheck(this.myArgumentsList)) {
            LOG.error("Recursive conflict resolution for:" + this.myArgumentsList.getParent() + "; file=" + this.myArgumentsList.getContainingFile());
        }
        return this.guardedOverloadResolution(conflicts);
    }

    @Nullable
    protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(4);
        }
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkStaticMethodsOfInterfaces(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        Map<MethodCandidateInfo, PsiSubstitutor> map = FactoryMap.create(key -> key.getSubstitutor(false));
        boolean atLeastOneMatch = this.checkParametersNumber(conflicts, this.getActualParametersLength(), map, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSameSignatures(conflicts, map);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkParametersNumber(conflicts, this.getActualParametersLength(), map, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (atLeastOneMatch) {
            JavaMethodsConflictResolver.checkPotentiallyCompatibleMethods(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
        }
        int applicabilityLevel = this.checkApplicability(conflicts, map);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel, map, 0);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.getActualParametersLength());
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        HashSet<CandidateInfo> uniques = new HashSet<CandidateInfo>(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    private static void checkPotentiallyCompatibleMethods(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(5);
        }
        ArrayList<CandidateInfo> partiallyApplicable = new ArrayList<CandidateInfo>();
        Iterator<CandidateInfo> iterator2 = conflicts.iterator();
        while (iterator2.hasNext()) {
            CandidateInfo conflict = iterator2.next();
            if (!(conflict instanceof MethodCandidateInfo)) continue;
            ThreeState compatible = ((MethodCandidateInfo)conflict).isPotentiallyCompatible();
            if (compatible == ThreeState.NO) {
                iterator2.remove();
                continue;
            }
            if (compatible != ThreeState.UNSURE) continue;
            partiallyApplicable.add(conflict);
        }
        if (conflicts.size() > partiallyApplicable.size()) {
            conflicts.removeAll(partiallyApplicable);
        }
    }

    protected void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(6);
        }
        this.checkSpecifics(conflicts, applicabilityLevel, null, 0);
    }

    protected void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, Map<MethodCandidateInfo, PsiSubstitutor> map, int offset) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(7);
        }
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(CandidateInfo.EMPTY_ARRAY);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.nonComparable(method, conflict, applicabilityLevel == 3)) continue;
                    switch (this.isMoreSpecific((MethodCandidateInfo)method, (MethodCandidateInfo)conflict, applicabilityLevel, map, offset)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(8);
        }
        if (conflict == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(9);
        }
        assert (method != conflict);
        return false;
    }

    protected static void checkAccessStaticLevels(@NotNull List<? extends CandidateInfo> conflicts, boolean checkAccessible) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(10);
        }
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index2 = 0;
        for (CandidateInfo candidateInfo : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)candidateInfo;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index2++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    protected void checkSameSignatures(@NotNull List<? extends CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(11);
        }
        this.checkSameSignatures(conflicts, null);
    }

    protected void checkSameSignatures(@NotNull List<? extends CandidateInfo> conflicts, Map<MethodCandidateInfo, PsiSubstitutor> map) {
        PsiMethod method;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(12);
        }
        HashMap<MethodSignature, CandidateInfo> signatures2 = new HashMap<MethodSignature, CandidateInfo>(conflicts.size());
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        GlobalSearchScope resolveScope2 = ResolveScopeManager.getInstance(this.myContainingFile.getProject()).getResolveScope(this.myContainingFile);
        for (CandidateInfo candidateInfo : conflicts) {
            method = ((MethodCandidateInfo)candidateInfo).getElement();
            PsiClass containingClass = method.getContainingClass();
            boolean isInterface = containingClass != null && containingClass.isInterface();
            for (HierarchicalMethodSignature methodSignature : PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method, resolveScope2).getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                if (!isInterface) {
                    superMethods.add(superMethod);
                    continue;
                }
                PsiClass aClass = superMethod.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo candidateInfo = conflicts.get(i);
            method = (PsiMethod)candidateInfo.getElement();
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)candidateInfo, map);
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures2.get(signature);
            if (existing == null) {
                signatures2.put(signature, candidateInfo);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1 != null && existingClass != null) {
                if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                    signatures2.put(signature, candidateInfo);
                    continue;
                }
                if (existingClass.isInterface() && "java.lang.Object".equals(class1.getQualifiedName())) {
                    conflicts.remove(candidateInfo);
                    --i;
                    continue;
                }
            }
            if (method != existingMethod) continue;
            PsiElement scope1 = candidateInfo.getCurrentFileResolveScope();
            PsiElement scope2 = existing.getCurrentFileResolveScope();
            if (!(scope1 instanceof PsiClass) || !(scope2 instanceof PsiClass) || !PsiTreeUtil.isAncestor(scope1, scope2, true) || existing.isAccessible()) continue;
            signatures2.put(signature, candidateInfo);
        }
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(MethodCandidateInfo existing, Map<MethodCandidateInfo, PsiSubstitutor> map) {
        PsiSubstitutor psiSubstitutor = map != null ? map.get(existing) : existing.getSubstitutor(false);
        if (psiSubstitutor == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(13);
        }
        return psiSubstitutor;
    }

    private void checkStaticMethodsOfInterfaces(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(14);
        }
        if (!(this.myArgumentsList instanceof PsiExpressionList)) {
            return;
        }
        Iterator<CandidateInfo> iterator2 = conflicts.iterator();
        while (iterator2.hasNext()) {
            PsiClass qualifierClass;
            PsiClass containingClass;
            PsiElement currentFileResolveScope;
            PsiMethod method;
            CandidateInfo conflict = iterator2.next();
            if (!(conflict instanceof MethodCandidateInfo) || !(method = ((MethodCandidateInfo)conflict).getElement()).hasModifierProperty("static") || (currentFileResolveScope = conflict.getCurrentFileResolveScope()) instanceof PsiImportStaticStatement || (containingClass = method.getContainingClass()) == null || !containingClass.isInterface() || (qualifierClass = this.getQualifiedClass(currentFileResolveScope)) == null || containingClass.getManager().areElementsEquivalent(containingClass, qualifierClass)) continue;
            iterator2.remove();
        }
    }

    private PsiClass getQualifiedClass(PsiElement resolveScope2) {
        PsiElement parent2 = this.myArgumentsList.getParent();
        if (parent2 instanceof PsiMethodCallExpression) {
            PsiExpression expression2 = ((PsiMethodCallExpression)parent2).getMethodExpression().getQualifierExpression();
            if (expression2 instanceof PsiReferenceExpression) {
                PsiElement resolve2 = ((PsiReferenceExpression)expression2).resolve();
                if (resolve2 instanceof PsiClass) {
                    return (PsiClass)resolve2;
                }
            } else if (expression2 == null && resolveScope2 instanceof PsiClass) {
                return (PsiClass)resolveScope2;
            }
            if (expression2 != null) {
                return PsiUtil.resolveClassInType(expression2.getType());
            }
        }
        return null;
    }

    private boolean checkParametersNumber(@NotNull List<? extends CandidateInfo> conflicts, int argumentsCount, Map<MethodCandidateInfo, PsiSubstitutor> map, boolean ignoreIfStaticsProblem) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(15);
        }
        boolean atLeastOneMatch = false;
        List unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            boolean isVarargs;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            boolean bl = (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? ((MethodCandidateInfo)info).isVarargs() : method.isVarArgs()) && parametersCount - 1 <= argumentsCount ? true : (isVarargs = false);
            if (isVarargs || parametersCount == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        MethodCandidateInfo candidateInfo;
                        PsiMethod candidateToRemove;
                        int index2 = unmatchedIndices.getInt(u);
                        if (ignoreIfStaticsProblem && isVarargs && (candidateToRemove = (candidateInfo = (MethodCandidateInfo)conflicts.get(index2)).getElement()) != method) {
                            PsiSubstitutor candidateToRemoveSubst = map.get(candidateInfo);
                            PsiSubstitutor substitutor2 = map.get(info);
                            if (MethodSignatureUtil.isSubsignature(candidateToRemove.getSignature(candidateToRemoveSubst), method.getSignature(substitutor2))) continue;
                        }
                        conflicts.remove(index2);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new IntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(16);
        }
        return this.checkApplicability(conflicts, null);
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts, Map<MethodCandidateInfo, PsiSubstitutor> map) {
        int level;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(17);
        }
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)conflict, map);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator2 = conflicts.iterator();
            while (iterator2.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator2.next();
                level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)info, map);
                if (level >= maxApplicabilityLevel) continue;
                iterator2.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict, Map<MethodCandidateInfo, PsiSubstitutor> map) {
        if (conflict == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(18);
        }
        return conflict.getPertinentApplicabilityLevel(map);
    }

    private static int getCheckAccessLevel(@NotNull MethodCandidateInfo method) {
        boolean visible;
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(19);
        }
        return (visible = method.isAccessible()) ? 1 : 0;
    }

    private static int getCheckStaticLevel(@NotNull MethodCandidateInfo method) {
        boolean available;
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(20);
        }
        return ((available = method.isStaticsScopeCorrect()) ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private int getActualParametersLength() {
        if (this.myActualParameterTypes == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, this.myArgumentsList);
            return ((PsiExpressionList)this.myArgumentsList).getExpressionCount();
        }
        return this.myActualParameterTypes.length;
    }

    private Specifics isMoreSpecific(@NotNull MethodCandidateInfo info1, @NotNull MethodCandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, Map<MethodCandidateInfo, PsiSubstitutor> map, int offset) {
        boolean varargs2;
        boolean varargs1;
        if (info1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(21);
        }
        if (info2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(22);
        }
        PsiMethod method1 = info1.getElement();
        PsiMethod method2 = info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = JavaMethodsConflictResolver.getSubstitutor(info1, map);
        PsiSubstitutor classSubstitutor2 = JavaMethodsConflictResolver.getSubstitutor(info2, map);
        int argsLength = this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method1.isVarArgs() || method2.isVarArgs()) ? this.getActualParametersLength() : 0;
        int max = Math.max(Math.max(params1.length, params2.length), argsLength);
        PsiType[] types1 = PsiType.createArray(max);
        PsiType[] types2 = PsiType.createArray(max);
        boolean[] varargs = new boolean[max];
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType2 = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && (class1 != null && !JavaVersionService.getInstance().isAtLeast(class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                    varargs[i] = true;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        boolean sameBoxing = true;
        boolean[] boxingHappened = new boolean[2];
        PsiExpression[] args2 = this.myArgumentsList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentsList).getExpressions() : null;
        for (int i = 0; i < types1.length; ++i) {
            PsiType argType;
            ProgressManager.checkCanceled();
            if (varargs[i]) continue;
            PsiExpression arg = args2 != null && i < args2.length ? args2[i] : null;
            PsiType psiType3 = argType = this.myActualParameterTypes != null && i + offset < this.getActualParametersLength() ? this.myActualParameterTypes[i + offset] : null;
            if (arg == null && argType == null) continue;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor1.substitute(types1[i]), argType, arg)) {
                boxingHappened[0] = true;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor2.substitute(types2[i]), argType, arg)) {
                boxingHappened[1] = true;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (!boxingHappened[0] && boxingHappened[1]) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] && !boxingHappened[1]) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor = this.getSiteSubstitutor(info1).putAll(this.getSiteSubstitutor(info2));
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor, types1, types2AtSite, this.myLanguageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, this.myLanguageLevel, varargsPosition, methodSubstitutor1, method2, siteSubstitutor);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor, types2, types1AtSite, this.myLanguageLevel);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, this.myLanguageLevel, varargsPosition, methodSubstitutor2, method1, siteSubstitutor);
            if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                boolean typeArgsApplicable12 = GenericsUtil.isTypeArgumentsApplicable(typeParameters1, methodSubstitutor1, this.myArgumentsList, !applicable21);
                boolean typeArgsApplicable21 = GenericsUtil.isTypeArgumentsApplicable(typeParameters2, methodSubstitutor2, this.myArgumentsList, !applicable12);
                if (!typeArgsApplicable12) {
                    applicable12 = false;
                }
                if (!typeArgsApplicable21) {
                    applicable21 = false;
                }
            }
            if (applicable12 || applicable21) {
                boolean abstract2;
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (!applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract") || method1.hasModifierProperty("default");
                boolean bl = abstract2 = method2.hasModifierProperty("abstract") || method2.hasModifierProperty("default");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
                if (abstract1 && MethodSignatureUtil.areOverrideEquivalent(method1, method2)) {
                    PsiType returnType1 = siteSubstitutor.substitute(method1.getReturnType());
                    PsiType returnType2 = siteSubstitutor.substitute(method2.getReturnType());
                    if (returnType1 != null && returnType2 != null && returnType1.isAssignableFrom(returnType2)) {
                        return Specifics.SECOND;
                    }
                    return Specifics.FIRST;
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable(lastParamType2, lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable(lastParamType1, lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2 && (method1.hasModifierProperty("static") || method2.hasModifierProperty("static"))) {
            if (class2.isInheritor(class1, true)) {
                if (MethodSignatureUtil.isSubsignature(method1.getSignature(classSubstitutor1), method2.getSignature(classSubstitutor2))) {
                    return Specifics.SECOND;
                }
            } else if (class1.isInheritor(class2, true) && MethodSignatureUtil.isSubsignature(method2.getSignature(classSubstitutor2), method1.getSignature(classSubstitutor1))) {
                return Specifics.FIRST;
            }
        }
        if ((varargs1 = info1.isVarargs()) != (varargs2 = info2.isVarargs())) {
            return varargs1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private PsiSubstitutor getSiteSubstitutor(@NotNull MethodCandidateInfo info) {
        if (info == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(23);
        }
        PsiSubstitutor siteSubstitutor = info.getSiteSubstitutor();
        if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return siteSubstitutor;
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        PsiClass containingClass = info.getElement().getContainingClass();
        if (containingClass != null) {
            for (PsiTypeParameter param : PsiUtil.typeParametersIterable(containingClass)) {
                substitutor2 = substitutor2.put(param, siteSubstitutor.substitute(param));
            }
        }
        return substitutor2;
    }

    private static boolean isBoxingUsed(PsiType parameterType, @Nullable PsiType argType, PsiExpression arg) {
        ProgressManager.checkCanceled();
        boolean isExpressionTypePrimitive = argType != null ? argType instanceof PsiPrimitiveType : PsiPolyExpressionUtil.isExpressionOfPrimitiveType(arg);
        return parameterType instanceof PsiPrimitiveType != isExpressionTypePrimitive;
    }

    private boolean isApplicableTo(PsiType @NotNull [] types2AtSite, @NotNull PsiMethod method1, @NotNull LanguageLevel languageLevel, boolean varargsPosition, @NotNull PsiSubstitutor methodSubstitutor1, @NotNull PsiMethod method2, PsiSubstitutor siteSubstitutor) {
        PsiElement parent2;
        if (method1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(24);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(25);
        }
        if (methodSubstitutor1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(26);
        }
        if (method2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(27);
        }
        if (types2AtSite == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(28);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && method1.getTypeParameters().length > 0 && this.myArgumentsList instanceof PsiExpressionList && (parent2 = this.myArgumentsList.getParent()) instanceof PsiCallExpression) {
            return InferenceSession.isMoreSpecific(method2, method1, siteSubstitutor, ((PsiExpressionList)this.myArgumentsList).getExpressions(), this.myArgumentsList, varargsPosition);
        }
        PsiUtil.ApplicabilityChecker applicabilityChecker = (left, right, allowUncheckedConversion, argId) -> {
            PsiClass rightClass;
            if (right instanceof PsiClassType && (rightClass = ((PsiClassType)right).resolve()) instanceof PsiTypeParameter) {
                right = new PsiImmediateClassType(rightClass, siteSubstitutor);
            }
            return languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? this.isTypeMoreSpecific(left, right, argId) : TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion);
        };
        int applicabilityLevel = PsiUtil.getApplicabilityLevel(method1, methodSubstitutor1, types2AtSite, languageLevel, false, varargsPosition, applicabilityChecker);
        return applicabilityLevel > 1;
    }

    private boolean isTypeMoreSpecific(PsiType left, PsiType right, int argId) {
        PsiExpression[] expressions;
        if (TypeConversionUtil.isAssignable(left, right, false)) {
            return true;
        }
        if (this.myArgumentsList instanceof PsiExpressionList && argId < (expressions = ((PsiExpressionList)this.myArgumentsList).getExpressions()).length) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(expressions[argId], right, left);
        }
        return false;
    }

    private static PsiType @NotNull [] typesAtSite(PsiType @NotNull [] types1, @NotNull PsiSubstitutor siteSubstitutor1) {
        if (siteSubstitutor1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(29);
        }
        if (types1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(30);
        }
        PsiType[] types2 = PsiType.createArray(types1.length);
        for (int i = 0; i < types1.length; ++i) {
            types2[i] = siteSubstitutor1.substitute(types1[i]);
        }
        if (types2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(31);
        }
        return types2;
    }

    @NotNull
    private static PsiSubstitutor calculateMethodSubstitutor(PsiTypeParameter @NotNull [] typeParameters2, @NotNull PsiMethod method, @NotNull PsiSubstitutor siteSubstitutor, PsiType @NotNull [] types1, PsiType @NotNull [] types2, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(32);
        }
        if (siteSubstitutor == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(33);
        }
        if (languageLevel == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(34);
        }
        if (typeParameters2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(35);
        }
        if (types1 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(36);
        }
        if (types2 == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(37);
        }
        PsiSubstitutor substitutor2 = PsiResolveHelper.SERVICE.getInstance(method.getProject()).inferTypeArguments(typeParameters2, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(method)) {
            PsiClass aClass;
            PsiType type2;
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (!substitutor2.getSubstitutionMap().containsKey(typeParameter)) {
                type2 = siteSubstitutor.substitute(typeParameter);
                if (type2 instanceof PsiClassType && typeParameter.getOwner() == method && (aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method) {
                    type2 = TypeConversionUtil.erasure(type2, siteSubstitutor);
                }
                substitutor2 = substitutor2.put(typeParameter, type2);
                continue;
            }
            type2 = substitutor2.substitute(typeParameter);
            if (!(type2 instanceof PsiClassType) || !((aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter)) continue;
            substitutor2 = substitutor2.put(typeParameter, JavaPsiFacade.getElementFactory(aClass.getProject()).createType(aClass, siteSubstitutor));
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(38);
        }
        return psiSubstitutor;
    }

    private void checkPrimitiveVarargs(@NotNull List<? extends CandidateInfo> conflicts, int argumentsCount) {
        PsiType componentType;
        PsiMethod method;
        if (conflicts == null) {
            JavaMethodsConflictResolver.$$$reportNull$$$0(39);
        }
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo candidateInfo : conflicts) {
            PsiClassType classType;
            PsiType type2;
            ProgressManager.checkCanceled();
            method = (PsiMethod)candidateInfo.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal(componentType = ((PsiArrayType)(type2 = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType(), classType = PsiType.getJavaLangObject(method.getManager(), GlobalSearchScope.allScope(method.getProject())))) continue;
            objectVararg = candidateInfo;
        }
        if (objectVararg != null) {
            for (CandidateInfo candidateInfo : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)candidateInfo.getElement();
                if (method == objectVararg.getElement() || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                PsiType type2 = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type2).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiExpression expr, PsiType sType, PsiType tType) {
        if (expr instanceof PsiParenthesizedExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiParenthesizedExpression)expr).getExpression(), sType, tType);
        }
        if (expr instanceof PsiConditionalExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getThenExpression(), sType, tType) && JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getElseExpression(), sType, tType);
        }
        if (expr instanceof PsiSwitchExpression) {
            return PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)expr).stream().allMatch(resultExpr -> JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(resultExpr, sType, tType));
        }
        if (expr instanceof PsiFunctionalExpression) {
            if (expr instanceof PsiLambdaExpression && !((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            if (expr instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)expr).isExact()) {
                return false;
            }
            if (LambdaUtil.isFunctionalType(sType) && LambdaUtil.isFunctionalType(tType) && !TypeConversionUtil.erasure(tType).isAssignableFrom(sType) && !TypeConversionUtil.erasure(sType).isAssignableFrom(tType)) {
                return InferenceSession.isFunctionalTypeMoreSpecificOnExpression(sType, tType, expr);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 31: 
            case 38: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 31: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsList";
                break;
            }
            case 1: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 8: 
            case 19: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
            case 13: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method1";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSubstitutor1";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method2";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2AtSite";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siteSubstitutor1";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siteSubstitutor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/scope/conflictResolvers/JavaMethodsConflictResolver";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "typesAtSite";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMethodSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "guardedOverloadResolution";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkPotentiallyCompatibleMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkSpecifics";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nonComparable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessStaticLevels";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkSameSignatures";
                break;
            }
            case 13: 
            case 31: 
            case 38: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkStaticMethodsOfInterfaces";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkParametersNumber";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkApplicability";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPertinentApplicabilityLevel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCheckAccessLevel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCheckStaticLevel";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMoreSpecific";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSiteSubstitutor";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "typesAtSite";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateMethodSubstitutor";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkPrimitiveVarargs";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 31: 
            case 38: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

