/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringPattern
extends ObjectPattern<String, StringPattern> {
    static final StringPattern STRING_PATTERN = new StringPattern();

    private StringPattern() {
        super(new InitialPatternCondition<String>(String.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context2) {
                return o instanceof String;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder2, String indent) {
                if (builder2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder2.append("string()");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StringPattern$1", "append"));
            }
        });
    }

    @NotNull
    public StringPattern startsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(0);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("startsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.startsWith(str, s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$2", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(1);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern endsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(2);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("endsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    3.$$$reportNull$$$0(0);
                }
                return StringUtil.endsWith(str, s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$3", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(3);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(4);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    4.$$$reportNull$$$0(0);
                }
                return StringUtil.contains(str, s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$4", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(5);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern containsChars(final @NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(6);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("containsChars"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    5.$$$reportNull$$$0(0);
                }
                return StringUtil.containsAnyChar(str, s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$5", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(7);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matches(final @NonNls @NotNull String s) {
        String escaped;
        if (s == null) {
            StringPattern.$$$reportNull$$$0(8);
        }
        if ((escaped = StringUtil.escapeToRegexp(s)).equals(s)) {
            StringPattern stringPattern = (StringPattern)this.equalTo(s);
            if (stringPattern == null) {
                StringPattern.$$$reportNull$$$0(9);
            }
            return stringPattern;
        }
        final Pattern pattern = Pattern.compile(s);
        StringPattern stringPattern = (StringPattern)this.with(new ValuePatternCondition<String>("matches"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    6.$$$reportNull$$$0(0);
                }
                return pattern.matcher(StringPattern.newBombedCharSequence(str)).matches();
            }

            @Override
            public Collection<String> getValues() {
                return Collections.singleton(s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$6", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(10);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull ElementPattern<Character> pattern) {
        if (pattern == null) {
            StringPattern.$$$reportNull$$$0(11);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context2) {
                if (str == null) {
                    7.$$$reportNull$$$0(0);
                }
                for (int i = 0; i < str.length(); ++i) {
                    if (!pattern.accepts(Character.valueOf(str.charAt(i)))) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$7", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(12);
        }
        return stringPattern;
    }

    public StringPattern longerThan(final int minLength) {
        return (StringPattern)this.with(new PatternCondition<String>("longerThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context2) {
                if (s == null) {
                    8.$$$reportNull$$$0(0);
                }
                return s.length() > minLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$8", "accepts"));
            }
        });
    }

    public StringPattern shorterThan(final int maxLength) {
        return (StringPattern)this.with(new PatternCondition<String>("shorterThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context2) {
                if (s == null) {
                    9.$$$reportNull$$$0(0);
                }
                return s.length() < maxLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$9", "accepts"));
            }
        });
    }

    public StringPattern withLength(final int length) {
        return (StringPattern)this.with(new PatternCondition<String>("withLength"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context2) {
                if (s == null) {
                    10.$$$reportNull$$$0(0);
                }
                return s.length() == length;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$10", "accepts"));
            }
        });
    }

    @NotNull
    public StringPattern oneOf(String ... values2) {
        StringPattern stringPattern = (StringPattern)super.oneOf(values2);
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(13);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern oneOfIgnoreCase(String ... values2) {
        StringPattern stringPattern = (StringPattern)this.with(new CaseInsensitiveValuePatternCondition("oneOfIgnoreCase", values2));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(14);
        }
        return stringPattern;
    }

    @Override
    @NotNull
    public StringPattern oneOf(@NonNls Collection<String> set) {
        StringPattern stringPattern = (StringPattern)super.oneOf(set);
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(15);
        }
        return stringPattern;
    }

    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence2) {
        if (sequence2 == null) {
            StringPattern.$$$reportNull$$$0(16);
        }
        if (sequence2 instanceof StringUtil.BombedCharSequence) {
            CharSequence charSequence = sequence2;
            if (charSequence == null) {
                StringPattern.$$$reportNull$$$0(17);
            }
            return charSequence;
        }
        return new StringUtil.BombedCharSequence(sequence2){

            @Override
            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StringPattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StringPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startsWith";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "endsWith";
                break;
            }
            case 5: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "containsChars";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOf";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOfIgnoreCase";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsChars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

