/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import ksp.org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtModifierListOwner;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtProperty;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.BindingTrace;
import ksp.org.jetbrains.kotlin.resolve.DeclarationsChecker;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/LateinitModifierApplicabilityChecker;", "", "<init>", "()V", "checkLateinitModifierApplicability", "", "trace", "Lksp/org/jetbrains/kotlin/resolve/BindingTrace;", "ktDeclaration", "Lksp/org/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/VariableDescriptor;", "frontend"})
public final class LateinitModifierApplicabilityChecker {
    @NotNull
    public static final LateinitModifierApplicabilityChecker INSTANCE = new LateinitModifierApplicabilityChecker();

    private LateinitModifierApplicabilityChecker() {
    }

    public final void checkLateinitModifierApplicability(@NotNull BindingTrace trace, @NotNull KtCallableDeclaration ktDeclaration, @NotNull VariableDescriptor descriptor2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)ktDeclaration, (String)"ktDeclaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (!ktDeclaration.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            return;
        }
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor instanceof PropertyDescriptor) {
            string = "properties";
        } else if (variableDescriptor instanceof LocalVariableDescriptor) {
            string = "local variables";
        } else {
            throw new AssertionError((Object)("Should be a property or a local variable: " + descriptor2));
        }
        String variables2 = string;
        KotlinType kotlinType = ((VariableDescriptorWithAccessors)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType type2 = kotlinType;
        if (!((VariableDescriptorWithAccessors)descriptor2).isVar()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is allowed only on mutable " + variables2));
        }
        if (InlineClassesUtilsKt.isInlineClassType(type2)) {
            if (TypeUtilsKt.isUnsignedNumberType(type2)) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of unsigned types"));
            } else {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of inline class types"));
            }
        }
        if (type2.isMarkedNullable()) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of nullable types"));
        } else if (TypeUtils.isNullableType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of a type with nullable upper bound"));
        }
        if (KotlinBuiltIns.isPrimitiveType(type2)) {
            trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " of primitive types"));
        }
        if (ktDeclaration instanceof KtProperty) {
            if (((KtProperty)ktDeclaration).hasDelegateExpression()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on delegated properties"));
            } else if (((KtProperty)ktDeclaration).hasInitializer()) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on " + variables2 + " with initializer"));
            }
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            boolean hasBackingField2;
            boolean isAbstract2 = ((PropertyDescriptor)descriptor2).getModality() == Modality.ABSTRACT;
            boolean hasDelegateExpressionOrInitializer = ktDeclaration instanceof KtProperty && ((KtProperty)ktDeclaration).hasDelegateExpressionOrInitializer();
            boolean hasAccessorImplementation = DeclarationsChecker.Companion.hasAnyAccessorImplementation((PropertyDescriptor)descriptor2);
            Boolean bl2 = (Boolean)trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2);
            boolean bl3 = hasBackingField2 = bl2 != null ? bl2 : false;
            if (ktDeclaration instanceof KtParameter) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on primary constructor parameters"));
            }
            if (isAbstract2) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on abstract properties"));
            }
            if (!hasDelegateExpressionOrInitializer) {
                if (hasAccessorImplementation) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on properties with a custom getter or setter"));
                } else if (!isAbstract2 && !hasBackingField2) {
                    trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on properties without backing field"));
                }
            }
            if (((PropertyDescriptor)descriptor2).getExtensionReceiverParameter() != null) {
                trace.report(Errors.INAPPLICABLE_LATEINIT_MODIFIER.on((KtModifierListOwner)((PsiElement)ktDeclaration), "is not allowed on extension properties"));
            }
        }
    }
}

