/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.declarations.CallToPotentiallyHiddenSymbolResult;
import ksp.org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CallToDeprecatedOverrideOfHidden;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.FirSimpleSyntheticPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.SyntheticsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.CallInfo;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorInfo;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J5\u0010\u0013\u001a\u00020\u000e2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/CheckHiddenDeclaration;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "candidate", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isDeprecatedHidden", "", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "callInfo", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;)Z", "isHiddenForThisCallSite", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)Z", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckHiddenDeclaration\n+ 2 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSinkKt\n*L\n1#1,1054:1\n29#2,2:1055\n23#2,9:1057\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckHiddenDeclaration\n*L\n880#1:1055,2\n880#1:1057,9\n*E\n"})
public final class CheckHiddenDeclaration
extends ResolutionStage {
    @NotNull
    public static final CheckHiddenDeclaration INSTANCE = new CheckHiddenDeclaration();

    private CheckHiddenDeclaration() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Candidate candidate, @NotNull Continuation<? super Unit> $completion) {
        block8: {
            void $this$yieldDiagnostic$iv;
            TypeAliasConstructorInfo<?> typeAliasConstructorInfo;
            block6: {
                FirCallableSymbol symbol;
                block7: {
                    FirTypeAliasSymbol firTypeAliasSymbol = candidate.getSymbol();
                    FirCallableSymbol firCallableSymbol = firTypeAliasSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)((Object)firTypeAliasSymbol) : null;
                    if (firCallableSymbol == null) {
                        return Unit.INSTANCE;
                    }
                    symbol = firCallableSymbol;
                    if (this.isDeprecatedHidden(context2, symbol, candidate.getCallInfo())) break block6;
                    if (!(symbol instanceof FirConstructorSymbol)) break block7;
                    typeAliasConstructorInfo = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo((FirConstructorSymbol)symbol);
                    if (typeAliasConstructorInfo != null && (firTypeAliasSymbol = typeAliasConstructorInfo.getTypeAliasSymbol()) != null ? this.isDeprecatedHidden(context2, firTypeAliasSymbol, candidate.getCallInfo()) : false) break block6;
                }
                if (!this.isHiddenForThisCallSite(sink, symbol, candidate.getCallInfo(), candidate)) break block8;
            }
            typeAliasConstructorInfo = sink;
            ResolutionDiagnostic diagnostic$iv = HiddenCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final boolean isDeprecatedHidden(ResolutionContext context2, FirBasedSymbol<?> $this$isDeprecatedHidden, CallInfo callInfo) {
        FirDeprecationInfo deprecation;
        FirDeprecationInfo firDeprecationInfo = deprecation = DeprecationUtilsKt.getDeprecation($this$isDeprecatedHidden, context2.getSession(), callInfo.getCallSite());
        return (firDeprecationInfo != null ? firDeprecationInfo.getDeprecationLevel() : null) == DeprecationLevelValue.HIDDEN;
    }

    private final boolean isHiddenForThisCallSite(CheckerSink sink, FirCallableSymbol<?> symbol, CallInfo callInfo, Candidate candidate) {
        if (symbol instanceof FirSimpleSyntheticPropertySymbol && SyntheticsKt.getDeprecatedOverrideOfHidden((FirSimpleSyntheticPropertySymbol)symbol)) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        if (((FirCallableDeclaration)symbol.getFir()).getDispatchReceiverType() == null || !(symbol instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        boolean isSuperCall = ResolutionStagesKt.isSuperCall(callInfo.getCallSite());
        if (DeprecationUtilsKt.hiddenStatusOfCall(symbol, isSuperCall, false) == CallToPotentiallyHiddenSymbolResult.Hidden) {
            return true;
        }
        FirScope firScope = candidate.getOriginScope();
        FirTypeScope firTypeScope = firScope instanceof FirTypeScope ? (FirTypeScope)firScope : null;
        if (firTypeScope == null) {
            return false;
        }
        FirTypeScope scope = firTypeScope;
        Ref.BooleanRef hidden = new Ref.BooleanRef();
        Ref.BooleanRef deprecated = new Ref.BooleanRef();
        FirTypeScopeKt.processOverriddenFunctions(scope, (FirNamedFunctionSymbol)symbol, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)arg_0 -> CheckHiddenDeclaration.isHiddenForThisCallSite$lambda$0(isSuperCall, hidden, deprecated, arg_0)));
        if (deprecated.element) {
            sink.reportDiagnostic(CallToDeprecatedOverrideOfHidden.INSTANCE);
        }
        return hidden.element;
    }

    private static final ProcessorAction isHiddenForThisCallSite$lambda$0(boolean $isSuperCall, Ref.BooleanRef $hidden, Ref.BooleanRef $deprecated, FirNamedFunctionSymbol it) {
        ProcessorAction processorAction;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CallToPotentiallyHiddenSymbolResult result2 = DeprecationUtilsKt.hiddenStatusOfCall(it, $isSuperCall, true);
        if (result2 != CallToPotentiallyHiddenSymbolResult.Visible) {
            if (result2 == CallToPotentiallyHiddenSymbolResult.Hidden) {
                $hidden.element = true;
            } else if (result2 == CallToPotentiallyHiddenSymbolResult.VisibleWithDeprecation) {
                $deprecated.element = true;
            }
            processorAction = ProcessorAction.STOP;
        } else {
            processorAction = ProcessorAction.NEXT;
        }
        return processorAction;
    }
}

