/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.KotlinCompilerVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory4;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.SessionHolder;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import ksp.org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import ksp.org.jetbrains.kotlin.fir.declarations.RequireKotlinDeprecationInfo;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCallToDeprecatedOverrideOfHidden;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorInfo;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertyAccessorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.metadata.ProtoBuf;
import ksp.org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;
import ksp.org.jetbrains.kotlin.name.CallableId;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010JC\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b\u001eJ)\u0010\u001f\u001a\u00020 *\u00020\u00022\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010!JI\u0010\"\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$H\u0000R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b%\u0010&J3\u0010'\u001a\u00020 *\u00020(2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\b\u0010#\u001a\u0004\u0018\u00010$H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010)JM\u0010*\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020(H\u0000R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b-\u0010.JC\u0010/\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010,\u001a\u000200H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u00101JK\u00102\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020(H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010.J7\u00103\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010,\u001a\u000204H\u0002R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u00105J1\u00106\u001a\u0004\u0018\u00010(2\b\u0010#\u001a\u0004\u0018\u00010$2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u00108J#\u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010:*\u00020;H\u0002R\u00020\u000bj\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010<R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006="}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "filteredSourceKinds", "", "Lksp/org/jetbrains/kotlin/KtFakeSourceElementKind;", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "reportCallToDeprecatedOverrideOfHidden", "source", "Lksp/org/jetbrains/kotlin/KtSourceElement;", "referencedSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)V", "DeprecatedOverrideOfHiddenReplacements", "", "", "getDeprecatedOverrideOfHiddenReplacements$checkers", "()Ljava/util/Map;", "getDeprecatedOverrideOfHiddenMessage", "callableName", "getDeprecatedOverrideOfHiddenMessage$checkers", "isDelegatedPropertySelfAccess", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "reportApiStatusIfNeeded", "callSite", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "reportApiStatusIfNeeded$checkers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/FirElement;)V", "isTypealiasExpansionOf", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/FirElement;)Z", "reportApiStatus", "isTypealiasExpansion", "deprecationInfo", "reportApiStatus$checkers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;ZLorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;)V", "reportVersionRequirementDeprecation", "Lksp/org/jetbrains/kotlin/fir/declarations/RequireKotlinDeprecationInfo;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/declarations/RequireKotlinDeprecationInfo;)V", "reportDeprecation", "reportApiNotAvailable", "Lksp/org/jetbrains/kotlin/fir/declarations/FutureApiDeprecationInfo;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/declarations/FutureApiDeprecationInfo;)V", "getWorstDeprecation", "symbol", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirDeprecationInfo;", "classSymbolItIsCalledThrough", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeprecationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDeprecationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class FirDeprecationChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirDeprecationChecker INSTANCE = new FirDeprecationChecker();
    @NotNull
    private static final Set<KtFakeSourceElementKind> filteredSourceKinds;
    @NotNull
    private static final Map<String, String> DeprecatedOverrideOfHiddenReplacements;

    private FirDeprecationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression2) {
        KtSourceElement source;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtSourceElement ktSourceElement = expression2.getSource();
        if (CollectionsKt.contains((Iterable)filteredSourceKinds, (Object)(ktSourceElement != null ? ktSourceElement.getKind() : null))) {
            return;
        }
        if (expression2 instanceof FirAnnotation) {
            return;
        }
        if (FirHelpersKt.isLhsOfAssignment(context2, expression2)) {
            return;
        }
        FirReference firReference = ReferenceUtilsKt.toReference(expression2, context2.getSession());
        if (firReference == null) {
            return;
        }
        FirReference calleeReference = firReference;
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(calleeReference);
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference resolvedReference = firResolvedNamedReference;
        FirBasedSymbol<?> referencedSymbol = resolvedReference.getResolvedSymbol();
        if (this.isDelegatedPropertySelfAccess(context2, expression2, referencedSymbol)) {
            return;
        }
        KtSourceElement ktSourceElement2 = resolvedReference.getSource();
        if (ktSourceElement2 == null) {
            ktSourceElement2 = source = expression2.getSource();
        }
        if (expression2 instanceof FirDelegatedConstructorCall) {
            FirDeprecationInfo firDeprecationInfo = DeprecationUtilsKt.getDeprecation(referencedSymbol, context2.getSession(), expression2);
            if (firDeprecationInfo == null) {
                return;
            }
            FirDeprecationInfo constructorOnlyDeprecation = firDeprecationInfo;
            boolean isTypealiasExpansion = AbbreviatedTypeAttributeKt.isTypealiasExpansion(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(((FirDelegatedConstructorCall)expression2).getConstructedTypeRef())));
            this.reportApiStatus$checkers(context2, reporter, source, referencedSymbol, isTypealiasExpansion, constructorOnlyDeprecation);
        } else {
            this.reportApiStatusIfNeeded$checkers(context2, reporter, source, referencedSymbol, expression2);
        }
        this.reportCallToDeprecatedOverrideOfHidden(context2, reporter, expression2, source, referencedSymbol);
    }

    private final void reportCallToDeprecatedOverrideOfHidden(CheckerContext context2, DiagnosticReporter reporter, FirStatement expression2, KtSourceElement source, FirBasedSymbol<?> referencedSymbol) {
        if (!(expression2 instanceof FirQualifiedAccessExpression)) {
            return;
        }
        if (((FirQualifiedAccessExpression)expression2).getNonFatalDiagnostics().contains(ConeCallToDeprecatedOverrideOfHidden.INSTANCE)) {
            FirCallableSymbol firCallableSymbol = referencedSymbol instanceof FirSyntheticPropertySymbol ? (FirSyntheticPropertySymbol)referencedSymbol : null;
            FirCallableSymbol unwrappedSymbol = firCallableSymbol != null && (firCallableSymbol = ((FirSyntheticPropertySymbol)firCallableSymbol).getGetterSymbol()) != null && (firCallableSymbol = ((FirSyntheticPropertyAccessorSymbol)firCallableSymbol).getDelegateFunctionSymbol()) != null ? firCallableSymbol : (referencedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)referencedSymbol : null);
            Object object = unwrappedSymbol;
            String callableName = object != null && (object = ((FirCallableSymbol)object).getCallableId()) != null && (object = ((CallableId)object).getCallableName()) != null ? ((Name)object).asString() : null;
            String message = this.getDeprecatedOverrideOfHiddenMessage$checkers(callableName);
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getDEPRECATION(), referencedSymbol, (Object)message, null, 32, null);
        }
    }

    @NotNull
    public final Map<String, String> getDeprecatedOverrideOfHiddenReplacements$checkers() {
        return DeprecatedOverrideOfHiddenReplacements;
    }

    @NotNull
    public final String getDeprecatedOverrideOfHiddenMessage$checkers(@Nullable String callableName) {
        String getFirstOrLastReplacement = DeprecatedOverrideOfHiddenReplacements.get(callableName);
        return getFirstOrLastReplacement != null ? "This declaration will be renamed in a future version of Kotlin. Please consider using the '" + getFirstOrLastReplacement + "' stdlib extension if the collection supports fast random access." : "This declaration is redundant in Kotlin and might be removed soon.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDelegatedPropertySelfAccess(CheckerContext context2, FirStatement $this$isDelegatedPropertySelfAccess, FirBasedSymbol<?> referencedSymbol) {
        KtSourceElement ktSourceElement = $this$isDelegatedPropertySelfAccess.getSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
            return false;
        }
        List<FirBasedSymbol<?>> containers = context2.getContainingDeclarations();
        int size = containers.size();
        Object fir = referencedSymbol.getFir();
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)CollectionsKt.getOrNull(containers, (int)(size - 1));
        if (Intrinsics.areEqual(firBasedSymbol != null ? firBasedSymbol.getFir() : null, fir)) return true;
        FirBasedSymbol firBasedSymbol2 = (FirBasedSymbol)CollectionsKt.getOrNull(containers, (int)(size - 2));
        if (!Intrinsics.areEqual(firBasedSymbol2 != null ? firBasedSymbol2.getFir() : null, fir)) return false;
        return true;
    }

    public final void reportApiStatusIfNeeded$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol, @Nullable FirElement callSite) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(referencedSymbol, (String)"referencedSymbol");
        FirDeprecationInfo firDeprecationInfo = this.getWorstDeprecation(context2, callSite, referencedSymbol);
        if (firDeprecationInfo == null) {
            return;
        }
        FirDeprecationInfo deprecation = firDeprecationInfo;
        boolean isTypealiasExpansion = this.isTypealiasExpansionOf(context2, deprecation, referencedSymbol, callSite);
        this.reportApiStatus$checkers(context2, reporter, source, referencedSymbol, isTypealiasExpansion, deprecation);
    }

    public static /* synthetic */ void reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker firDeprecationChecker, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, KtSourceElement ktSourceElement, FirBasedSymbol firBasedSymbol, FirElement firElement, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            firElement = null;
        }
        firDeprecationChecker.reportApiStatusIfNeeded$checkers(checkerContext, diagnosticReporter, ktSourceElement, firBasedSymbol, firElement);
    }

    private final boolean isTypealiasExpansionOf(CheckerContext context2, FirDeprecationInfo $this$isTypealiasExpansionOf, FirBasedSymbol<?> referencedSymbol, FirElement callSite) {
        boolean bl2;
        FirBasedSymbol<?> firBasedSymbol = referencedSymbol;
        if (firBasedSymbol instanceof FirConstructorSymbol) {
            FirTypeAliasSymbol firTypeAliasSymbol;
            TypeAliasConstructorInfo<?> typeAliasConstructorInfo = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo((FirConstructorSymbol)referencedSymbol);
            if (typeAliasConstructorInfo != null && (firTypeAliasSymbol = typeAliasConstructorInfo.getTypeAliasSymbol()) != null) {
                FirTypeAliasSymbol it = firTypeAliasSymbol;
                boolean bl3 = false;
                bl2 = INSTANCE.isTypealiasExpansionOf(context2, $this$isTypealiasExpansionOf, it, callSite);
            } else {
                bl2 = false;
            }
        } else if (!(firBasedSymbol instanceof FirTypeAliasSymbol)) {
            bl2 = false;
        } else {
            FirDeprecationInfo it = DeprecationUtilsKt.getOwnDeprecation(referencedSymbol, context2.getSession(), callSite);
            boolean bl4 = false;
            bl2 = it == null || it.compareTo($this$isTypealiasExpansionOf) < 0;
        }
        return bl2;
    }

    public final void reportApiStatus$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @Nullable KtSourceElement source, @NotNull FirBasedSymbol<?> referencedSymbol, boolean isTypealiasExpansion, @NotNull FirDeprecationInfo deprecationInfo2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(referencedSymbol, (String)"referencedSymbol");
        Intrinsics.checkNotNullParameter((Object)deprecationInfo2, (String)"deprecationInfo");
        FirDeprecationInfo firDeprecationInfo = deprecationInfo2;
        if (firDeprecationInfo instanceof FutureApiDeprecationInfo) {
            this.reportApiNotAvailable(context2, reporter, source, (FutureApiDeprecationInfo)deprecationInfo2);
        } else if (firDeprecationInfo instanceof RequireKotlinDeprecationInfo) {
            this.reportVersionRequirementDeprecation(context2, reporter, source, referencedSymbol, (RequireKotlinDeprecationInfo)deprecationInfo2);
        } else {
            this.reportDeprecation(context2, reporter, source, referencedSymbol, isTypealiasExpansion, deprecationInfo2);
        }
    }

    private final void reportVersionRequirementDeprecation(CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source, FirBasedSymbol<?> referencedSymbol, RequireKotlinDeprecationInfo deprecationInfo2) {
        String string;
        KtDiagnosticFactory4<FirBasedSymbol<?>, VersionRequirement.Version, String, String> diagnostic = WhenMappings.$EnumSwitchMapping$0[deprecationInfo2.getDeprecationLevel().ordinal()] == 1 ? FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION() : FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION_ERROR();
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        switch (WhenMappings.$EnumSwitchMapping$1[deprecationInfo2.getVersionRequirement().getKind().ordinal()]) {
            case 1: {
                string = KotlinCompilerVersion.VERSION;
                break;
            }
            case 2: {
                string = languageVersionSettings.getLanguageVersion().getVersionString();
                break;
            }
            case 3: {
                string = languageVersionSettings.getApiVersion().getVersionString();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String currentVersionString = string;
        DiagnosticContext diagnosticContext = context2;
        AbstractKtSourceElement abstractKtSourceElement = source;
        VersionRequirement.Version version = deprecationInfo2.getVersionRequirement().getVersion();
        String string2 = deprecationInfo2.getMessage(context2.getSession());
        if (string2 == null) {
            string2 = "";
        }
        KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, abstractKtSourceElement, diagnostic, referencedSymbol, (Object)version, (Object)currentVersionString, (Object)string2, null, 128, null);
    }

    private final void reportDeprecation(CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source, FirBasedSymbol<?> referencedSymbol, boolean isTypealiasExpansion, FirDeprecationInfo deprecationInfo2) {
        if (!isTypealiasExpansion) {
            KtDiagnosticFactory2<FirBasedSymbol<?>, String> ktDiagnosticFactory2;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo2.getDeprecationLevel().ordinal()]) {
                case 2: 
                case 3: {
                    ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION_ERROR();
                    break;
                }
                case 1: {
                    ktDiagnosticFactory2 = FirErrors.INSTANCE.getDEPRECATION();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory2;
            DiagnosticContext diagnosticContext = context2;
            AbstractKtSourceElement abstractKtSourceElement = source;
            String string = deprecationInfo2.getMessage(context2.getSession());
            if (string == null) {
                string = "";
            }
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, abstractKtSourceElement, diagnostic, referencedSymbol, (Object)string, null, 32, null);
        } else {
            KtDiagnosticFactory3<FirBasedSymbol<?>, FirBasedSymbol<?>, String> ktDiagnosticFactory3;
            switch (WhenMappings.$EnumSwitchMapping$0[deprecationInfo2.getDeprecationLevel().ordinal()]) {
                case 2: 
                case 3: {
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION_ERROR();
                    break;
                }
                case 1: {
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getTYPEALIAS_EXPANSION_DEPRECATION();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtDiagnosticFactory3<FirBasedSymbol<?>, FirBasedSymbol<?>, String> diagnostic = ktDiagnosticFactory3;
            DiagnosticContext diagnosticContext = context2;
            AbstractKtSourceElement abstractKtSourceElement = source;
            String string = deprecationInfo2.getMessage(context2.getSession());
            if (string == null) {
                string = "";
            }
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticContext, reporter, abstractKtSourceElement, diagnostic, referencedSymbol, referencedSymbol, (Object)string, null, 64, null);
        }
    }

    private final void reportApiNotAvailable(CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source, FutureApiDeprecationInfo deprecationInfo2) {
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getAPI_NOT_AVAILABLE(), (Object)deprecationInfo2.getSinceVersion(), (Object)context2.getLanguageVersionSettings().getApiVersion(), null, 32, null);
    }

    private final FirDeprecationInfo getWorstDeprecation(CheckerContext context2, FirElement callSite, FirBasedSymbol<?> symbol) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        Object[] objectArray = new FirDeprecationInfo[2];
        FirConstructorSymbol firConstructorSymbol = symbol instanceof FirConstructorSymbol ? (FirConstructorSymbol)symbol : null;
        objectArray[0] = firConstructorSymbol != null && (firClassLikeSymbol = this.classSymbolItIsCalledThrough(context2, firConstructorSymbol)) != null ? DeprecationUtilsKt.getDeprecation((FirBasedSymbol)firClassLikeSymbol, context2.getSession(), callSite) : null;
        objectArray[1] = DeprecationUtilsKt.getDeprecation(symbol, context2.getSession(), callSite);
        List deprecationInfos = CollectionsKt.listOfNotNull((Object[])objectArray);
        return (FirDeprecationInfo)CollectionsKt.maxOrNull((Iterable)deprecationInfos);
    }

    private final FirClassLikeSymbol<?> classSymbolItIsCalledThrough(CheckerContext context2, FirConstructorSymbol $this$classSymbolItIsCalledThrough) {
        TypeAliasConstructorInfo<?> typeAliasConstructorInfo = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasConstructorInfo($this$classSymbolItIsCalledThrough);
        return typeAliasConstructorInfo != null && (typeAliasConstructorInfo = typeAliasConstructorInfo.getTypeAliasSymbol()) != null ? (FirClassLikeSymbol)((Object)typeAliasConstructorInfo) : (FirClassLikeSymbol)FirHelpersKt.toRegularClassSymbol($this$classSymbolItIsCalledThrough.getResolvedReturnTypeRef(), context2.getSession());
    }

    static {
        Object[] objectArray = new KtFakeSourceElementKind[]{KtFakeSourceElementKind.PropertyFromParameter.INSTANCE, KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE};
        filteredSourceKinds = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"getFirst", (Object)"first()"), TuplesKt.to((Object)"getLast", (Object)"last()"), TuplesKt.to((Object)"toArray", null)};
        DeprecatedOverrideOfHiddenReplacements = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            try {
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeprecationLevelValue.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

