/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.ConcurrencyUtil;
import ksp.com.intellij.util.SystemProperties;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class FileChannelInterruptsRetryer
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(FileChannelInterruptsRetryer.class);
    @VisibleForTesting
    static final int MAX_RETRIES = SystemProperties.getIntProperty("idea.vfs.FileChannelInterruptsRetryer.MAX_RETRIES", 64);
    private static final int LOG_STACKTRACE_IF_RETRY_CHAIN_LONGER = SystemProperties.getIntProperty("idea.vfs.LOG_STACKTRACE_IF_RETRY_CHAIN_LONGER", 32);
    @NotNull
    private final Lock openCloseLock;
    @NotNull
    private final Path path;
    private final Set<? extends @NotNull OpenOption> openOptions;
    private volatile FileChannel channel;
    private static final AtomicLong totalRetriedAttempts = new AtomicLong();

    public static long totalRetriedAttempts() {
        return totalRetriedAttempts.get();
    }

    public FileChannelInterruptsRetryer(@NotNull Path path, Set<? extends @NotNull OpenOption> openOptions) throws IOException {
        if (path == null) {
            FileChannelInterruptsRetryer.$$$reportNull$$$0(0);
        }
        this.openCloseLock = new ReentrantLock();
        this.path = path;
        this.openOptions = openOptions;
        this.reopenChannel();
    }

    public <T> T retryIfInterrupted(@NotNull FileChannelIdempotentOperation<T> operation) throws IOException {
        if (operation == null) {
            FileChannelInterruptsRetryer.$$$reportNull$$$0(1);
        }
        boolean interruptedStatusWasCleared = false;
        try {
            int attempt = 0;
            while (true) {
                T t2;
                FileChannel channelLocalCopy;
                if ((channelLocalCopy = this.channel) == null && attempt == 0) {
                    throw new ClosedChannelException();
                }
                try {
                    if (channelLocalCopy == null && attempt >= 0) {
                        throw new ClosedChannelException();
                    }
                    t2 = operation.execute(channelLocalCopy);
                }
                catch (ClosedChannelException e2) {
                    boolean logStackTrace;
                    totalRetriedAttempts.incrementAndGet();
                    if (attempt >= MAX_RETRIES) {
                        IOException ioe = new IOException("Channel[" + this.path + "][@" + System.identityHashCode(channelLocalCopy) + "] is interrupted/closed in the middle of operation " + MAX_RETRIES + " times in the row: surrender");
                        ioe.addSuppressed(e2);
                        throw ioe;
                    }
                    boolean bl2 = logStackTrace = LOG_STACKTRACE_IF_RETRY_CHAIN_LONGER > 0 && attempt % LOG_STACKTRACE_IF_RETRY_CHAIN_LONGER == LOG_STACKTRACE_IF_RETRY_CHAIN_LONGER - 1;
                    if (logStackTrace) {
                        LOG.warn("Channel[" + this.path + "][@" + System.identityHashCode(channelLocalCopy) + "] is closed during " + operation + " " + LOG_STACKTRACE_IF_RETRY_CHAIN_LONGER + " times in a row -- suspicious, log stacktrace", e2);
                    } else {
                        LOG.warn("Channel[" + this.path + "][@" + System.identityHashCode(channelLocalCopy) + "] is closed during " + operation + " => trying to reopen it again. Reason: " + e2);
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                        interruptedStatusWasCleared = true;
                    }
                    this.reopenChannel();
                    ++attempt;
                    continue;
                }
                return t2;
            }
        }
        finally {
            if (interruptedStatusWasCleared) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public void close() throws IOException {
        ConcurrencyUtil.withLock(this.openCloseLock, this::tryClose);
    }

    private void reopenChannel() throws IOException {
        ConcurrencyUtil.withLock(this.openCloseLock, () -> {
            try {
                this.tryClose();
            }
            catch (IOException e2) {
                LOG.info("Can't close channel[" + this.path + "]: " + e2.getMessage());
            }
            this.channel = FileChannel.open(this.path, this.openOptions, new FileAttribute[0]);
        });
    }

    private void tryClose() throws IOException {
        try {
            FileChannel channel = this.channel;
            if (channel != null && channel.isOpen()) {
                channel.close();
            }
        }
        finally {
            this.channel = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/util/io/FileChannelInterruptsRetryer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "retryIfInterrupted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileChannelIdempotentOperation<T> {
        public T execute(@NotNull FileChannel var1) throws IOException;
    }
}

