/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementAnnotationCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.ObjCExportMetaAnnotations;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0013"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementAnnotationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "hidesFromObjCSupportedTargets", "", "Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "[Lksp/org/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "refinesInSwiftSupportedTargets", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "checkers.native"})
public final class FirNativeObjCRefinementAnnotationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNativeObjCRefinementAnnotationChecker INSTANCE = new FirNativeObjCRefinementAnnotationChecker();
    @NotNull
    private static final KotlinTarget[] hidesFromObjCSupportedTargets;
    @NotNull
    private static final KotlinTarget[] refinesInSwiftSupportedTargets;

    private FirNativeObjCRefinementAnnotationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration2) {
        block6: {
            FirAnnotation it;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            if (declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
                return;
            }
            FirSession session = context2.getSession();
            ObjCExportMetaAnnotations objCExportMetaAnnotations = FirNativeObjCRefinementAnnotationCheckerKt.findMetaAnnotations(declaration2.getAnnotations(), session);
            FirAnnotation objCAnnotation = objCExportMetaAnnotations.component1();
            FirAnnotation swiftAnnotation = objCExportMetaAnnotations.component2();
            if (objCAnnotation == null && swiftAnnotation == null) {
                return;
            }
            if (objCAnnotation != null && swiftAnnotation != null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)swiftAnnotation.getSource(), FirNativeErrors.INSTANCE.getREDUNDANT_SWIFT_REFINEMENT(), null, 8, null);
            }
            Set<KotlinTarget> targets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration2, session);
            FirAnnotation firAnnotation = objCAnnotation;
            if (firAnnotation != null) {
                it = firAnnotation;
                boolean bl2 = false;
                if (!((Collection)SetsKt.minus(targets, (Object[])hidesFromObjCSupportedTargets)).isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getINVALID_OBJC_HIDES_TARGETS(), null, 8, null);
                }
            }
            FirAnnotation firAnnotation2 = swiftAnnotation;
            if (firAnnotation2 == null) break block6;
            it = firAnnotation2;
            boolean bl3 = false;
            if (!((Collection)SetsKt.minus(targets, (Object[])refinesInSwiftSupportedTargets)).isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it.getSource(), FirNativeErrors.INSTANCE.getINVALID_REFINES_IN_SWIFT_TARGETS(), null, 8, null);
            }
        }
    }

    static {
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY, KotlinTarget.CLASS};
        hidesFromObjCSupportedTargets = kotlinTargetArray;
        kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
        refinesInSwiftSupportedTargets = kotlinTargetArray;
    }
}

