/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.standalone;

import com.google.devtools.ksp.standalone.IncrementalGlobalSearchScope;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.com.intellij.core.CoreApplicationEnvironment;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.PsiManager;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import ksp.org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import ksp.org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import ksp.org.jetbrains.kotlin.analysis.project.structure.impl.KaSourceModuleImpl;
import ksp.org.jetbrains.kotlin.config.ApiVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersion;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;

@KtModuleBuilderDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u0014\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\bH\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/google/devtools/ksp/standalone/KspModuleBuilder;", "Lksp/org/jetbrains/kotlin/analysis/project/structure/builder/KtModuleBuilder;", "coreApplicationEnvironment", "Lksp/com/intellij/core/CoreApplicationEnvironment;", "project", "Lksp/com/intellij/openapi/project/Project;", "(Lcom/intellij/core/CoreApplicationEnvironment;Lcom/intellij/openapi/project/Project;)V", "analyzableExtensions", "", "", "getAnalyzableExtensions", "()Ljava/util/Set;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "moduleName", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "sourceRoots", "", "Ljava/nio/file/Path;", "addSourceRoot", "", "path", "addSourceRoots", "paths", "", "build", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "collectVirtualFilesByRoots", "Lksp/com/intellij/openapi/vfs/VirtualFile;", "kotlin-analysis-api"})
@SourceDebugExtension(value={"SMAP\nKspSourceModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KspSourceModuleBuilder.kt\ncom/google/devtools/ksp/standalone/KspModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1617#2,9:122\n1869#2:131\n1870#2:133\n1626#2:134\n1#3:132\n*S KotlinDebug\n*F\n+ 1 KspSourceModuleBuilder.kt\ncom/google/devtools/ksp/standalone/KspModuleBuilder\n*L\n63#1:122,9\n63#1:131\n63#1:133\n63#1:134\n63#1:132\n*E\n"})
public final class KspModuleBuilder
extends KtModuleBuilder {
    @NotNull
    private final CoreApplicationEnvironment coreApplicationEnvironment;
    @NotNull
    private final Project project;
    public String moduleName;
    @NotNull
    private LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Set<Path> sourceRoots;
    @NotNull
    private final Set<String> analyzableExtensions;

    public KspModuleBuilder(@NotNull CoreApplicationEnvironment coreApplicationEnvironment, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)coreApplicationEnvironment, (String)"coreApplicationEnvironment");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coreApplicationEnvironment = coreApplicationEnvironment;
        this.project = project;
        this.languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
        this.sourceRoots = new LinkedHashSet();
        Object[] objectArray = new String[]{"kt", "java", "kts"};
        this.analyzableExtensions = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public final String getModuleName() {
        String string = this.moduleName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"moduleName");
        return null;
    }

    public final void setModuleName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.moduleName = string;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"<set-?>");
        this.languageVersionSettings = languageVersionSettings;
    }

    public final void addSourceRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.sourceRoots.add(path);
    }

    public final void addSourceRoots(@NotNull Collection<? extends Path> paths2) {
        Intrinsics.checkNotNullParameter(paths2, (String)"paths");
        this.sourceRoots.addAll(paths2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KaSourceModule build() {
        void $this$mapNotNullTo$iv$iv;
        Set<VirtualFile> virtualFiles = this.collectVirtualFilesByRoots();
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl3 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        IncrementalGlobalSearchScope contentScope = new IncrementalGlobalSearchScope(this.project, (Collection<? extends VirtualFile>)virtualFiles);
        return new KaSourceModuleImpl(this.getDirectRegularDependencies(), this.getDirectDependsOnDependencies(), this.getDirectFriendDependencies(), contentScope, this.getPlatform(), this.project, this.getModuleName(), this.languageVersionSettings, psiFiles);
    }

    @NotNull
    public final Set<String> getAnalyzableExtensions() {
        return this.analyzableExtensions;
    }

    private final Set<VirtualFile> collectVirtualFilesByRoots() {
        Set set;
        CoreLocalFileSystem coreLocalFileSystem = this.coreApplicationEnvironment.getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)coreLocalFileSystem, (String)"getLocalFileSystem(...)");
        CoreLocalFileSystem localFileSystem = coreLocalFileSystem;
        Set $this$collectVirtualFilesByRoots_u24lambda_u241 = set = SetsKt.createSetBuilder();
        boolean bl2 = false;
        for (Path root : this.sourceRoots) {
            File file = root.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Sequence files2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)file, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ KspModuleBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(File it) {
                    boolean bl2;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (!it.isDirectory()) {
                        Set<String> set = this.this$0.getAnalyzableExtensions();
                        String string = FilesKt.getExtension((File)it).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                        if (!set.contains(string)) {
                            bl2 = false;
                            return bl2;
                        }
                    }
                    bl2 = true;
                    return bl2;
                }
            }));
            for (File file2 : files2) {
                VirtualFile virtualFile;
                if (localFileSystem.findFileByIoFile(file2) == null) continue;
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile virtualFile2 = virtualFile;
                $this$collectVirtualFilesByRoots_u24lambda_u241.add(virtualFile2);
            }
        }
        return SetsKt.build((Set)set);
    }
}

