/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementOverridesChecker;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u00020\u000eR\u00020\u0010j\u0006\u0010\u000f\u001a\u00020\u000ej\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015*\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001a"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "hidesFromObjCClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "getHidesFromObjCClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "refinesInSwiftClassId", "getRefinesInSwiftClassId", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "findRefinedAnnotations", "Lkotlin/Pair;", "", "Lksp/org/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "checkers.native"})
public final class FirNativeObjCRefinementChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeObjCRefinementChecker INSTANCE = new FirNativeObjCRefinementChecker();
    @NotNull
    private static final ClassId hidesFromObjCClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.HidesFromObjC"));
    @NotNull
    private static final ClassId refinesInSwiftClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.RefinesInSwift"));

    private FirNativeObjCRefinementChecker() {
        super(MppCheckerKind.Platform);
    }

    @NotNull
    public final ClassId getHidesFromObjCClassId() {
        return hidesFromObjCClassId;
    }

    @NotNull
    public final ClassId getRefinesInSwiftClassId() {
        return refinesInSwiftClassId;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration2) {
        FirClassSymbol containingClass;
        Object swiftAnnotation2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!(declaration2 instanceof FirSimpleFunction) && !(declaration2 instanceof FirProperty)) {
            return;
        }
        Pair<List<FirAnnotation>, List<FirAnnotation>> pair = this.findRefinedAnnotations(declaration2, context2.getSession());
        List objCAnnotations = (List)pair.component1();
        List swiftAnnotations = (List)pair.component2();
        if (!((Collection)objCAnnotations).isEmpty() && !((Collection)swiftAnnotations).isEmpty()) {
            for (Object swiftAnnotation2 : swiftAnnotations) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirAnnotation)swiftAnnotation2).getSource(), FirNativeErrors.INSTANCE.getREDUNDANT_SWIFT_REFINEMENT(), null, 8, null);
            }
        }
        FirClassSymbol firClassSymbol = containingClass = (swiftAnnotation2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirClassSymbol ? (FirClassSymbol)swiftAnnotation2 : null;
        if (containingClass != null) {
            FirTypeScope firTypeScope = FirHelpersKt.unsubstitutedScope(containingClass, context2);
            FirNativeObjCRefinementOverridesChecker.Companion.check(firTypeScope, declaration2.getSymbol(), declaration2, context2, reporter, objCAnnotations, swiftAnnotations);
        }
    }

    private final Pair<List<FirAnnotation>, List<FirAnnotation>> findRefinedAnnotations(FirCallableDeclaration $this$findRefinedAnnotations, FirSession session) {
        List objCAnnotations = new ArrayList();
        List swiftAnnotations = new ArrayList();
        block0: for (FirAnnotation annotation : $this$findRefinedAnnotations.getAnnotations()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation, session);
            List list = firClassLikeSymbol != null ? firClassLikeSymbol.getResolvedAnnotationsWithClassIds() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List metaAnnotations = list;
            for (FirAnnotation metaAnnotation : metaAnnotations) {
                ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(metaAnnotation, session);
                if (Intrinsics.areEqual((Object)classId, (Object)hidesFromObjCClassId)) {
                    objCAnnotations.add(annotation);
                    continue block0;
                }
                if (!Intrinsics.areEqual((Object)classId, (Object)refinesInSwiftClassId)) continue;
                swiftAnnotations.add(annotation);
                continue block0;
            }
        }
        return TuplesKt.to((Object)objCAnnotations, (Object)swiftAnnotations);
    }
}

