/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.builtins.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.functions.AllowedToUsedOnlyInK1;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import ksp.org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\tJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\u0006\u0010\u0014\u001a\u00020\u0011J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "", "kinds", "", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "<init>", "(Ljava/util/List;)V", "knownKindsByPackageFqName", "", "Lksp/org/jetbrains/kotlin/name/FqName;", "getFunctionalClassKind", "packageFqName", "className", "", "getFunctionalClassKindWithArity", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$KindWithArity;", "hasKindWithSpecificPackage", "", "getFunctionKindPackageNames", "", "hasExtensionKinds", "toInt", "", "s", "(Ljava/lang/String;)Ljava/lang/Integer;", "Companion", "KindWithArity", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nFunctionTypeKindExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionTypeKindExtractor.kt\norg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,70:1\n1491#2:71\n1516#2,3:72\n1519#2,3:82\n1761#2,3:85\n382#3,7:75\n*S KotlinDebug\n*F\n+ 1 FunctionTypeKindExtractor.kt\norg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor\n*L\n32#1:71\n32#1:72,3\n32#1:82,3\n54#1:85,3\n32#1:75,7\n*E\n"})
public final class FunctionTypeKindExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FunctionTypeKind> kinds;
    @NotNull
    private final Map<FqName, List<FunctionTypeKind>> knownKindsByPackageFqName;
    @NotNull
    private static final FunctionTypeKindExtractor Default;

    /*
     * WARNING - void declaration
     */
    public FunctionTypeKindExtractor(@NotNull List<? extends FunctionTypeKind> kinds2) {
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(kinds2, (String)"kinds");
        this.kinds = kinds2;
        Iterable iterable = this.kinds;
        FunctionTypeKindExtractor functionTypeKindExtractor = this;
        boolean $i$f$groupBy = false;
        void var4_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            FunctionTypeKind it = (FunctionTypeKind)element$iv$iv;
            boolean bl2 = false;
            FqName key$iv$iv = it.getPackageFqName();
            Map map = destination$iv$iv;
            FqName key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        functionTypeKindExtractor.knownKindsByPackageFqName = destination$iv$iv;
    }

    @Nullable
    public final FunctionTypeKind getFunctionalClassKind(@NotNull FqName packageFqName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        KindWithArity kindWithArity = this.getFunctionalClassKindWithArity(packageFqName, className);
        return kindWithArity != null ? kindWithArity.getKind() : null;
    }

    @Nullable
    public final KindWithArity getFunctionalClassKindWithArity(@NotNull FqName packageFqName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        List<FunctionTypeKind> list = this.knownKindsByPackageFqName.get(packageFqName);
        if (list == null) {
            return null;
        }
        List<FunctionTypeKind> kinds2 = list;
        for (FunctionTypeKind kind : kinds2) {
            if (!StringsKt.startsWith$default((String)className, (String)kind.getClassNamePrefix(), (boolean)false, (int)2, null)) continue;
            String string = className.substring(kind.getClassNamePrefix().length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer n2 = this.toInt(string);
            if (n2 == null) {
                continue;
            }
            int arity = n2;
            return new KindWithArity(kind, arity);
        }
        return null;
    }

    public final boolean hasKindWithSpecificPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.knownKindsByPackageFqName.containsKey(packageFqName);
    }

    @NotNull
    public final Set<FqName> getFunctionKindPackageNames() {
        return this.knownKindsByPackageFqName.keySet();
    }

    public final boolean hasExtensionKinds() {
        boolean bl2;
        block3: {
            Iterable $this$any$iv = this.kinds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FunctionTypeKind it = (FunctionTypeKind)element$iv;
                    boolean bl3 = false;
                    if (!(!FunctionTypeKindKt.isBuiltin(it))) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private final Integer toInt(String s2) {
        if (((CharSequence)s2).length() == 0) {
            return null;
        }
        int result2 = 0;
        int n2 = s2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = s2.charAt(i2);
            int d2 = c2 - 48;
            if (!(0 <= d2 ? d2 < 10 : false)) {
                return null;
            }
            result2 = result2 * 10 + d2;
        }
        return result2;
    }

    @NotNull
    public static final FunctionTypeKindExtractor getDefault() {
        return Companion.getDefault();
    }

    static {
        Object[] objectArray = new FunctionTypeKind[]{FunctionTypeKind.Function.INSTANCE, FunctionTypeKind.SuspendFunction.INSTANCE, FunctionTypeKind.KFunction.INSTANCE, FunctionTypeKind.KSuspendFunction.INSTANCE};
        Default = new FunctionTypeKindExtractor(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$Companion;", "", "<init>", "()V", "Default", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getDefault$annotations", "getDefault", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "compiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FunctionTypeKindExtractor getDefault() {
            return Default;
        }

        @JvmStatic
        @AllowedToUsedOnlyInK1
        public static /* synthetic */ void getDefault$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor$KindWithArity;", "", "kind", "Lksp/org/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "arity", "", "<init>", "(Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;I)V", "getKind", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "getArity", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "compiler.common"})
    public static final class KindWithArity {
        @NotNull
        private final FunctionTypeKind kind;
        private final int arity;

        public KindWithArity(@NotNull FunctionTypeKind kind, int arity) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.kind = kind;
            this.arity = arity;
        }

        @NotNull
        public final FunctionTypeKind getKind() {
            return this.kind;
        }

        public final int getArity() {
            return this.arity;
        }

        @NotNull
        public final FunctionTypeKind component1() {
            return this.kind;
        }

        public final int component2() {
            return this.arity;
        }

        @NotNull
        public final KindWithArity copy(@NotNull FunctionTypeKind kind, int arity) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return new KindWithArity(kind, arity);
        }

        public static /* synthetic */ KindWithArity copy$default(KindWithArity kindWithArity, FunctionTypeKind functionTypeKind, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                functionTypeKind = kindWithArity.kind;
            }
            if ((n3 & 2) != 0) {
                n2 = kindWithArity.arity;
            }
            return kindWithArity.copy(functionTypeKind, n2);
        }

        @NotNull
        public String toString() {
            return "KindWithArity(kind=" + this.kind + ", arity=" + this.arity + ')';
        }

        public int hashCode() {
            int result2 = this.kind.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.arity);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KindWithArity)) {
                return false;
            }
            KindWithArity kindWithArity = (KindWithArity)other;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)kindWithArity.kind)) {
                return false;
            }
            return this.arity == kindWithArity.arity;
        }
    }
}

